/*
 * Decompiled with CFR 0.152.
 */
package com.barchart.udt;

import com.barchart.udt.net.NetServerSocketUDT;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppServer {
    static Logger log = LoggerFactory.getLogger(AppServer.class);

    public static void main(String[] args) throws IOException {
        int port = 9000;
        if (args.length > 1) {
            System.out.println("usage: appserver [server_port]");
            return;
        }
        if (args.length == 1) {
            port = Integer.parseInt(args[0]);
        }
        NetServerSocketUDT acceptorSocket = new NetServerSocketUDT();
        acceptorSocket.bind(new InetSocketAddress("0.0.0.0", port), 256);
        System.out.printf("server is ready at port: %d\n", port);
        while (true) {
            final Socket clientSocket = acceptorSocket.accept();
            Executors.newSingleThreadExecutor().submit(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return AppServer.clientTask(clientSocket);
                }
            });
        }
    }

    public static boolean clientTask(Socket clientSocket) {
        byte[] data = new byte[10000];
        try {
            InputStream is = clientSocket.getInputStream();
            block2: while (true) {
                int remain = data.length;
                while (true) {
                    if (remain <= 0) continue block2;
                    int ret = is.read(data, data.length - remain, remain);
                    remain -= ret;
                }
                break;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
    }
}

