/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v120.network.model;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.v120.network.model.RequestId;
import org.openqa.selenium.devtools.v120.network.model.TrustTokenOperationType;
import org.openqa.selenium.json.JsonInput;

@Beta
public class TrustTokenOperationDone {
    private final Status status;
    private final TrustTokenOperationType type;
    private final RequestId requestId;
    private final Optional<String> topLevelOrigin;
    private final Optional<String> issuerOrigin;
    private final Optional<Integer> issuedTokenCount;

    public TrustTokenOperationDone(Status status, TrustTokenOperationType type, RequestId requestId, Optional<String> topLevelOrigin, Optional<String> issuerOrigin, Optional<Integer> issuedTokenCount) {
        this.status = Objects.requireNonNull(status, "status is required");
        this.type = Objects.requireNonNull(type, "type is required");
        this.requestId = Objects.requireNonNull(requestId, "requestId is required");
        this.topLevelOrigin = topLevelOrigin;
        this.issuerOrigin = issuerOrigin;
        this.issuedTokenCount = issuedTokenCount;
    }

    public Status getStatus() {
        return this.status;
    }

    public TrustTokenOperationType getType() {
        return this.type;
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public Optional<String> getTopLevelOrigin() {
        return this.topLevelOrigin;
    }

    public Optional<String> getIssuerOrigin() {
        return this.issuerOrigin;
    }

    public Optional<Integer> getIssuedTokenCount() {
        return this.issuedTokenCount;
    }

    private static TrustTokenOperationDone fromJson(JsonInput input) {
        Status status = null;
        TrustTokenOperationType type = null;
        RequestId requestId = null;
        Optional<String> topLevelOrigin = Optional.empty();
        Optional<String> issuerOrigin = Optional.empty();
        Optional<Integer> issuedTokenCount = Optional.empty();
        input.beginObject();
        block16: while (input.hasNext()) {
            switch (input.nextName()) {
                case "status": {
                    status = Status.fromString(input.nextString());
                    continue block16;
                }
                case "type": {
                    type = (TrustTokenOperationType)((Object)input.read(TrustTokenOperationType.class));
                    continue block16;
                }
                case "requestId": {
                    requestId = (RequestId)input.read(RequestId.class);
                    continue block16;
                }
                case "topLevelOrigin": {
                    topLevelOrigin = Optional.ofNullable(input.nextString());
                    continue block16;
                }
                case "issuerOrigin": {
                    issuerOrigin = Optional.ofNullable(input.nextString());
                    continue block16;
                }
                case "issuedTokenCount": {
                    issuedTokenCount = Optional.ofNullable(input.nextNumber().intValue());
                    continue block16;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new TrustTokenOperationDone(status, type, requestId, topLevelOrigin, issuerOrigin, issuedTokenCount);
    }

    public static enum Status {
        OK("Ok"),
        INVALIDARGUMENT("InvalidArgument"),
        MISSINGISSUERKEYS("MissingIssuerKeys"),
        FAILEDPRECONDITION("FailedPrecondition"),
        RESOURCEEXHAUSTED("ResourceExhausted"),
        ALREADYEXISTS("AlreadyExists"),
        UNAVAILABLE("Unavailable"),
        UNAUTHORIZED("Unauthorized"),
        BADRESPONSE("BadResponse"),
        INTERNALERROR("InternalError"),
        UNKNOWNERROR("UnknownError"),
        FULFILLEDLOCALLY("FulfilledLocally");

        private String value;

        private Status(String value) {
            this.value = value;
        }

        public static Status fromString(String s) {
            return Arrays.stream(Status.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within Status "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static Status fromJson(JsonInput input) {
            return Status.fromString(input.nextString());
        }
    }
}

