/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.fetcher;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.nutch.parse.Outlink;

public class FetcherThreadEvent
implements Serializable {
    private PublishEventType eventType;
    private Map<String, Object> eventData;
    private String url;
    private Long timestamp;

    public FetcherThreadEvent(PublishEventType eventType, String url) {
        this.eventType = eventType;
        this.url = url;
        this.timestamp = System.currentTimeMillis();
    }

    public PublishEventType getEventType() {
        return this.eventType;
    }

    public void setEventType(PublishEventType eventType) {
        this.eventType = eventType;
    }

    public Map<String, Object> getEventData() {
        return this.eventData;
    }

    public void setEventData(Map<String, Object> eventData) {
        this.eventData = eventData;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void addEventData(String key, Object value) {
        if (this.eventData == null) {
            this.eventData = new HashMap<String, Object>();
        }
        this.eventData.put(key, value);
    }

    public void addOutlinksToEventData(Collection<Outlink> links) {
        ArrayList outlinkList = new ArrayList();
        for (Outlink link : links) {
            HashMap<String, String> outlink = new HashMap<String, String>();
            outlink.put("url", link.getToUrl());
            outlink.put("anchor", link.getAnchor());
            outlinkList.add(outlink);
        }
        this.addEventData("outlinks", outlinkList);
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public static enum PublishEventType {
        START,
        END,
        REPORT;

    }
}

