/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.dwg;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TSFBuilder;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.dwg.AbstractDWGParser;
import org.apache.tika.parser.dwg.DWGParserConfig;
import org.apache.tika.parser.dwg.DWGReadFormatRemover;
import org.apache.tika.parser.dwg.JulianDateUtil;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.tika.utils.ExceptionUtils;
import org.apache.tika.utils.FileProcessResult;
import org.apache.tika.utils.ProcessUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import shaded.org.apache.commons.io.FileUtils;

public class DWGReadParser
extends AbstractDWGParser {
    private static final Logger LOG = LoggerFactory.getLogger(DWGReadParser.class);
    private static final long serialVersionUID = 7983127145030096837L;
    private static MediaType TYPE = MediaType.image((String)"vnd.dwg");

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return Collections.singleton(TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        this.configure(context);
        DWGParserConfig dwgc = (DWGParserConfig)context.get(DWGParserConfig.class);
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        UUID uuid = UUID.randomUUID();
        File tmpFileOut = Files.createTempFile(uuid + "dwgreadout", ".json", new FileAttribute[0]).toFile();
        File tmpFileOutCleaned = Files.createTempFile(uuid + "dwgreadoutclean", ".json", new FileAttribute[0]).toFile();
        File tmpFileIn = Files.createTempFile(uuid + "dwgreadin", ".dwg", new FileAttribute[0]).toFile();
        try {
            JsonParser jParser;
            block29: {
                FileUtils.copyInputStreamToFile(stream, tmpFileIn);
                List<String> command = Arrays.asList(dwgc.getDwgReadExecutable(), "-O", "JSON", "-o", tmpFileOut.getCanonicalPath(), tmpFileIn.getCanonicalPath());
                ProcessBuilder pb = new ProcessBuilder(new String[0]).command(command);
                LOG.info("About to call DWGRead: " + command.toString());
                FileProcessResult fpr = ProcessUtils.execute((ProcessBuilder)pb, (long)dwgc.getDwgReadTimeout(), (int)10000, (int)10000);
                LOG.info("DWGRead Exit code is: " + fpr.getExitValue());
                if (fpr.getExitValue() == 0) {
                    if (dwgc.isCleanDwgReadOutput()) {
                        LOG.debug("Cleaning Json Output - Replace: " + dwgc.getCleanDwgReadRegexToReplace() + " with: " + dwgc.getCleanDwgReadReplaceWith());
                        try (BufferedReader br = new BufferedReader(new InputStreamReader(Files.newInputStream(tmpFileOut.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));
                             BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tmpFileOutCleaned, true), StandardCharsets.UTF_8), 32768);){
                            String sCurrentLine;
                            while ((sCurrentLine = br.readLine()) != null) {
                                sCurrentLine = sCurrentLine.replaceAll(dwgc.getCleanDwgReadRegexToReplace(), dwgc.getCleanDwgReadReplaceWith()).replaceAll("\\bnan\\b", " 0,").replaceAll("\\.,", " \\. ,") + "\n";
                                out.write(sCurrentLine);
                            }
                            break block29;
                        }
                        finally {
                            FileUtils.deleteQuietly(tmpFileIn);
                            FileUtils.deleteQuietly(tmpFileOut);
                            tmpFileOut = tmpFileOutCleaned;
                        }
                    }
                    LOG.debug("Json wasn't cleaned, if json parsing fails consider reviewing dwgread json output to check it's valid");
                } else {
                    if (fpr.isTimeout()) {
                        throw new TikaException("DWGRead Failed - Timeout setting exceeded current setting of " + dwgc.getDwgReadTimeout());
                    }
                    throw new TikaException("DWGRead Failed - Exit Code is:" + fpr.getExitValue() + " Exe error is: " + fpr.getStderr());
                }
            }
            Object jfactory = ((TSFBuilder)JsonFactory.builder().enable(JsonReadFeature.ALLOW_MISSING_VALUES, JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS, JsonReadFeature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, JsonReadFeature.ALLOW_UNQUOTED_FIELD_NAMES, JsonReadFeature.ALLOW_TRAILING_COMMA, JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS, JsonReadFeature.ALLOW_LEADING_ZEROS_FOR_NUMBERS)).build();
            try {
                jParser = ((JsonFactory)jfactory).createParser(tmpFileOut);
            }
            catch (JsonParseException e1) {
                throw new TikaException("Failed to parse Json: " + ExceptionUtils.getStackTrace((Throwable)e1));
            }
            catch (IOException e1) {
                throw new TikaException("Failed to read json file: " + ExceptionUtils.getStackTrace((Throwable)e1));
            }
            DWGReadFormatRemover dwgReadFormatRemover = new DWGReadFormatRemover();
            JsonToken nextToken = jParser.nextToken();
            while ((nextToken = jParser.nextToken()) != JsonToken.END_OBJECT) {
                if (nextToken != JsonToken.FIELD_NAME) continue;
                String nextFieldName = jParser.currentName();
                nextToken = jParser.nextToken();
                if (!nextToken.isStructStart()) continue;
                if ("OBJECTS".equals(nextFieldName)) {
                    while (jParser.nextToken() != JsonToken.END_ARRAY) {
                        this.parseDwgObject(jParser, nextTextValue -> {
                            try {
                                xhtml.characters(dwgReadFormatRemover.cleanupDwgString((String)nextTextValue));
                                xhtml.newline();
                            }
                            catch (SAXException e) {
                                LOG.error("Could not write next text value {} to xhtml stream", nextTextValue);
                            }
                        });
                    }
                    continue;
                }
                if ("FILEHEADER".equals(nextFieldName)) {
                    this.parseHeader(jParser, metadata);
                    continue;
                }
                if ("SummaryInfo".equals(nextFieldName)) {
                    this.parseSummaryInfo(jParser, metadata);
                    continue;
                }
                jParser.skipChildren();
            }
            jParser.close();
        }
        finally {
            FileUtils.deleteQuietly(tmpFileOut);
            FileUtils.deleteQuietly(tmpFileIn);
            FileUtils.deleteQuietly(tmpFileOutCleaned);
        }
        xhtml.endDocument();
    }

    private void parseDwgObject(JsonParser jsonParser, Consumer<String> textConsumer) throws IOException {
        JsonToken nextToken;
        while ((nextToken = jsonParser.nextToken()) != JsonToken.END_OBJECT) {
            String textVal;
            if (nextToken != JsonToken.FIELD_NAME) continue;
            String nextFieldName = jsonParser.currentName();
            nextToken = jsonParser.nextToken();
            if (nextToken.isStructStart()) {
                jsonParser.skipChildren();
                continue;
            }
            if (!nextToken.isScalarValue()) continue;
            if ("text".equals(nextFieldName)) {
                textVal = jsonParser.getText();
                if (!StringUtils.isNotBlank(textVal)) continue;
                textConsumer.accept(textVal);
                continue;
            }
            if (!"text_value".equals(nextFieldName) || !StringUtils.isNotBlank(textVal = jsonParser.getText())) continue;
            textConsumer.accept(textVal);
        }
    }

    private void parseHeader(JsonParser jsonParser, Metadata metadata) throws IOException {
        JsonToken nextToken;
        while ((nextToken = jsonParser.nextToken()) != JsonToken.END_OBJECT) {
            if (nextToken != JsonToken.FIELD_NAME) continue;
            String nextFieldName = jsonParser.currentName();
            nextToken = jsonParser.nextToken();
            if (nextToken.isStructStart()) {
                jsonParser.skipChildren();
                continue;
            }
            if (!nextToken.isScalarValue()) continue;
            metadata.set(nextFieldName, jsonParser.getText());
        }
    }

    private void parseSummaryInfo(JsonParser jsonParser, Metadata metadata) throws IOException {
        JsonToken nextToken;
        while ((nextToken = jsonParser.nextToken()) != JsonToken.END_OBJECT) {
            String textVal;
            if (nextToken != JsonToken.FIELD_NAME) continue;
            String nextFieldName = jsonParser.currentName();
            nextToken = jsonParser.nextToken();
            if (nextToken.isStructStart()) {
                if ("TDCREATE".equals(nextFieldName) || "TDUPDATE".equals(nextFieldName)) {
                    jsonParser.nextToken();
                    long julianDay = jsonParser.getValueAsLong();
                    jsonParser.nextToken();
                    long millisecondsIntoDay = jsonParser.getValueAsLong();
                    Instant instant = JulianDateUtil.toInstant(julianDay, millisecondsIntoDay);
                    jsonParser.nextToken();
                    if ("TDCREATE".equals(nextFieldName)) {
                        metadata.set(TikaCoreProperties.CREATED, instant.toString());
                        continue;
                    }
                    metadata.set(TikaCoreProperties.MODIFIED, instant.toString());
                    continue;
                }
                jsonParser.skipChildren();
                continue;
            }
            if (!nextToken.isScalarValue() || !StringUtils.isNotBlank(textVal = jsonParser.getText())) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Summary Info - {} = {}", (Object)nextFieldName, (Object)textVal);
            }
            if ("TITLE".equals(nextFieldName)) {
                metadata.set(TikaCoreProperties.TITLE, textVal);
                continue;
            }
            if ("LASTSAVEDBY".equals(nextFieldName)) {
                metadata.set(TikaCoreProperties.MODIFIER, textVal);
                continue;
            }
            if (StringUtils.startsWithIgnoreCase(nextFieldName, "unknown")) continue;
            metadata.set(nextFieldName, textVal);
        }
    }
}

