/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.bidi;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.openqa.selenium.UsernameAndPassword;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.bidi.BiDi;
import org.openqa.selenium.bidi.Command;
import org.openqa.selenium.bidi.Event;
import org.openqa.selenium.bidi.HasBiDi;
import org.openqa.selenium.bidi.network.AddInterceptParameters;
import org.openqa.selenium.bidi.network.BeforeRequestSent;
import org.openqa.selenium.bidi.network.FetchError;
import org.openqa.selenium.bidi.network.ResponseDetails;
import org.openqa.selenium.internal.Require;

public class Network
implements AutoCloseable {
    private final Set<String> browsingContextIds;
    private final BiDi bidi;
    private final Event<BeforeRequestSent> beforeRequestSentEvent = new Event<BeforeRequestSent>("network.beforeRequestSent", BeforeRequestSent::fromJsonMap);
    private final Event<FetchError> fetchErrorEvent = new Event<FetchError>("network.fetchError", FetchError::fromJsonMap);
    private final Event<ResponseDetails> responseStarted = new Event<ResponseDetails>("network.responseStarted", ResponseDetails::fromJsonMap);
    private final Event<ResponseDetails> responseCompleted = new Event<ResponseDetails>("network.responseStarted", ResponseDetails::fromJsonMap);
    private final Event<ResponseDetails> authRequired = new Event<ResponseDetails>("network.authRequired", ResponseDetails::fromJsonMap);

    public Network(WebDriver driver) {
        this(new HashSet<String>(), driver);
    }

    public Network(String browsingContextId, WebDriver driver) {
        this(Collections.singleton((String)Require.nonNull((String)"Browsing context id", (Object)browsingContextId)), driver);
    }

    public Network(Set<String> browsingContextIds, WebDriver driver) {
        Require.nonNull((String)"WebDriver", (Object)driver);
        Require.nonNull((String)"Browsing context id list", browsingContextIds);
        if (!(driver instanceof HasBiDi)) {
            throw new IllegalArgumentException("WebDriver instance must support BiDi protocol");
        }
        this.bidi = ((HasBiDi)driver).getBiDi();
        this.browsingContextIds = browsingContextIds;
    }

    public String addIntercept(AddInterceptParameters parameters) {
        return this.bidi.send(new Command<String>("network.addIntercept", parameters.toMap(), jsonInput -> {
            Map result = (Map)jsonInput.read(Map.class);
            return (String)result.get("intercept");
        }));
    }

    public void removeIntercept(String interceptId) {
        this.bidi.send(new Command("network.removeIntercept", Map.of("intercept", interceptId)));
    }

    public void continueWithAuth(String requestId, UsernameAndPassword usernameAndPassword) {
        this.bidi.send(new Command("network.continueWithAuth", Map.of("request", requestId, "action", "provideCredentials", "credentials", Map.of("type", "password", "username", usernameAndPassword.username(), "password", usernameAndPassword.password()))));
    }

    public void continueWithAuthNoCredentials(String requestId) {
        this.bidi.send(new Command("network.continueWithAuth", Map.of("request", requestId, "action", "default")));
    }

    public void cancelAuth(String requestId) {
        this.bidi.send(new Command("network.continueWithAuth", Map.of("request", requestId, "action", "cancel")));
    }

    public void failRequest(String requestId) {
        this.bidi.send(new Command("network.failRequest", Map.of("request", requestId)));
    }

    public void onBeforeRequestSent(Consumer<BeforeRequestSent> consumer) {
        if (this.browsingContextIds.isEmpty()) {
            this.bidi.addListener(this.beforeRequestSentEvent, consumer);
        } else {
            this.bidi.addListener(this.browsingContextIds, this.beforeRequestSentEvent, consumer);
        }
    }

    public void onFetchError(Consumer<FetchError> consumer) {
        if (this.browsingContextIds.isEmpty()) {
            this.bidi.addListener(this.fetchErrorEvent, consumer);
        } else {
            this.bidi.addListener(this.browsingContextIds, this.fetchErrorEvent, consumer);
        }
    }

    public void onResponseStarted(Consumer<ResponseDetails> consumer) {
        if (this.browsingContextIds.isEmpty()) {
            this.bidi.addListener(this.responseStarted, consumer);
        } else {
            this.bidi.addListener(this.browsingContextIds, this.responseStarted, consumer);
        }
    }

    public void onResponseCompleted(Consumer<ResponseDetails> consumer) {
        if (this.browsingContextIds.isEmpty()) {
            this.bidi.addListener(this.responseCompleted, consumer);
        } else {
            this.bidi.addListener(this.browsingContextIds, this.responseStarted, consumer);
        }
    }

    public void onAuthRequired(Consumer<ResponseDetails> consumer) {
        if (this.browsingContextIds.isEmpty()) {
            this.bidi.addListener(this.authRequired, consumer);
        } else {
            this.bidi.addListener(this.browsingContextIds, this.authRequired, consumer);
        }
    }

    @Override
    public void close() {
        this.bidi.clearListener(this.beforeRequestSentEvent);
        this.bidi.clearListener(this.responseStarted);
        this.bidi.clearListener(this.responseCompleted);
        this.bidi.clearListener(this.authRequired);
    }
}

