/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.util.geometry;

import com.gargoylesoftware.htmlunit.util.geometry.Shape2D;

public class Rectangle2D
implements Shape2D {
    private double left_;
    private double top_;
    private double right_;
    private double bottom_;

    public Rectangle2D(double x1, double y1, double x2, double y2) {
        if (x1 < x2) {
            this.left_ = x1;
            this.right_ = x2;
        } else {
            this.left_ = x2;
            this.right_ = x1;
        }
        if (y1 > y2) {
            this.top_ = y1;
            this.bottom_ = y2;
        } else {
            this.top_ = y2;
            this.bottom_ = y1;
        }
    }

    public double getLeft() {
        return this.left_;
    }

    public double getBottom() {
        return this.bottom_;
    }

    @Override
    public boolean contains(double x, double y) {
        return x >= this.left_ && x <= this.right_ && y <= this.top_ && y >= this.bottom_;
    }

    public void extend(double x, double y) {
        if (x > this.right_) {
            this.right_ = x;
        } else if (x < this.left_) {
            this.left_ = x;
        }
        if (y > this.top_) {
            this.top_ = y;
        } else if (y < this.bottom_) {
            this.bottom_ = y;
        }
    }

    @Override
    public boolean isEmpty() {
        return Math.abs(this.top_ - this.bottom_) < 1.0E-7 || Math.abs(this.left_ - this.right_) < 1.0E-7;
    }

    public String toString() {
        return "Rectangle2D [left_=" + this.left_ + ", top_=" + this.top_ + ", right_=" + this.right_ + ", bottom_=" + this.bottom_ + "]";
    }
}

