/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.provider.flow;

import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.registry.bucket.Bucket;
import org.apache.nifi.registry.flow.FlowSnapshotContext;
import org.apache.nifi.registry.flow.VersionedFlow;
import org.apache.nifi.registry.flow.VersionedFlowSnapshotMetadata;

public class StandardFlowSnapshotContext
implements FlowSnapshotContext {
    private final String bucketId;
    private final String bucketName;
    private final String flowId;
    private final String flowName;
    private final String flowDescription;
    private final int version;
    private final String comments;
    private final String author;
    private final long snapshotTimestamp;

    private StandardFlowSnapshotContext(Builder builder) {
        this.bucketId = builder.bucketId;
        this.bucketName = builder.bucketName;
        this.flowId = builder.flowId;
        this.flowName = builder.flowName;
        this.flowDescription = builder.flowDescription;
        this.version = builder.version;
        this.comments = builder.comments;
        this.author = builder.author;
        this.snapshotTimestamp = builder.snapshotTimestamp;
        Validate.notBlank((CharSequence)this.bucketId);
        Validate.notBlank((CharSequence)this.bucketName);
        Validate.notBlank((CharSequence)this.flowId);
        Validate.notBlank((CharSequence)this.flowName);
        Validate.isTrue((this.version > 0 ? 1 : 0) != 0);
        Validate.isTrue((this.snapshotTimestamp > 0L ? 1 : 0) != 0);
    }

    public String getBucketId() {
        return this.bucketId;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getFlowId() {
        return this.flowId;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public String getFlowDescription() {
        return this.flowDescription;
    }

    public int getVersion() {
        return this.version;
    }

    public String getComments() {
        return this.comments;
    }

    public long getSnapshotTimestamp() {
        return this.snapshotTimestamp;
    }

    public String getAuthor() {
        return this.author;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StandardFlowSnapshotContext that = (StandardFlowSnapshotContext)o;
        return this.version == that.version && this.snapshotTimestamp == that.snapshotTimestamp && Objects.equals(this.bucketId, that.bucketId) && Objects.equals(this.bucketName, that.bucketName) && Objects.equals(this.flowId, that.flowId) && Objects.equals(this.flowName, that.flowName) && Objects.equals(this.comments, that.comments) && Objects.equals(this.author, that.author);
    }

    public int hashCode() {
        return Objects.hash(this.bucketId, this.bucketName, this.flowId, this.flowName, this.version, this.comments, this.author, this.snapshotTimestamp);
    }

    public static class Builder {
        private String bucketId;
        private String bucketName;
        private String flowId;
        private String flowName;
        private String flowDescription;
        private int version;
        private String comments;
        private String author;
        private long snapshotTimestamp;

        public Builder() {
        }

        public Builder(Bucket bucket, VersionedFlow versionedFlow, VersionedFlowSnapshotMetadata snapshotMetadata) {
            this.bucketId(bucket.getIdentifier());
            this.bucketName(bucket.getName());
            this.flowId(snapshotMetadata.getFlowIdentifier());
            this.flowName(versionedFlow.getName());
            this.flowDescription(versionedFlow.getDescription());
            this.version(snapshotMetadata.getVersion());
            this.comments(snapshotMetadata.getComments());
            this.author(snapshotMetadata.getAuthor());
            this.snapshotTimestamp(snapshotMetadata.getTimestamp());
        }

        public Builder bucketId(String bucketId) {
            this.bucketId = bucketId;
            return this;
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder flowId(String flowId) {
            this.flowId = flowId;
            return this;
        }

        public Builder flowName(String flowName) {
            this.flowName = flowName;
            return this;
        }

        public Builder flowDescription(String flowDescription) {
            this.flowDescription = flowDescription;
            return this;
        }

        public Builder version(int version) {
            this.version = version;
            return this;
        }

        public Builder comments(String comments) {
            this.comments = comments;
            return this;
        }

        public Builder author(String author) {
            this.author = author;
            return this;
        }

        public Builder snapshotTimestamp(long snapshotTimestamp) {
            this.snapshotTimestamp = snapshotTimestamp;
            return this;
        }

        public StandardFlowSnapshotContext build() {
            return new StandardFlowSnapshotContext(this);
        }
    }
}

