/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization.method;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.core.MethodClassKey;
import org.springframework.security.access.annotation.Secured;
import org.springframework.security.authorization.AuthoritiesAuthorizationManager;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.annotation.SecurityAnnotationScanner;
import org.springframework.security.core.annotation.SecurityAnnotationScanners;
import org.springframework.util.Assert;

public final class SecuredAuthorizationManager
implements AuthorizationManager<MethodInvocation> {
    private AuthorizationManager<Collection<String>> authoritiesAuthorizationManager = new AuthoritiesAuthorizationManager();
    private final Map<MethodClassKey, Set<String>> cachedAuthorities = new ConcurrentHashMap<MethodClassKey, Set<String>>();
    private final SecurityAnnotationScanner<Secured> scanner = SecurityAnnotationScanners.requireUnique(Secured.class);

    public void setAuthoritiesAuthorizationManager(AuthorizationManager<Collection<String>> authoritiesAuthorizationManager) {
        Assert.notNull(authoritiesAuthorizationManager, (String)"authoritiesAuthorizationManager cannot be null");
        this.authoritiesAuthorizationManager = authoritiesAuthorizationManager;
    }

    @Override
    @Deprecated
    public AuthorizationDecision check(Supplier<Authentication> authentication, MethodInvocation mi) {
        Set<String> authorities = this.getAuthorities(mi);
        return authorities.isEmpty() ? null : this.authoritiesAuthorizationManager.check(authentication, authorities);
    }

    private Set<String> getAuthorities(MethodInvocation methodInvocation) {
        Method method = methodInvocation.getMethod();
        Object target = methodInvocation.getThis();
        Class<?> targetClass = target != null ? target.getClass() : null;
        MethodClassKey cacheKey = new MethodClassKey(method, targetClass);
        return this.cachedAuthorities.computeIfAbsent(cacheKey, k -> this.resolveAuthorities(method, targetClass));
    }

    private Set<String> resolveAuthorities(Method method, Class<?> targetClass) {
        Secured secured = this.findSecuredAnnotation(method, targetClass);
        return secured != null ? Set.of(secured.value()) : Collections.emptySet();
    }

    private Secured findSecuredAnnotation(Method method, Class<?> targetClass) {
        Class<?> targetClassToUse = targetClass != null ? targetClass : method.getDeclaringClass();
        return this.scanner.scan(method, targetClassToUse);
    }
}

