/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap.command;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.apache.nifi.minifi.bootstrap.BootstrapCommand;
import org.apache.nifi.minifi.bootstrap.MiNiFiParameters;
import org.apache.nifi.minifi.bootstrap.RunMiNiFi;
import org.apache.nifi.minifi.bootstrap.command.CommandRunner;
import org.apache.nifi.minifi.bootstrap.command.CompositeCommandRunner;
import org.apache.nifi.minifi.bootstrap.command.DumpRunner;
import org.apache.nifi.minifi.bootstrap.command.EnvRunner;
import org.apache.nifi.minifi.bootstrap.command.FlowStatusRunner;
import org.apache.nifi.minifi.bootstrap.command.StartRunner;
import org.apache.nifi.minifi.bootstrap.command.StatusRunner;
import org.apache.nifi.minifi.bootstrap.command.StopRunner;
import org.apache.nifi.minifi.bootstrap.configuration.ConfigurationChangeListener;
import org.apache.nifi.minifi.bootstrap.service.BootstrapFileProvider;
import org.apache.nifi.minifi.bootstrap.service.CurrentPortProvider;
import org.apache.nifi.minifi.bootstrap.service.GracefulShutdownParameterProvider;
import org.apache.nifi.minifi.bootstrap.service.MiNiFiCommandSender;
import org.apache.nifi.minifi.bootstrap.service.MiNiFiExecCommandProvider;
import org.apache.nifi.minifi.bootstrap.service.MiNiFiStatusProvider;
import org.apache.nifi.minifi.bootstrap.service.MiNiFiStdLogHandler;
import org.apache.nifi.minifi.bootstrap.service.PeriodicStatusReporterManager;
import org.apache.nifi.minifi.bootstrap.util.ProcessUtils;

public class CommandRunnerFactory {
    private final MiNiFiCommandSender miNiFiCommandSender;
    private final CurrentPortProvider currentPortProvider;
    private final MiNiFiParameters miNiFiParameters;
    private final MiNiFiStatusProvider miNiFiStatusProvider;
    private final PeriodicStatusReporterManager periodicStatusReporterManager;
    private final BootstrapFileProvider bootstrapFileProvider;
    private final MiNiFiStdLogHandler miNiFiStdLogHandler;
    private final File bootstrapConfigFile;
    private final RunMiNiFi runMiNiFi;
    private final GracefulShutdownParameterProvider gracefulShutdownParameterProvider;
    private final MiNiFiExecCommandProvider miNiFiExecCommandProvider;
    private final ProcessUtils processUtils;
    private final ConfigurationChangeListener configurationChangeListener;

    public CommandRunnerFactory(MiNiFiCommandSender miNiFiCommandSender, CurrentPortProvider currentPortProvider, MiNiFiParameters miNiFiParameters, MiNiFiStatusProvider miNiFiStatusProvider, PeriodicStatusReporterManager periodicStatusReporterManager, BootstrapFileProvider bootstrapFileProvider, MiNiFiStdLogHandler miNiFiStdLogHandler, File bootstrapConfigFile, RunMiNiFi runMiNiFi, GracefulShutdownParameterProvider gracefulShutdownParameterProvider, MiNiFiExecCommandProvider miNiFiExecCommandProvider, ProcessUtils processUtils, ConfigurationChangeListener configurationChangeListener) {
        this.miNiFiCommandSender = miNiFiCommandSender;
        this.currentPortProvider = currentPortProvider;
        this.miNiFiParameters = miNiFiParameters;
        this.miNiFiStatusProvider = miNiFiStatusProvider;
        this.periodicStatusReporterManager = periodicStatusReporterManager;
        this.bootstrapFileProvider = bootstrapFileProvider;
        this.miNiFiStdLogHandler = miNiFiStdLogHandler;
        this.bootstrapConfigFile = bootstrapConfigFile;
        this.runMiNiFi = runMiNiFi;
        this.gracefulShutdownParameterProvider = gracefulShutdownParameterProvider;
        this.miNiFiExecCommandProvider = miNiFiExecCommandProvider;
        this.processUtils = processUtils;
        this.configurationChangeListener = configurationChangeListener;
    }

    public CommandRunner getRunner(BootstrapCommand command) {
        CommandRunner commandRunner = switch (command) {
            case BootstrapCommand.START, BootstrapCommand.RUN -> new StartRunner(this.currentPortProvider, this.bootstrapFileProvider, this.periodicStatusReporterManager, this.miNiFiStdLogHandler, this.miNiFiParameters, this.bootstrapConfigFile, this.runMiNiFi, this.miNiFiExecCommandProvider, this.configurationChangeListener);
            case BootstrapCommand.STOP -> new StopRunner(this.bootstrapFileProvider, this.miNiFiParameters, this.miNiFiCommandSender, this.currentPortProvider, this.gracefulShutdownParameterProvider, this.processUtils);
            case BootstrapCommand.STATUS -> new StatusRunner(this.miNiFiParameters, this.miNiFiStatusProvider);
            case BootstrapCommand.RESTART -> new CompositeCommandRunner(this.getRestartServices());
            case BootstrapCommand.DUMP -> new DumpRunner(this.miNiFiCommandSender, this.currentPortProvider);
            case BootstrapCommand.ENV -> new EnvRunner(this.miNiFiCommandSender, this.currentPortProvider);
            case BootstrapCommand.FLOWSTATUS -> new FlowStatusRunner(this.periodicStatusReporterManager);
            default -> throw new IllegalArgumentException("Unknown MiNiFi bootstrap command");
        };
        return commandRunner;
    }

    private List<CommandRunner> getRestartServices() {
        LinkedList<CommandRunner> compositeList = new LinkedList<CommandRunner>();
        compositeList.add(new StopRunner(this.bootstrapFileProvider, this.miNiFiParameters, this.miNiFiCommandSender, this.currentPortProvider, this.gracefulShutdownParameterProvider, this.processUtils));
        compositeList.add(new StartRunner(this.currentPortProvider, this.bootstrapFileProvider, this.periodicStatusReporterManager, this.miNiFiStdLogHandler, this.miNiFiParameters, this.bootstrapConfigFile, this.runMiNiFi, this.miNiFiExecCommandProvider, this.configurationChangeListener));
        return compositeList;
    }
}

