/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries;

import java.awt.BorderLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.SourceUtils;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;


/**
 *
 * @author  blaha
 */
public class SendEmailPanel extends javax.swing.JPanel implements ChangeListener {

    public static final String IS_VALID = "SendEmailPanel_isValid"; //NOI18N

    private final ServiceLocatorStrategyPanel slcPanel;
    private final ChangeSupport changeSupport = new ChangeSupport(this);
    private String errorMsg = null;

    /** Creates new form SendEmailPanel */
    public SendEmailPanel(String lastLocator, ClasspathInfo cpInfo) {
        initComponents();

        changeSupport.addChangeListener(this);
        scanningLabel.setVisible(SourceUtils.isScanInProgress());

        slcPanel = new ServiceLocatorStrategyPanel(lastLocator, cpInfo);
        serviceLocatorPanel.add(slcPanel,BorderLayout.CENTER);
        slcPanel.addPropertyChangeListener(new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                changeSupport.fireChange();
            }
        });
        jndiNameTextField.getDocument().addDocumentListener(new DocumentListener() {
            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                fireChange();
            }
            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                fireChange();
            }
            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                fireChange();
            }
            private void fireChange() {
                changeSupport.fireChange();
            }
        });
    }
    
    public String getServiceLocator(){
        return slcPanel.classSelected();
    }
    
    public String getJndiName(){
        return jndiNameTextField.getText();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jndiNameLabel = new javax.swing.JLabel();
        jndiNameTextField = new javax.swing.JTextField();
        serviceLocatorPanel = new javax.swing.JPanel();
        scanningLabel = new javax.swing.JLabel();

        org.openide.awt.Mnemonics.setLocalizedText(jndiNameLabel, org.openide.util.NbBundle.getBundle(SendEmailPanel.class).getString("LBL_jndiName")); // NOI18N

        jndiNameTextField.setColumns(30);

        serviceLocatorPanel.setLayout(new java.awt.BorderLayout());

        scanningLabel.setFont(new java.awt.Font("Dialog", 2, 12)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(scanningLabel, org.openide.util.NbBundle.getMessage(SendEmailPanel.class, "LBL_ScanningInProgress")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(serviceLocatorPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jndiNameLabel)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jndiNameTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 1, Short.MAX_VALUE))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(scanningLabel)
                        .addGap(0, 73, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(6, 6, 6)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jndiNameLabel)
                    .addComponent(jndiNameTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(serviceLocatorPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(scanningLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 15, javax.swing.GroupLayout.PREFERRED_SIZE))
        );

        getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(SendEmailPanel.class, "ACSD_SpecifyMailResource")); // NOI18N
        getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(SendEmailPanel.class, "ACSD_SpecifyMailResource")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jndiNameLabel;
    private javax.swing.JTextField jndiNameTextField;
    private javax.swing.JLabel scanningLabel;
    private javax.swing.JPanel serviceLocatorPanel;
    // End of variables declaration//GEN-END:variables
    
    protected boolean isEmptyJndiName() {
        return jndiNameTextField.getText().trim().equals("");
    }

    @NbBundle.Messages("sendEmailPanel.error.empty.jndi.name=JNDI name cannot be empty")
    String getErrorMessage() {
        if (!verifyComponents()) {
            return errorMsg;
        } else if (!slcPanel.verifyComponents()) {
            return slcPanel.getErrorMessage();
        } else {
            return null;
        }
    }

    private boolean verifyComponents() {
        if (isEmptyJndiName()) {
            errorMsg = Bundle.sendEmailPanel_error_empty_jndi_name();
            return false;
        } else {
            errorMsg = null;
            return true;
        }
    }

    public boolean valid() {
        return verifyComponents() && slcPanel.verifyComponents();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        // update scanning label visibility
        scanningLabel.setVisible(SourceUtils.isScanInProgress());

        if (valid()) {
            firePropertyChange(IS_VALID, false, true);
        } else {
            firePropertyChange(IS_VALID, true, false);
        }
    }
    
}
