/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support.ant;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.modules.project.ant.AntBasedProjectFactorySingleton;
import org.netbeans.modules.project.ant.ProjectLibraryProvider;
import org.netbeans.modules.project.ant.ProjectXMLCatalogReader;
import org.netbeans.modules.project.ant.ProjectXMLKnownChecksums;
import org.netbeans.modules.project.spi.intern.ProjectIDEServices;
import org.netbeans.modules.project.spi.intern.ProjectIDEServicesImplementation;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.netbeans.spi.project.CacheDirectoryProvider;
import org.netbeans.spi.project.ProjectState;
import org.netbeans.spi.project.support.ant.AntBasedProjectType;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.AuxiliaryPropertiesImpl;
import org.netbeans.spi.project.support.ant.Bundle;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ExtensibleMetadataProviderImpl;
import org.netbeans.spi.project.support.ant.GlobFileBuiltQuery;
import org.netbeans.spi.project.support.ant.ProjectProperties;
import org.netbeans.spi.project.support.ant.ProjectXmlSavedHook;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.SharabilityQueryImpl;
import org.netbeans.spi.project.support.ant.SimpleAntArtifact;
import org.netbeans.spi.queries.FileBuiltQueryImplementation;
import org.netbeans.spi.queries.SharabilityQueryImplementation;
import org.netbeans.spi.queries.SharabilityQueryImplementation2;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.RequestProcessor;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class AntProjectHelper {
    public static final String PROJECT_PROPERTIES_PATH = "nbproject/project.properties";
    public static final String PRIVATE_PROPERTIES_PATH = "nbproject/private/private.properties";
    public static final String PROJECT_XML_PATH = "nbproject/project.xml";
    public static final String PRIVATE_XML_PATH = "nbproject/private/private.xml";
    static final String PROJECT_NS = "http://www.netbeans.org/ns/project/1";
    static final String PRIVATE_NS = "http://www.netbeans.org/ns/project-private/1";
    private static final Logger LOG;
    private static RequestProcessor RP;
    private final FileObject dir;
    private final ProjectState state;
    private final AntBasedProjectType type;
    private static final Document NONEXISTENT;
    private Document projectXml;
    private boolean projectXmlValid;
    private Document privateXml;
    private boolean privateXmlValid;
    private final Set<String> modifiedMetadataPaths = new HashSet<String>();
    private Throwable addedProjectXmlPath;
    private final List<AntProjectListener> listeners = new ArrayList<AntProjectListener>();
    private final ProjectProperties properties;
    private final FileChangeListener fileListener;
    private final AtomicBoolean fileListenerSet = new AtomicBoolean(false);
    private final Set<FileSystem.AtomicAction> saveActions = Collections.newSetFromMap(new WeakHashMap());
    private Collection<? extends ProjectXmlSavedHook> pendingHook = null;
    private int pendingHookCount;
    static boolean QUIETLY_SWALLOW_XML_LOAD_ERRORS;
    private static final DocumentBuilder db;

    private AntProjectHelper(FileObject dir, Document projectXml, ProjectState state, AntBasedProjectType type) {
        this.dir = dir;
        assert (dir != null && FileUtil.toFile(dir) != null);
        this.state = state;
        assert (state != null);
        this.type = type;
        assert (type != null);
        this.projectXml = projectXml;
        this.projectXmlValid = true;
        assert (projectXml != null);
        this.properties = new ProjectProperties(this);
        this.fileListener = new FileListener();
    }

    private void lazyAttachFileListener() {
        if (this.fileListenerSet.compareAndSet(false, true)) {
            FileUtil.addFileChangeListener(this.fileListener, this.resolveFile(PROJECT_XML_PATH));
            FileUtil.addFileChangeListener(this.fileListener, this.resolveFile(PRIVATE_XML_PATH));
        }
    }

    AntBasedProjectType getType() {
        return this.type;
    }

    private Document getConfigurationXml(boolean shared) {
        Document xml;
        assert (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess());
        assert (Thread.holdsLock(this.modifiedMetadataPaths));
        this.lazyAttachFileListener();
        if (!(!shared ? this.privateXmlValid : this.projectXmlValid)) {
            String path = shared ? PROJECT_XML_PATH : PRIVATE_XML_PATH;
            Document _xml = this.loadXml(path);
            if (_xml != null && _xml != NONEXISTENT) {
                if (shared) {
                    this.projectXml = _xml;
                } else {
                    this.privateXml = _xml;
                }
            } else if (_xml == NONEXISTENT && !shared) {
                this.privateXml = null;
            }
        }
        if (!shared && this.privateXml == null) {
            this.privateXml = XMLUtil.createDocument("project-private", PRIVATE_NS, null, null);
        }
        if (shared) {
            this.projectXmlValid = true;
        } else {
            this.privateXmlValid = true;
        }
        Document document = xml = shared ? this.projectXml : this.privateXml;
        assert (xml != null) : "shared=" + shared + " projectXml=" + this.projectXml + " privateXml=" + this.privateXml + " projectXmlValid=" + this.projectXmlValid + " privateXmlValid=" + this.privateXmlValid;
        return xml;
    }

    private Document loadXml(String path) {
        block8: {
            assert (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess());
            assert (Thread.holdsLock(this.modifiedMetadataPaths));
            FileObject xml = this.dir.getFileObject(path);
            if (xml == null || !xml.isData()) {
                return NONEXISTENT;
            }
            File f = FileUtil.toFile(xml);
            assert (f != null);
            try {
                Document doc = XMLUtil.parse(new InputSource(BaseUtilities.toURI(f).toString()), false, true, XMLUtil.defaultErrorHandler(), null);
                ProjectXMLCatalogReader.validate(doc.getDocumentElement());
                return doc;
            }
            catch (IOException e) {
                if (!QUIETLY_SWALLOW_XML_LOAD_ERRORS) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, null, e);
                }
            }
            catch (SAXException e) {
                if (QUIETLY_SWALLOW_XML_LOAD_ERRORS) break block8;
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, null, e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runSaveAA(FileSystem.AtomicAction action) throws IOException {
        Set<FileSystem.AtomicAction> set = this.saveActions;
        synchronized (set) {
            this.saveActions.add(action);
        }
        this.dir.getFileSystem().runAtomicAction(action);
    }

    private FileLock saveXml(final Document doc, final String path) throws IOException {
        this.lazyAttachFileListener();
        assert (ProjectManager.mutex().isWriteAccess());
        assert (Thread.holdsLock(this.modifiedMetadataPaths));
        try {
            ProjectXMLCatalogReader.validate(doc.getDocumentElement());
        }
        catch (SAXException x) {
            Exceptions.attachMessage(x, "Saving " + path + " in " + FileUtil.getFileDisplayName(this.dir));
            throw (IOException)new IOException(x.getMessage()).initCause(x);
        }
        final FileLock[] _lock = new FileLock[1];
        this.runSaveAA(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() throws IOException {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                XMLUtil.write(doc, baos, "UTF-8");
                final byte[] data = baos.toByteArray();
                ProjectXMLKnownChecksums checksums = new ProjectXMLKnownChecksums();
                if (!checksums.check(data)) {
                    checksums.save();
                }
                final FileObject xml = FileUtil.createData(AntProjectHelper.this.dir, path);
                try {
                    _lock[0] = xml.lock();
                    try (OutputStream os = xml.getOutputStream(_lock[0]);){
                        os.write(data);
                    }
                }
                catch (IOException ioe) {
                    if (!ProjectIDEServices.isUserQuestionException(ioe)) {
                        throw ioe;
                    }
                    AntProjectHelper.this.needPendingHook();
                    ProjectIDEServices.handleUserQuestionException(ioe, new ProjectIDEServicesImplementation.UserQuestionExceptionCallback(){

                        @Override
                        public void accepted() {
                            try {
                                AntProjectHelper.this.runSaveAA(new FileSystem.AtomicAction(){

                                    @Override
                                    public void run() throws IOException {
                                        try (OutputStream os = xml.getOutputStream();){
                                            os.write(data);
                                        }
                                        AntProjectHelper.this.maybeCallPendingHook();
                                    }
                                });
                            }
                            catch (IOException e) {
                                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
                                this.reload();
                            }
                        }

                        @Override
                        public void denied() {
                            this.reload();
                        }

                        @Override
                        public void error(IOException e) {
                            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
                            this.reload();
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        private void reload() {
                            if (path.equals(AntProjectHelper.PROJECT_XML_PATH)) {
                                Set<String> set = AntProjectHelper.this.modifiedMetadataPaths;
                                synchronized (set) {
                                    AntProjectHelper.this.projectXmlValid = false;
                                }
                            }
                            assert (path.equals(AntProjectHelper.PRIVATE_XML_PATH)) : path;
                            Set<String> set = AntProjectHelper.this.modifiedMetadataPaths;
                            synchronized (set) {
                                AntProjectHelper.this.privateXmlValid = false;
                            }
                            AntProjectHelper.this.fireExternalChange(path);
                            AntProjectHelper.this.cancelPendingHook();
                        }
                    });
                }
            }
        });
        return _lock[0];
    }

    private Element getConfigurationDataRoot(boolean shared) {
        assert (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess());
        assert (Thread.holdsLock(this.modifiedMetadataPaths));
        Document doc = this.getConfigurationXml(shared);
        if (shared) {
            Element project = doc.getDocumentElement();
            Element config = XMLUtil.findElement(project, "configuration", PROJECT_NS);
            assert (config != null);
            return config;
        }
        return doc.getDocumentElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAntProjectListener(AntProjectListener listener) {
        List<AntProjectListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAntProjectListener(AntProjectListener listener) {
        List<AntProjectListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    void fireExternalChange(String path) {
        ActionImpl action = new ActionImpl(this, path);
        if (ProjectManager.mutex().isWriteAccess() || ProjectLibraryProvider.FIRE_CHANGES_SYNCH) {
            ProjectManager.mutex().readAccess(action);
        } else if (ProjectManager.mutex().isReadAccess()) {
            action.run();
        } else {
            AntProjectHelper.rp().post(new RunnableImpl(action));
        }
    }

    private static synchronized RequestProcessor rp() {
        if (RP == null) {
            RP = new RequestProcessor("AntProjectHelper.RP");
        }
        return RP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange(String path, boolean expected) {
        AntProjectListener[] _listeners;
        assert (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess());
        List<AntProjectListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.isEmpty()) {
                return;
            }
            _listeners = this.listeners.toArray(new AntProjectListener[0]);
        }
        final AntProjectEvent ev = new AntProjectEvent(this, path, expected);
        final boolean xml = path.equals(PROJECT_XML_PATH) || path.equals(PRIVATE_XML_PATH);
        ProjectManager.mutex().readAccess(new Mutex.Action<Void>(){

            @Override
            public Void run() {
                for (AntProjectListener l : _listeners) {
                    try {
                        if (xml) {
                            l.configurationXmlChanged(ev);
                            continue;
                        }
                        l.propertiesChanged(ev);
                    }
                    catch (RuntimeException e) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
                    }
                }
                return null;
            }
        });
    }

    private void modifying(String path) {
        assert (ProjectManager.mutex().isWriteAccess());
        this.state.markModified();
        this.addModifiedMetadataPath(path);
        this.fireChange(path, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addModifiedMetadataPath(String path) {
        Set<String> set = this.modifiedMetadataPaths;
        synchronized (set) {
            boolean added = this.modifiedMetadataPaths.add(path);
            if (added && path.equals(PROJECT_XML_PATH)) {
                this.addedProjectXmlPath = new Throwable();
            }
        }
    }

    public FileObject getProjectDirectory() {
        return this.dir;
    }

    public void notifyDeleted() {
        this.state.notifyDeleted();
    }

    void markModified() {
        assert (ProjectManager.mutex().isWriteAccess());
        this.state.markModified();
        this.addModifiedMetadataPath(PROJECT_XML_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureProjectXmlUnmodified(String msg, boolean doSave) {
        assert (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess());
        Set<String> set = this.modifiedMetadataPaths;
        synchronized (set) {
            if (this.modifiedMetadataPaths.contains(PROJECT_XML_PATH)) {
                IllegalStateException ise = new IllegalStateException(msg);
                if (this.addedProjectXmlPath != null) {
                    ise.initCause(this.addedProjectXmlPath);
                }
                LOG.log(Level.INFO, null, ise);
                if (doSave) {
                    try {
                        this.save();
                    }
                    catch (IOException x) {
                        LOG.log(Level.INFO, null, x);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() throws IOException {
        assert (ProjectManager.mutex().isWriteAccess());
        if (!this.getProjectDirectory().isValid()) {
            return;
        }
        HashSet<FileLock> locks = new HashSet<FileLock>();
        try {
            Set<String> set = this.modifiedMetadataPaths;
            synchronized (set) {
                assert (!this.modifiedMetadataPaths.isEmpty());
                assert (this.pendingHook == null);
                if (this.modifiedMetadataPaths.contains(PROJECT_XML_PATH)) {
                    Project p = AntBasedProjectFactorySingleton.getProjectFor(this);
                    this.pendingHook = p.getLookup().lookupAll(ProjectXmlSavedHook.class);
                }
                HashSet<String> toBeCleared = new HashSet<String>();
                try {
                    for (String string : new TreeSet<String>(this.modifiedMetadataPaths)) {
                        try {
                            if (string.equals(PROJECT_XML_PATH)) {
                                assert (this.projectXml != null);
                                locks.add(this.saveXml(this.projectXml, string));
                            } else if (string.equals(PRIVATE_XML_PATH)) {
                                assert (this.privateXml != null);
                                locks.add(this.saveXml(this.privateXml, string));
                            } else {
                                locks.add(this.properties.write(string));
                            }
                        }
                        catch (FileAlreadyLockedException x) {
                            LOG.log(Level.INFO, null, x);
                        }
                        toBeCleared.add(string);
                    }
                    this.modifiedMetadataPaths.removeAll(toBeCleared);
                }
                catch (Throwable throwable) {
                    this.modifiedMetadataPaths.removeAll(toBeCleared);
                    LOG.log(Level.FINE, "saved {0} and have left {1}", new Object[]{toBeCleared, this.modifiedMetadataPaths});
                    throw throwable;
                }
                LOG.log(Level.FINE, "saved {0} and have left {1}", new Object[]{toBeCleared, this.modifiedMetadataPaths});
                if (this.pendingHook != null && this.pendingHookCount == 0) {
                    try {
                        for (ProjectXmlSavedHook projectXmlSavedHook : this.pendingHook) {
                            projectXmlSavedHook.projectXmlSaved();
                        }
                    }
                    catch (IOException e) {
                        this.addModifiedMetadataPath(PROJECT_XML_PATH);
                        throw e;
                    }
                }
                if (this.pendingHookCount == 0) {
                    this.pendingHook = null;
                }
            }
        }
        finally {
            locks.remove(null);
            for (FileLock lock : locks) {
                lock.releaseLock();
            }
            if (this.pendingHookCount == 0) {
                this.pendingHook = null;
            }
        }
    }

    void maybeCallPendingHook() {
        assert (this.pendingHookCount > 0);
        --this.pendingHookCount;
        if (this.pendingHookCount == 0 && this.pendingHook != null) {
            try {
                ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction<Void>(){

                    @Override
                    public Void run() throws IOException {
                        for (ProjectXmlSavedHook projectXmlSavedHook : AntProjectHelper.this.pendingHook) {
                            projectXmlSavedHook.projectXmlSaved();
                        }
                        return null;
                    }
                });
            }
            catch (MutexException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, e);
            }
            finally {
                this.pendingHook = null;
            }
        }
    }

    void cancelPendingHook() {
        assert (this.pendingHookCount > 0);
        --this.pendingHookCount;
        if (this.pendingHookCount == 0) {
            this.pendingHook = null;
        }
    }

    void needPendingHook() {
        ++this.pendingHookCount;
    }

    public EditableProperties getProperties(final @NonNull String path) {
        if (PROJECT_XML_PATH.equals(path) || PRIVATE_XML_PATH.equals(path)) {
            throw new IllegalArgumentException("Attempt to load properties from a project XML file");
        }
        return ProjectManager.mutex().readAccess(new Mutex.Action<EditableProperties>(){

            @Override
            public EditableProperties run() {
                return AntProjectHelper.this.properties.getProperties(path);
            }
        });
    }

    public void putProperties(final @NonNull String path, final EditableProperties props) {
        if (PROJECT_XML_PATH.equals(path) || PRIVATE_XML_PATH.equals(path)) {
            throw new IllegalArgumentException("Attempt to store properties from a project XML file");
        }
        ProjectManager.mutex().writeAccess(new Mutex.Action<Void>(){

            @Override
            public Void run() {
                if (AntProjectHelper.this.properties.putProperties(path, props)) {
                    AntProjectHelper.this.modifying(path);
                }
                return null;
            }
        });
    }

    public PropertyProvider getPropertyProvider(final String path) {
        if (path.equals(PROJECT_XML_PATH) || path.equals(PRIVATE_XML_PATH)) {
            throw new IllegalArgumentException("Attempt to store properties from a project XML file");
        }
        return ProjectManager.mutex().readAccess(new Mutex.Action<PropertyProvider>(){

            @Override
            public PropertyProvider run() {
                return AntProjectHelper.this.properties.getPropertyProvider(path);
            }
        });
    }

    public Element getPrimaryConfigurationData(final boolean shared) {
        final String name = this.type.getPrimaryConfigurationDataElementName(shared);
        assert (name.indexOf(58) == -1);
        final String namespace = this.type.getPrimaryConfigurationDataElementNamespace(shared);
        assert (namespace != null && namespace.length() > 0);
        return ProjectManager.mutex().readAccess(new Mutex.Action<Element>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Element run() {
                Set<String> set = AntProjectHelper.this.modifiedMetadataPaths;
                synchronized (set) {
                    Element el = AntProjectHelper.this.getConfigurationFragment(name, namespace, shared);
                    if (el != null) {
                        return el;
                    }
                    return AntProjectHelper.cloneSafely(AntProjectHelper.this.getConfigurationXml(shared).createElementNS(namespace, name));
                }
            }
        });
    }

    public void putPrimaryConfigurationData(Element data, boolean shared) throws IllegalArgumentException {
        String name = this.type.getPrimaryConfigurationDataElementName(shared);
        assert (name.indexOf(58) == -1);
        String namespace = this.type.getPrimaryConfigurationDataElementNamespace(shared);
        assert (namespace != null && namespace.length() > 0);
        if (!name.equals(data.getLocalName()) || !namespace.equals(data.getNamespaceURI())) {
            throw new IllegalArgumentException("Wrong name/namespace: expected {" + namespace + "}" + name + " but was {" + data.getNamespaceURI() + "}" + data.getLocalName());
        }
        this.putConfigurationFragment(data, shared);
    }

    Element getConfigurationFragment(final String elementName, final String namespace, final boolean shared) {
        return ProjectManager.mutex().readAccess(new Mutex.Action<Element>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Element run() {
                Set<String> set = AntProjectHelper.this.modifiedMetadataPaths;
                synchronized (set) {
                    Element root = AntProjectHelper.this.getConfigurationDataRoot(shared);
                    Element data = XMLUtil.findElement(root, elementName, namespace);
                    if (data != null) {
                        return AntProjectHelper.cloneSafely(data);
                    }
                    return null;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Element cloneSafely(Element el) {
        DocumentBuilder documentBuilder = db;
        synchronized (documentBuilder) {
            Document dummy = db.newDocument();
            return (Element)dummy.importNode(el, true);
        }
    }

    void putConfigurationFragment(final Element fragment, final boolean shared) {
        ProjectManager.mutex().writeAccess(new Mutex.Action<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() {
                Set<String> set = AntProjectHelper.this.modifiedMetadataPaths;
                synchronized (set) {
                    Element root = AntProjectHelper.this.getConfigurationDataRoot(shared);
                    Element existing = XMLUtil.findElement(root, fragment.getLocalName(), fragment.getNamespaceURI());
                    if (existing != null) {
                        root.removeChild(existing);
                    }
                    Node ref = null;
                    NodeList list = root.getChildNodes();
                    for (int i = 0; i < list.getLength(); ++i) {
                        Node node = list.item(i);
                        if (node.getNodeType() != 1) continue;
                        int comparison = node.getNodeName().compareTo(fragment.getNodeName());
                        if (comparison == 0) {
                            comparison = node.getNamespaceURI().compareTo(fragment.getNamespaceURI());
                        }
                        if (comparison <= 0) continue;
                        ref = node;
                        break;
                    }
                    root.insertBefore(root.getOwnerDocument().importNode(fragment, true), ref);
                    AntProjectHelper.this.modifying(shared ? AntProjectHelper.PROJECT_XML_PATH : AntProjectHelper.PRIVATE_XML_PATH);
                }
                return null;
            }
        });
    }

    boolean removeConfigurationFragment(final String elementName, final String namespace, final boolean shared) {
        return ProjectManager.mutex().writeAccess(new Mutex.Action<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean run() {
                Set<String> set = AntProjectHelper.this.modifiedMetadataPaths;
                synchronized (set) {
                    Element root = null;
                    Element data = null;
                    try {
                        root = AntProjectHelper.this.getConfigurationDataRoot(shared);
                        data = XMLUtil.findElement(root, elementName, namespace);
                    }
                    catch (IllegalArgumentException iae) {
                        LOG.log(Level.INFO, iae.getMessage(), iae);
                    }
                    if (shared) {
                        AntProjectHelper.findDuplicateElements(AntProjectHelper.this.projectXml.getDocumentElement(), AntProjectHelper.this.dir.getFileObject(AntProjectHelper.PROJECT_XML_PATH), shared);
                    } else {
                        AntProjectHelper.findDuplicateElements(AntProjectHelper.this.privateXml.getDocumentElement(), AntProjectHelper.this.dir.getFileObject(AntProjectHelper.PRIVATE_XML_PATH), shared);
                    }
                    if (data != null) {
                        root.removeChild(data);
                        AntProjectHelper.this.modifying(shared ? AntProjectHelper.PROJECT_XML_PATH : AntProjectHelper.PRIVATE_XML_PATH);
                        return true;
                    }
                    return false;
                }
            }
        });
    }

    public AuxiliaryConfiguration createAuxiliaryConfiguration() {
        return new ExtensibleMetadataProviderImpl(this);
    }

    public CacheDirectoryProvider createCacheDirectoryProvider() {
        return new ExtensibleMetadataProviderImpl(this);
    }

    public AuxiliaryProperties createAuxiliaryProperties() {
        return new AuxiliaryPropertiesImpl(this);
    }

    public FileBuiltQueryImplementation createGlobFileBuiltQuery(PropertyEvaluator eval, String[] from, String[] to) throws IllegalArgumentException {
        return new GlobFileBuiltQuery(this, eval, from, to);
    }

    public AntArtifact createSimpleAntArtifact(String type, String locationProperty, PropertyEvaluator eval, String targetName, String cleanTargetName) {
        return this.createSimpleAntArtifact(type, locationProperty, eval, targetName, cleanTargetName, null);
    }

    public AntArtifact createSimpleAntArtifact(String type, String locationProperty, PropertyEvaluator eval, String targetName, String cleanTargetName, String buildScriptProperty) {
        return new SimpleAntArtifact(this, type, locationProperty, eval, targetName, cleanTargetName, buildScriptProperty);
    }

    public SharabilityQueryImplementation2 createSharabilityQuery2(PropertyEvaluator eval, String[] sourceRoots, String[] buildDirectories) {
        String[] includes = new String[sourceRoots.length + 1];
        System.arraycopy(sourceRoots, 0, includes, 0, sourceRoots.length);
        includes[sourceRoots.length] = "";
        String[] excludes = new String[buildDirectories.length + 1];
        System.arraycopy(buildDirectories, 0, excludes, 0, buildDirectories.length);
        excludes[buildDirectories.length] = "nbproject/private";
        return new SharabilityQueryImpl(this, eval, includes, excludes);
    }

    @Deprecated
    public SharabilityQueryImplementation createSharabilityQuery(PropertyEvaluator eval, String[] sourceRoots, String[] buildDirectories) {
        final SharabilityQueryImplementation2 sq2 = this.createSharabilityQuery2(eval, sourceRoots, buildDirectories);
        return new SharabilityQueryImplementation(){

            @Override
            public int getSharability(File file) {
                return sq2.getSharability(BaseUtilities.toURI(file)).ordinal();
            }
        };
    }

    public PropertyProvider getStockPropertyPreprovider() {
        return this.properties.getStockPropertyPreprovider();
    }

    public PropertyProvider getProjectLibrariesPropertyProvider() {
        return ProjectLibraryProvider.createPropertyProvider(this);
    }

    public boolean isSharableProject() {
        return this.getLibrariesLocation() != null;
    }

    public String getLibrariesLocation() {
        return ProjectLibraryProvider.getLibrariesLocationText(this.createAuxiliaryConfiguration());
    }

    public void setLibrariesLocation(String location) {
        ProjectLibraryProvider.setLibrariesLocation(this, location);
    }

    public PropertyEvaluator getStandardPropertyEvaluator() {
        return this.properties.getStandardPropertyEvaluator();
    }

    @NonNull
    public File resolveFile(@NonNull String filename) {
        if (filename == null) {
            throw new NullPointerException("Attempted to pass a null filename to resolveFile");
        }
        return PropertyUtils.resolveFile(FileUtil.toFile(this.dir), filename);
    }

    @CheckForNull
    public FileObject resolveFileObject(@NonNull String filename) {
        if (filename == null) {
            throw new NullPointerException("Must pass a non-null filename");
        }
        return PropertyUtils.resolveFileObject(this.dir, filename);
    }

    @NonNull
    public String resolvePath(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("Must pass a non-null path");
        }
        return PropertyUtils.resolvePath(FileUtil.toFile(this.dir), path);
    }

    public String toString() {
        return "AntProjectHelper[" + this.getProjectDirectory() + "]";
    }

    static void findDuplicateElements(@NonNull Element parent, FileObject config, boolean shared) {
        NodeList l = parent.getChildNodes();
        int nodeCount = l.getLength();
        HashSet<CallSite> known = new HashSet<CallSite>();
        for (int i = 0; i < nodeCount; ++i) {
            Node node;
            String localName;
            String id;
            if (l.item(i).getNodeType() != 1 || known.add((CallSite)((Object)(id = (localName = (localName = (node = l.item(i)).getLocalName()) == null ? node.getNodeName() : localName) + "|" + node.getNamespaceURI())))) continue;
            String message = "";
            message = shared ? Bundle.DESC_Problem_Broken_Config("$project_basedir/nbproject/project.xml") : Bundle.DESC_Problem_Broken_Config("$project_basedir/nbproject/private/private.xml");
            ProjectIDEServices.notifyWarning(message);
            Logger.getLogger(AntProjectHelper.class.getName()).log(Level.WARNING, message);
        }
    }

    static {
        AntBasedProjectFactorySingleton.HELPER_CALLBACK = new AntBasedProjectFactorySingleton.AntProjectHelperCallback(){

            @Override
            public AntProjectHelper createHelper(FileObject dir, Document projectXml, ProjectState state, AntBasedProjectType type) {
                return new AntProjectHelper(dir, projectXml, state, type);
            }

            @Override
            public void save(AntProjectHelper helper) throws IOException {
                helper.save();
            }
        };
        LOG = Logger.getLogger(AntProjectHelper.class.getName());
        NONEXISTENT = XMLUtil.createDocument("does-not-exist", null, null, null);
        QUIETLY_SWALLOW_XML_LOAD_ERRORS = false;
        try {
            db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new AssertionError((Object)e);
        }
    }

    private final class FileListener
    implements FileChangeListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void change(FileEvent fe) {
            String path;
            Set<FileSystem.AtomicAction> set = AntProjectHelper.this.saveActions;
            synchronized (set) {
                for (FileSystem.AtomicAction a : AntProjectHelper.this.saveActions) {
                    if (!fe.firedFrom(a)) continue;
                    return;
                }
            }
            File f = FileUtil.toFile(fe.getFile());
            Set<String> set2 = AntProjectHelper.this.modifiedMetadataPaths;
            synchronized (set2) {
                if (f.equals(AntProjectHelper.this.resolveFile(AntProjectHelper.PROJECT_XML_PATH))) {
                    if (AntProjectHelper.this.modifiedMetadataPaths.contains(AntProjectHelper.PROJECT_XML_PATH)) {
                        return;
                    }
                    path = AntProjectHelper.PROJECT_XML_PATH;
                    AntProjectHelper.this.projectXmlValid = false;
                } else if (f.equals(AntProjectHelper.this.resolveFile(AntProjectHelper.PRIVATE_XML_PATH))) {
                    if (AntProjectHelper.this.modifiedMetadataPaths.contains(AntProjectHelper.PRIVATE_XML_PATH)) {
                        return;
                    }
                    path = AntProjectHelper.PRIVATE_XML_PATH;
                    AntProjectHelper.this.privateXmlValid = false;
                } else {
                    LOG.log(Level.WARNING, "#184132: unexpected file change in {0}; possibly deleted project?", f);
                    return;
                }
            }
            AntProjectHelper.this.fireExternalChange(path);
        }

        @Override
        public void fileFolderCreated(FileEvent fe) {
            this.change(fe);
        }

        @Override
        public void fileDataCreated(FileEvent fe) {
            this.change(fe);
        }

        @Override
        public void fileChanged(FileEvent fe) {
            this.change(fe);
        }

        @Override
        public void fileDeleted(FileEvent fe) {
            this.change(fe);
        }

        @Override
        public void fileRenamed(FileRenameEvent fe) {
            this.change(fe);
        }

        @Override
        public void fileAttributeChanged(FileAttributeEvent fe) {
        }
    }

    private static class ActionImpl
    implements Mutex.Action<Void> {
        private final String path;
        private AntProjectHelper helper;

        public ActionImpl(AntProjectHelper helper, String path) {
            this.path = path;
            this.helper = helper;
        }

        @Override
        public Void run() {
            this.helper.fireChange(this.path, false);
            this.helper = null;
            return null;
        }
    }

    private static class RunnableImpl
    implements Runnable {
        private final Mutex.Action<Void> action;

        public RunnableImpl(Mutex.Action<Void> action) {
            this.action = action;
        }

        @Override
        public void run() {
            ProjectManager.mutex().readAccess(this.action);
        }
    }
}

