/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project;

import java.util.Objects;
import org.openide.filesystems.FileObject;

public final class NestedClass {
    private final FileObject file;
    private final String className;
    private final String topLevelClassName;

    public NestedClass(String className, String topLevelClassName, FileObject file) {
        if (className == null) {
            throw new IllegalArgumentException("className is <null>");
        }
        if (topLevelClassName == null) {
            throw new IllegalArgumentException("topLevelClassName is <null>");
        }
        if (file == null) {
            throw new IllegalArgumentException("file is <null>");
        }
        this.className = className;
        this.topLevelClassName = topLevelClassName;
        this.file = file;
    }

    public FileObject getFile() {
        return this.file;
    }

    public String getClassName() {
        return this.className;
    }

    public String getTopLevelClassName() {
        return this.topLevelClassName;
    }

    public String getFQN(String packageName) {
        Object classNameSuffix = this.className.isBlank() ? this.topLevelClassName : this.topLevelClassName + "." + this.className;
        if (packageName.isBlank()) {
            return classNameSuffix;
        }
        return String.join((CharSequence)".", new CharSequence[]{packageName, classNameSuffix});
    }

    public String getFQN(String packageName, String nestedClassSeparator) {
        Object classNameSuffix = this.className.isBlank() ? this.topLevelClassName : this.topLevelClassName + nestedClassSeparator + this.className.replace(".", nestedClassSeparator);
        if (packageName.isBlank()) {
            return classNameSuffix;
        }
        return String.join((CharSequence)".", new CharSequence[]{packageName, classNameSuffix});
    }

    public int hashCode() {
        int hash = 3;
        hash = 41 * hash + Objects.hashCode(this.className);
        hash = 41 * hash + Objects.hashCode(this.topLevelClassName);
        hash = 41 * hash + Objects.hashCode(this.file);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != NestedClass.class) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        NestedClass other = (NestedClass)obj;
        return other.file.equals(this.file) && other.className.equals(this.className) && other.topLevelClassName.equals(this.topLevelClassName);
    }
}

