/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectapi;

import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.spi.project.FileOwnerQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.BaseUtilities;
import org.openide.util.NbPreferences;

public class SimpleFileOwnerQueryImplementation
implements FileOwnerQueryImplementation {
    private static final Logger LOG = Logger.getLogger(SimpleFileOwnerQueryImplementation.class.getName());
    private static final URI UNOWNED_URI = URI.create("http:unowned");
    private static final Set<String> forbiddenFolders;
    private static final Set<String> projectScanRoots;
    private final Set<FileObject> warnedAboutBrokenProjects = Collections.newSetFromMap(new WeakHashMap());
    private Map<FileObject, Reference<Project>> projectCache = new WeakHashMap<FileObject, Reference<Project>>();
    private static final Map<URI, URI> externalOwners;
    private static final Map<URI, FileObject> deserializedExternalOwners;
    private static boolean externalRootsIncludeNonFolders;
    private static final Object cacheLock;
    private static volatile boolean cacheInvalid;
    private static ExternalRootsState externalRootsState;
    private static final boolean WINDOWS;

    @Override
    public Project getOwner(URI fileURI) {
        FileObject file;
        URI test = fileURI;
        do {
            file = SimpleFileOwnerQueryImplementation.uri2FileObject(test);
            test = SimpleFileOwnerQueryImplementation.goUp(test);
        } while (file == null && test != null);
        if (file == null) {
            return null;
        }
        return this.getOwner(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetLastFoundReferences() {
        Object object = cacheLock;
        synchronized (object) {
            this.projectCache.clear();
            cacheInvalid = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Project getOwner(FileObject f) {
        ArrayList<FileObject> folders = new ArrayList<FileObject>();
        SimpleFileOwnerQueryImplementation.deserialize();
        while (f != null) {
            FileObject externalOwner;
            URI externalOwnersURI;
            Project p;
            if (projectScanRoots != null) {
                if (projectScanRoots.stream().noneMatch(f.getPath()::startsWith)) break;
            }
            boolean folder = f.isFolder();
            URI[] furi = new URI[1];
            if (folder) {
                Object object = cacheLock;
                synchronized (object) {
                    Reference<Project> rp;
                    if (cacheInvalid) {
                        this.projectCache.clear();
                        cacheInvalid = false;
                    }
                    if ((rp = this.projectCache.get(f)) != null && (p = rp.get()) != null) {
                        for (FileObject fldr : folders) {
                            this.projectCache.put(fldr, rp);
                        }
                        return p;
                    }
                }
                folders.add(f);
                if (!(forbiddenFolders.contains(f.getPath()) || SimpleFileOwnerQueryImplementation.hasRoot(externalOwners.keySet(), f, true, furi) || SimpleFileOwnerQueryImplementation.hasRoot(deserializedExternalOwners.keySet(), f, true, furi))) {
                    Project p2;
                    try {
                        p2 = ProjectManager.getDefault().findProject(f);
                    }
                    catch (IOException e) {
                        if (this.warnedAboutBrokenProjects.add(f)) {
                            LOG.log(Level.FINE, "Cannot load project.", e);
                        }
                        return null;
                    }
                    if (p2 != null) {
                        Object e = cacheLock;
                        synchronized (e) {
                            WeakReference<Project> rp = new WeakReference<Project>(p2);
                            for (FileObject fldr : folders) {
                                this.projectCache.put(fldr, rp);
                            }
                        }
                        return p2;
                    }
                }
            }
            if (SimpleFileOwnerQueryImplementation.hasRoot(externalOwners.keySet(), f, folder, furi) && (externalOwnersURI = externalOwners.get(furi[0])) != null) {
                if (externalOwnersURI == UNOWNED_URI) {
                    return FileOwnerQuery.UNOWNED;
                }
                FileObject externalOwner2 = SimpleFileOwnerQueryImplementation.uri2FileObject(externalOwnersURI);
                if (externalOwner2 != null && externalOwner2.isValid()) {
                    try {
                        p = ProjectManager.getDefault().findProject(externalOwner2);
                        if (p != null) {
                            Object object = cacheLock;
                            synchronized (object) {
                                this.projectCache.put(f, new WeakReference<Project>(p));
                            }
                        }
                        return p;
                    }
                    catch (IOException e) {
                        LOG.log(Level.FINE, "Cannot load project.", e);
                        return null;
                    }
                }
            }
            if (SimpleFileOwnerQueryImplementation.hasRoot(deserializedExternalOwners.keySet(), f, folder, furi) && (externalOwner = deserializedExternalOwners.get(furi[0])) != null && externalOwner.isValid()) {
                try {
                    Project p3 = ProjectManager.getDefault().findProject(externalOwner);
                    if (p3 != null) {
                        Object object = cacheLock;
                        synchronized (object) {
                            this.projectCache.put(f, new WeakReference<Project>(p3));
                        }
                    }
                    return p3;
                }
                catch (IOException e) {
                    LOG.log(Level.FINE, "Cannot load project.", e);
                    return null;
                }
            }
            f = f.getParent();
        }
        return null;
    }

    private static boolean hasRoot(@NonNull Set<URI> extRoots, @NonNull FileObject file, boolean folder, @NonNull URI[] furi) {
        if (extRoots.isEmpty() || !folder && !externalRootsIncludeNonFolders) {
            return false;
        }
        furi[0] = file.toURI();
        return extRoots.contains(furi[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deserialize() {
        boolean needsToLoad = false;
        Class<SimpleFileOwnerQueryImplementation> clazz = SimpleFileOwnerQueryImplementation.class;
        synchronized (SimpleFileOwnerQueryImplementation.class) {
            LOG.log(Level.FINEST, "External Roots State: {0}", (Object)externalRootsState);
            block8 : switch (externalRootsState) {
                case NEW: {
                    externalRootsState = ExternalRootsState.LOADING;
                    needsToLoad = true;
                    break;
                }
                case LOADING: {
                    while (externalRootsState == ExternalRootsState.LOADING) {
                        try {
                            SimpleFileOwnerQueryImplementation.class.wait();
                        }
                        catch (InterruptedException ie) {
                            LOG.log(Level.INFO, null, ie);
                            break block8;
                        }
                    }
                    break;
                }
                case LOADED: {
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Unknown external roots state: %s", new Object[]{externalRootsState}));
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (needsToLoad) {
                try {
                    SimpleFileOwnerQueryImplementation.deserializeImpl();
                    LOG.log(Level.FINEST, "External Roots Deserialized");
                }
                finally {
                    clazz = SimpleFileOwnerQueryImplementation.class;
                    synchronized (SimpleFileOwnerQueryImplementation.class) {
                        assert (externalRootsState == ExternalRootsState.LOADING);
                        externalRootsState = ExternalRootsState.LOADED;
                        SimpleFileOwnerQueryImplementation.class.notifyAll();
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                    }
                }
            }
            return;
        }
    }

    private static void deserializeImpl() {
        try {
            Preferences p = NbPreferences.forModule(SimpleFileOwnerQueryImplementation.class).node("externalOwners");
            for (String name : p.keys()) {
                URL u = new URL(p.get(name, null));
                URI i = new URI(name);
                deserializedExternalOwners.put(i, URLMapper.findFileObject(u));
            }
        }
        catch (Exception ex) {
            LOG.log(Level.INFO, null, ex);
        }
        try {
            NbPreferences.forModule(SimpleFileOwnerQueryImplementation.class).node("externalOwners").removeNode();
        }
        catch (BackingStoreException ex) {
            LOG.log(Level.INFO, null, ex);
        }
    }

    static void serialize() {
        try {
            Preferences p = NbPreferences.forModule(SimpleFileOwnerQueryImplementation.class).node("externalOwners");
            for (Map.Entry<URI, URI> entry : externalOwners.entrySet()) {
                URI uri = entry.getKey();
                URI ownerURI = entry.getValue();
                if (ownerURI == UNOWNED_URI) continue;
                p.put(uri.toString(), ownerURI.toString());
            }
            p.sync();
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        Object object = cacheLock;
        synchronized (object) {
            cacheInvalid = true;
            externalOwners.clear();
        }
    }

    public static void markExternalOwnerTransient(FileObject root, Project owner) {
        SimpleFileOwnerQueryImplementation.markExternalOwnerTransient(root.toURI(), owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markExternalOwnerTransient(URI root, Project owner) {
        externalRootsIncludeNonFolders |= !root.getPath().endsWith("/");
        if (owner != null) {
            FileObject fo = owner.getProjectDirectory();
            URI foUri = owner == FileOwnerQuery.UNOWNED ? UNOWNED_URI : fo.toURI();
            Object object = cacheLock;
            synchronized (object) {
                cacheInvalid = true;
                externalOwners.put(root, foUri);
                deserializedExternalOwners.remove(root);
            }
        }
        Object object = cacheLock;
        synchronized (object) {
            cacheInvalid = true;
            externalOwners.remove(root);
        }
    }

    private static FileObject uri2FileObject(URI u) {
        URL url;
        try {
            url = u.toURL();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            assert (false) : u;
            return null;
        }
        return URLMapper.findFileObject(url);
    }

    private static URI goUp(URI u) {
        String pth;
        URI nue;
        assert (u.isAbsolute()) : u;
        assert (u.getFragment() == null) : u;
        assert (u.getQuery() == null) : u;
        String path = u.getPath();
        if (path == null || path.equals("/")) {
            return null;
        }
        String us = u.toString();
        if (us.endsWith("/")) {
            us = us.substring(0, us.length() - 1);
            assert (path.endsWith("/"));
            path = path.substring(0, path.length() - 1);
        }
        int idx = us.lastIndexOf(47);
        assert (idx != -1) : path;
        us = path.lastIndexOf(47) == 0 ? us.substring(0, idx + 1) : us.substring(0, idx);
        try {
            nue = new URI(us);
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
        if (WINDOWS && ((pth = nue.getPath()).length() == 3 && pth.endsWith(":") || pth.length() == 1 && pth.endsWith("/"))) {
            return null;
        }
        assert (nue.isAbsolute()) : nue;
        assert (u.toString().startsWith(nue.toString())) : "not a parent: " + nue + " of " + u;
        return nue;
    }

    private static Set<String> separatePaths(String joinedPaths, String pathSeparator) {
        if (joinedPaths == null || joinedPaths.isEmpty()) {
            return null;
        }
        Set<String> paths = null;
        for (String split : joinedPaths.split(pathSeparator)) {
            String path;
            File file;
            FileObject fileObject;
            if ((split = split.trim()).isEmpty() || (fileObject = FileUtil.toFileObject(file = FileUtil.normalizeFile(new File(split)))) == null || (path = fileObject.getPath()) == null || path.isEmpty()) continue;
            if (paths == null) {
                paths = Collections.singleton(path);
                continue;
            }
            if (paths.size() == 1) {
                paths = new LinkedHashSet<String>(paths);
            }
            paths.add(path);
        }
        return paths;
    }

    static {
        Set<String> folders = null;
        Set<String> roots = null;
        try {
            roots = SimpleFileOwnerQueryImplementation.separatePaths(System.getProperty("project.limitScanRoot"), File.pathSeparator);
            folders = SimpleFileOwnerQueryImplementation.separatePaths(System.getProperty("project.forbiddenFolders", System.getProperty("versioning.forbiddenFolders")), ";");
        }
        catch (Exception e) {
            LOG.log(Level.INFO, e.getMessage(), e);
        }
        forbiddenFolders = folders == null ? Collections.emptySet() : folders;
        projectScanRoots = roots;
        externalOwners = Collections.synchronizedMap(new HashMap());
        deserializedExternalOwners = Collections.synchronizedMap(new HashMap());
        externalRootsIncludeNonFolders = false;
        cacheLock = new Object();
        cacheInvalid = false;
        externalRootsState = ExternalRootsState.NEW;
        WINDOWS = BaseUtilities.isWindows();
    }

    private static enum ExternalRootsState {
        NEW,
        LOADING,
        LOADED;

    }
}

