/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Set;
import jpt30.tools.JavaFileObject;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.preprocessorbridge.spi.JavaFileFilterImplementation;
import org.netbeans.modules.java.source.parsing.Archive;
import org.netbeans.modules.java.source.parsing.FolderArchive;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;

class CacheFolderArchive
implements Archive,
FileChangeListener {
    private volatile Archive delegate;
    private final File cache;

    public CacheFolderArchive(@NonNull File cache) {
        Parameters.notNull("cache", cache);
        this.cache = cache;
        if (cache.isDirectory()) {
            this.delegate = new FolderArchive(cache);
        } else {
            FileUtil.addFileChangeListener(this, cache);
            this.delegate = Archive.EMPTY;
        }
    }

    @Override
    public JavaFileObject getFile(String name) throws IOException {
        return this.delegate.getFile(name);
    }

    @Override
    public URI getDirectory(String dirName) throws IOException {
        return this.delegate.getDirectory(dirName);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public JavaFileObject create(String relativeName, JavaFileFilterImplementation filter) throws UnsupportedOperationException {
        return this.delegate.create(relativeName, filter);
    }

    @Override
    public boolean isMultiRelease() {
        return this.delegate.isMultiRelease();
    }

    @Override
    public Iterable<JavaFileObject> getFiles(String folderName, ClassPath.Entry entry, Set<JavaFileObject.Kind> kinds, JavaFileFilterImplementation filter, boolean recursive) throws IOException {
        return this.delegate.getFiles(folderName, entry, kinds, filter, recursive);
    }

    private void update() {
        if (this.cache.isDirectory()) {
            this.delegate = new FolderArchive(this.cache);
            FileUtil.removeFileChangeListener(this, this.cache);
        }
    }

    @Override
    public void fileFolderCreated(FileEvent fe) {
        this.update();
    }

    @Override
    public void fileDataCreated(FileEvent fe) {
        this.update();
    }

    @Override
    public void fileChanged(FileEvent fe) {
        this.update();
    }

    @Override
    public void fileDeleted(FileEvent fe) {
        this.update();
    }

    @Override
    public void fileRenamed(FileRenameEvent fe) {
        this.update();
    }

    @Override
    public void fileAttributeChanged(FileAttributeEvent fe) {
        this.update();
    }
}

