/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.providers.spi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jpt30.lang.model.SourceVersion;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.java.hints.CustomizerProvider;
import org.netbeans.spi.java.hints.Hint;
import org.openide.util.NbBundle;

public class HintMetadata {
    public final String id;
    public final String displayName;
    public final String description;
    public final String category;
    public final boolean enabled;
    public final Hint.Kind kind;
    public final Severity severity;
    public final Collection<? extends String> suppressWarnings;
    public final CustomizerProvider customizer;
    public final boolean showInTaskList = false;
    public final Set<Options> options;
    public final SourceVersion sourceVersion;

    HintMetadata(String id, String displayName, String description, String category, boolean enabled, Hint.Kind kind, Severity severity, Collection<? extends String> suppressWarnings, CustomizerProvider customizer, Set<Options> options, SourceVersion sourceVersion) {
        this.id = id;
        this.displayName = displayName;
        this.description = description;
        this.category = category;
        this.enabled = enabled;
        this.kind = kind;
        this.severity = severity;
        this.suppressWarnings = suppressWarnings;
        this.customizer = customizer;
        this.options = options;
        this.sourceVersion = sourceVersion;
    }

    public String toString() {
        return this.displayName;
    }

    private static String lookup(ResourceBundle bundle, String key, String def) {
        try {
            return bundle != null ? bundle.getString(key) : def;
        }
        catch (MissingResourceException mre) {
            Logger.getLogger(HintMetadata.class.getName()).log(Level.FINE, null, mre);
            return def;
        }
    }

    public static enum Options {
        NON_GUI,
        QUERY,
        NO_BATCH,
        HEAVY;


        public static Set<Options> fromHintOptions(Hint.Options ... options) {
            EnumSet<Options> result = EnumSet.noneOf(Options.class);
            for (Hint.Options opt : options) {
                result.add(Options.valueOf(opt.name()));
            }
            return result;
        }
    }

    public static final class Builder {
        private final String id;
        private String displayName;
        private String description;
        private String category;
        private boolean enabled;
        private Hint.Kind kind;
        private Severity severity;
        private final Collection<String> suppressWarnings = new ArrayList<String>();
        private CustomizerProvider customizer;
        private final Set<Options> options = EnumSet.noneOf(Options.class);
        private SourceVersion sourceVersion;

        private Builder(String id) {
            this.id = id;
            this.displayName = "";
            this.description = "";
            this.category = "";
            this.enabled = true;
            this.kind = Hint.Kind.INSPECTION;
            this.severity = Severity.VERIFIER;
        }

        public static Builder create(String id) {
            return new Builder(id);
        }

        public Builder setDescription(String displayName, String description) {
            this.displayName = displayName;
            this.description = description;
            return this;
        }

        public Builder setBundle(ResourceBundle bundle) {
            return this.setBundle(bundle, null, null);
        }

        public Builder setBundle(ResourceBundle bundle, String fallbackDisplayName, String fallbackDescription) {
            if (fallbackDisplayName == null) {
                fallbackDisplayName = "No Display Name";
            }
            if (fallbackDescription == null) {
                fallbackDescription = "No Description";
            }
            this.displayName = HintMetadata.lookup(bundle, "DN_" + this.id.replace('$', '.'), fallbackDisplayName);
            this.description = HintMetadata.lookup(bundle, "DESC_" + this.id.replace('$', '.'), fallbackDescription);
            return this;
        }

        public Builder setBundle(String bundleForFQN) {
            ResourceBundle bundle;
            try {
                int lastDot = bundleForFQN.lastIndexOf(46);
                assert (lastDot >= 0);
                bundle = NbBundle.getBundle(bundleForFQN.substring(0, lastDot + 1) + "Bundle");
            }
            catch (MissingResourceException mre) {
                Logger.getLogger(HintMetadata.class.getName()).log(Level.FINE, null, mre);
                bundle = null;
            }
            return this.setBundle(bundle);
        }

        public Builder setCategory(String category) {
            this.category = category;
            return this;
        }

        public Builder setEnabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder setKind(Hint.Kind kind) {
            this.kind = kind;
            return this;
        }

        public Builder setSeverity(Severity severity) {
            this.severity = severity;
            return this;
        }

        public Builder setSourceVersion(String version) {
            if (version == null || version.isEmpty()) {
                this.sourceVersion = SourceVersion.RELEASE_3;
            } else {
                if (version.startsWith("1.")) {
                    version = version.substring(2);
                }
                try {
                    this.sourceVersion = SourceVersion.valueOf("RELEASE_" + version);
                }
                catch (IllegalArgumentException ex) {
                    this.sourceVersion = SourceVersion.RELEASE_3;
                    this.setEnabled(false);
                }
            }
            return this;
        }

        public Builder addSuppressWarnings(String ... keys) {
            this.suppressWarnings.addAll(Arrays.asList(keys));
            return this;
        }

        public Builder setCustomizerProvider(CustomizerProvider customizer) {
            this.customizer = customizer;
            return this;
        }

        public Builder addOptions(Options ... options) {
            this.options.addAll(Arrays.asList(options));
            return this;
        }

        public HintMetadata build() {
            return new HintMetadata(this.id, this.displayName, this.description, this.category, this.enabled, this.kind, this.severity, this.suppressWarnings, this.customizer, this.options, this.sourceVersion);
        }
    }
}

