/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.beans.Beans;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import org.netbeans.Events;
import org.netbeans.InvalidException;
import org.netbeans.Module;
import org.netbeans.Util;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExClipboard;

public abstract class ManifestSection<T> {
    private final Object superclazz;
    private final String name;
    private final String className;
    private Class<?> clazz;
    private Object result;
    private Exception problem;
    private final Module module;

    protected ManifestSection(String name, Module module, Object superclazz) throws InvalidException {
        this.name = name;
        this.module = module;
        this.superclazz = superclazz;
        try {
            this.className = Util.createPackageName(name);
        }
        catch (IllegalArgumentException iae) {
            InvalidException ie = new InvalidException(module, iae.toString());
            ie.initCause(iae);
            throw ie;
        }
    }

    public final Module getModule() {
        return this.module;
    }

    protected final ClassLoader getClassLoader() {
        return this.module != null ? this.module.getClassLoader() : this.getClass().getClassLoader();
    }

    public final boolean isDefaultInstance() {
        return this.name.endsWith(".class");
    }

    public final Class<?> getSectionClass() throws Exception {
        if (this.clazz != null) {
            return this.clazz;
        }
        if (this.problem != null) {
            throw this.problem;
        }
        if (this.isDefaultInstance()) {
            try {
                this.clazz = this.getClassLoader().loadClass(this.className);
                if (!this.getSuperclass().isAssignableFrom(this.clazz)) {
                    throw new ClassCastException("Class " + this.clazz.getName() + " is not a subclass of " + this.getSuperclass().getName());
                }
                if (this.clazz.getClassLoader() != this.getClassLoader()) {
                    Events ev = this.module.getManager().getEvents();
                    ev.log("wrongClassLoader", this.module, this.clazz, this.getClassLoader());
                }
                return this.clazz;
            }
            catch (ClassNotFoundException cnfe) {
                Exceptions.attachMessage(cnfe, "Loader for ClassNotFoundException: " + this.getClassLoader());
                this.problem = cnfe;
                throw this.problem;
            }
            catch (Exception e) {
                this.problem = e;
                throw this.problem;
            }
            catch (LinkageError t) {
                this.problem = new ClassNotFoundException(t.toString(), t);
                throw this.problem;
            }
        }
        this.clazz = this.getInstance().getClass();
        return this.clazz;
    }

    public String getSectionClassName() throws Exception {
        if (this.isDefaultInstance()) {
            return this.className;
        }
        return this.getSectionClass().getName();
    }

    protected final Object createInstance() throws Exception {
        if (!this.isDefaultInstance()) {
            try {
                Object o = Beans.instantiate(this.getClassLoader(), this.className);
                this.clazz = o.getClass();
                if (!this.getSectionClass().isAssignableFrom(this.clazz)) {
                    throw new ClassCastException("Class " + this.clazz.getName() + " is not a subclass of " + this.getSuperclass().getName());
                }
                return o;
            }
            catch (ClassNotFoundException cnfe) {
                Exceptions.attachMessage(cnfe, "Loader for ClassNotFoundException: " + this.getClassLoader());
                throw cnfe;
            }
            catch (LinkageError le) {
                throw new ClassNotFoundException(le.toString(), le);
            }
        }
        this.getSectionClass();
        if (SharedClassObject.class.isAssignableFrom(this.clazz)) {
            return SharedClassObject.findObject(this.clazz.asSubclass(SharedClassObject.class), true);
        }
        return this.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public final Object getInstance() throws Exception {
        if (this.problem != null) {
            this.problem.fillInStackTrace();
            throw this.problem;
        }
        if (this.result == null) {
            try {
                this.result = this.createInstance();
            }
            catch (Exception ex) {
                this.problem = ex;
                throw this.problem;
            }
            catch (LinkageError t) {
                this.problem = new ClassNotFoundException(t.toString(), t);
                throw this.problem;
            }
        }
        return this.result;
    }

    public final Class<?> getSuperclass() {
        if (this.superclazz instanceof Class) {
            return (Class)this.superclazz;
        }
        try {
            return ManifestSection.getClazz((String)this.superclazz, this.module);
        }
        catch (InvalidException ex) {
            throw (IllegalStateException)new IllegalStateException(this.superclazz.toString()).initCause(ex);
        }
    }

    public void dispose() {
        this.result = null;
        this.problem = null;
        this.clazz = null;
    }

    public String toString() {
        return "ManifestSection[" + this.className + "]";
    }

    public static ManifestSection create(String name, Attributes attr, Module module) throws InvalidException {
        String sectionName = attr.getValue("OpenIDE-Module-Class");
        if (sectionName == null) {
            return null;
        }
        if (sectionName.equalsIgnoreCase("Action")) {
            ManifestSection.warnObsolete(sectionName, module);
            return new ActionSection(name, module);
        }
        if (sectionName.equalsIgnoreCase("Option")) {
            ManifestSection.warnObsolete(sectionName, module);
            return null;
        }
        if (sectionName.equalsIgnoreCase("Loader")) {
            ManifestSection.warnObsolete(sectionName, module);
            return new LoaderSection(name, attr, module);
        }
        if (sectionName.equalsIgnoreCase("Filesystem")) {
            ManifestSection.warnObsolete(sectionName, module);
            return null;
        }
        if (sectionName.equalsIgnoreCase("Node")) {
            ManifestSection.warnObsolete(sectionName, module);
            Util.err.warning("(See http://www.netbeans.org/issues/show_bug.cgi?id=19609, last comment, for howto.)");
            return null;
        }
        if (sectionName.equalsIgnoreCase("Service")) {
            ManifestSection.warnObsolete(sectionName, module);
            return null;
        }
        if (sectionName.equalsIgnoreCase("Debugger")) {
            ManifestSection.warnObsolete(sectionName, module);
            return new DebuggerSection(name, module);
        }
        if (sectionName.equalsIgnoreCase("ClipboardConvertor")) {
            ManifestSection.warnObsolete(sectionName, module);
            return new ClipboardConvertorSection(name, module);
        }
        throw new InvalidException(module, "Illegal manifest section type: " + sectionName);
    }

    private static void warnObsolete(String sectionName, Module module) {
        if (module == null) {
            return;
        }
        Util.err.warning("Use of OpenIDE-Module-Class: " + sectionName + " in " + module.getCodeNameBase() + " is obsolete.");
        Util.err.warning("(Please use layer-based installation of objects instead.)");
    }

    static Class<?> getClazz(String name, Module m) throws InvalidException {
        try {
            return Lookup.getDefault().lookup(ClassLoader.class).loadClass(name);
        }
        catch (ClassNotFoundException cnfe) {
            InvalidException e = new InvalidException(m, "Unable to locate class: " + name + " maybe you do not have its module enabled!?");
            e.initCause(cnfe);
            throw e;
        }
    }

    public static final class ActionSection
    extends ManifestSection {
        ActionSection(String name, Module module) throws InvalidException {
            super(name, module, SystemAction.class);
        }
    }

    public static final class LoaderSection
    extends ManifestSection {
        private final String[] installAfter;
        private final String[] installBefore;

        LoaderSection(String name, Attributes attrs, Module module) throws InvalidException {
            super(name, module, "org.openide.loaders.DataLoader");
            String clazz;
            LinkedList<String> res;
            StringTokenizer tok;
            String val = attrs.getValue("Install-After");
            if (val != null) {
                tok = new StringTokenizer(val, ", ");
                res = new LinkedList<String>();
                while (tok.hasMoreTokens()) {
                    clazz = tok.nextToken();
                    if (clazz.equals("")) continue;
                    res.add(clazz);
                }
                this.installAfter = res.toArray(new String[0]);
            } else {
                this.installAfter = null;
            }
            val = attrs.getValue("Install-Before");
            if (val != null) {
                tok = new StringTokenizer(val, ", ");
                res = new LinkedList();
                while (tok.hasMoreTokens()) {
                    clazz = tok.nextToken();
                    if (clazz.equals("")) continue;
                    res.add(clazz);
                }
                this.installBefore = res.toArray(new String[0]);
            } else {
                this.installBefore = null;
            }
        }

        public String[] getInstallAfter() {
            return this.installAfter;
        }

        public String[] getInstallBefore() {
            return this.installBefore;
        }
    }

    @Deprecated
    public static final class DebuggerSection
    extends ManifestSection {
        DebuggerSection(String name, Module module) throws InvalidException {
            super(name, module, DebuggerSection.getClazz("org.openide.debugger.Debugger", module));
        }
    }

    @Deprecated
    public static final class ClipboardConvertorSection
    extends ManifestSection {
        ClipboardConvertorSection(String name, Module module) throws InvalidException {
            super(name, module, ExClipboard.Convertor.class);
        }
    }
}

