/*
 * Decompiled with CFR 0.152.
 */
package jpt.sun.tools.javap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jpt.sun.tools.classfile.Code_attribute;
import jpt.sun.tools.classfile.Instruction;
import jpt.sun.tools.classfile.Method;
import jpt.sun.tools.classfile.RuntimeInvisibleTypeAnnotations_attribute;
import jpt.sun.tools.classfile.RuntimeTypeAnnotations_attribute;
import jpt.sun.tools.classfile.RuntimeVisibleTypeAnnotations_attribute;
import jpt.sun.tools.classfile.TypeAnnotation;
import jpt.sun.tools.javac.util.StringUtils;
import jpt.sun.tools.javap.AnnotationWriter;
import jpt.sun.tools.javap.ClassWriter;
import jpt.sun.tools.javap.Context;
import jpt.sun.tools.javap.InstructionDetailWriter;

public class TypeAnnotationWriter
extends InstructionDetailWriter {
    private AnnotationWriter annotationWriter;
    private ClassWriter classWriter;
    private Map<Integer, List<Note>> pcMap;

    static TypeAnnotationWriter instance(Context context) {
        TypeAnnotationWriter instance = context.get(TypeAnnotationWriter.class);
        if (instance == null) {
            instance = new TypeAnnotationWriter(context);
        }
        return instance;
    }

    protected TypeAnnotationWriter(Context context) {
        super(context);
        context.put(TypeAnnotationWriter.class, this);
        this.annotationWriter = AnnotationWriter.instance(context);
        this.classWriter = ClassWriter.instance(context);
    }

    public void reset(Code_attribute attr) {
        Method m = this.classWriter.getMethod();
        this.pcMap = new HashMap<Integer, List<Note>>();
        this.check(NoteKind.VISIBLE, (RuntimeVisibleTypeAnnotations_attribute)m.attributes.get("RuntimeVisibleTypeAnnotations"));
        this.check(NoteKind.INVISIBLE, (RuntimeInvisibleTypeAnnotations_attribute)m.attributes.get("RuntimeInvisibleTypeAnnotations"));
    }

    private void check(NoteKind kind, RuntimeTypeAnnotations_attribute attr) {
        if (attr == null) {
            return;
        }
        for (TypeAnnotation anno : attr.annotations) {
            TypeAnnotation.Position p = anno.position;
            Note note = null;
            if (p.offset != -1) {
                note = new Note(kind, anno);
                this.addNote(p.offset, note);
            }
            if (p.lvarOffset == null) continue;
            for (int i = 0; i < p.lvarOffset.length; ++i) {
                if (note == null) {
                    note = new Note(kind, anno);
                }
                this.addNote(p.lvarOffset[i], note);
            }
        }
    }

    private void addNote(int pc, Note note) {
        List<Note> list = this.pcMap.get(pc);
        if (list == null) {
            list = new ArrayList<Note>();
            this.pcMap.put(pc, list);
        }
        list.add(note);
    }

    @Override
    void writeDetails(Instruction instr) {
        String indent = this.space(2);
        int pc = instr.getPC();
        List<Note> notes = this.pcMap.get(pc);
        if (notes != null) {
            for (Note n : notes) {
                this.print(indent);
                this.print("@");
                this.annotationWriter.write(n.anno, false, true);
                this.print(", ");
                this.println(StringUtils.toLowerCase(n.kind.toString()));
            }
        }
    }

    public static enum NoteKind {
        VISIBLE,
        INVISIBLE;

    }

    public static class Note {
        public final NoteKind kind;
        public final TypeAnnotation anno;

        Note(NoteKind kind, TypeAnnotation anno) {
            this.kind = kind;
            this.anno = anno;
        }
    }
}

