/*
 * Decompiled with CFR 0.152.
 */
package jpt.sun.tools.javac.parser;

import java.util.HashMap;
import java.util.Map;
import jpt.sun.source.doctree.DocCommentTree;
import jpt.sun.tools.javac.parser.ParserFactory;
import jpt.sun.tools.javac.parser.Tokens;
import jpt.sun.tools.javac.tree.DocCommentTable;
import jpt.sun.tools.javac.tree.JCTree;
import jpt.sun.tools.javac.util.DiagnosticSource;
import jpt30.lang.model.util.Elements;

public class LazyDocCommentTable
implements DocCommentTable {
    private final ParserFactory fac;
    private final DiagnosticSource diagSource;
    private final Map<JCTree, Entry> table;

    LazyDocCommentTable(ParserFactory fac) {
        this.fac = fac;
        this.diagSource = fac.log.currentSource();
        this.table = new HashMap<JCTree, Entry>();
    }

    @Override
    public boolean hasComment(JCTree tree) {
        return this.table.containsKey(tree);
    }

    @Override
    public Tokens.Comment getComment(JCTree tree) {
        Entry e = this.table.get(tree);
        return e == null ? null : e.comment;
    }

    @Override
    public Elements.DocCommentKind getCommentKind(JCTree tree) {
        Elements.DocCommentKind docCommentKind;
        Tokens.Comment c = this.getComment(tree);
        if (c == null) {
            docCommentKind = null;
        } else {
            switch (c.getStyle()) {
                case JAVADOC_BLOCK: {
                    docCommentKind = Elements.DocCommentKind.TRADITIONAL;
                    break;
                }
                case JAVADOC_LINE: {
                    docCommentKind = Elements.DocCommentKind.END_OF_LINE;
                    break;
                }
                default: {
                    throw new IllegalStateException(c.getStyle().toString());
                }
            }
        }
        return docCommentKind;
    }

    @Override
    public String getCommentText(JCTree tree) {
        Tokens.Comment c = this.getComment(tree);
        return c == null ? null : c.getText();
    }

    @Override
    public DocCommentTree getCommentTree(JCTree tree) {
        Entry e = this.table.get(tree);
        if (e == null) {
            return null;
        }
        if (e.tree == null) {
            e.tree = this.fac.getTrees().getDocCommentTree(this.diagSource, e.comment);
        }
        return e.tree;
    }

    @Override
    public void putComment(JCTree tree, Tokens.Comment c) {
        this.table.put(tree, new Entry(c));
    }

    private static class Entry {
        final Tokens.Comment comment;
        DocCommentTree tree;

        Entry(Tokens.Comment c) {
            this.comment = c;
        }
    }
}

