/*
 * Decompiled with CFR 0.152.
 */
package jpt.sun.source.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import jpt.sun.source.doctree.DocCommentTree;
import jpt.sun.source.doctree.DocTree;
import jpt.sun.source.util.DocTreePathScanner;
import jpt.sun.source.util.TreePath;

public class DocTreePath
implements Iterable<DocTree> {
    private final TreePath treePath;
    private final DocCommentTree docComment;
    private final DocTree leaf;
    private final DocTreePath parent;

    public static DocTreePath getPath(TreePath treePath, DocCommentTree doc, DocTree target) {
        return DocTreePath.getPath(new DocTreePath(treePath, doc), target);
    }

    public static DocTreePath getPath(DocTreePath path, DocTree target) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(target);
        class PathFinder
        extends DocTreePathScanner<DocTreePath, DocTree> {
            private DocTreePath result;

            PathFinder() {
            }

            @Override
            public DocTreePath scan(DocTreePath path, DocTree target) {
                super.scan(path, target);
                return this.result;
            }

            @Override
            public DocTreePath scan(DocTree tree, DocTree target) {
                if (this.result == null) {
                    if (tree == target) {
                        this.result = new DocTreePath(this.getCurrentPath(), target);
                    } else {
                        super.scan(tree, target);
                    }
                }
                return this.result;
            }

            @Override
            public DocTreePath scan(Iterable<? extends DocTree> nodes, DocTree target) {
                if (nodes != null && this.result == null) {
                    for (DocTree docTree : nodes) {
                        this.scan(docTree, target);
                        if (this.result == null) continue;
                        break;
                    }
                }
                return this.result;
            }
        }
        return path.getLeaf() == target ? path : new PathFinder().scan(path, target);
    }

    public DocTreePath(TreePath treePath, DocCommentTree t) {
        this.treePath = treePath;
        this.docComment = Objects.requireNonNull(t);
        this.parent = null;
        this.leaf = t;
    }

    public DocTreePath(DocTreePath p, DocTree t) {
        if (t.getKind() == DocTree.Kind.DOC_COMMENT) {
            throw new IllegalArgumentException("Use DocTreePath(TreePath, DocCommentTree) to construct DocTreePath for a DocCommentTree.");
        }
        this.treePath = p.treePath;
        this.docComment = p.docComment;
        this.parent = p;
        this.leaf = t;
    }

    public TreePath getTreePath() {
        return this.treePath;
    }

    public DocCommentTree getDocComment() {
        return this.docComment;
    }

    public DocTree getLeaf() {
        return this.leaf;
    }

    public DocTreePath getParentPath() {
        return this.parent;
    }

    @Override
    public Iterator<DocTree> iterator() {
        return new Iterator<DocTree>(){
            private DocTreePath next;
            {
                this.next = DocTreePath.this;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public DocTree next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                DocTree t = this.next.leaf;
                this.next = this.next.parent;
                return t;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

