/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config;

import jakarta.faces.FacesException;
import jakarta.faces.application.ApplicationConfigurationPopulator;
import jakarta.faces.context.ExternalContext;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.myfaces.config.ConfigFilesXmlValidationUtils;
import org.apache.myfaces.config.FacesConfigUnmarshaller;
import org.apache.myfaces.config.annotation.AnnotationConfigurator;
import org.apache.myfaces.config.element.FacesConfig;
import org.apache.myfaces.config.element.FacesFlowDefinition;
import org.apache.myfaces.config.element.facelets.FaceletTagLibrary;
import org.apache.myfaces.config.impl.FacesConfigUnmarshallerImpl;
import org.apache.myfaces.config.impl.element.FacesConfigImpl;
import org.apache.myfaces.config.impl.element.FacesFlowDefinitionImpl;
import org.apache.myfaces.config.impl.element.FacesFlowReturnImpl;
import org.apache.myfaces.config.impl.element.FactoryImpl;
import org.apache.myfaces.config.impl.element.NavigationCaseImpl;
import org.apache.myfaces.config.webparameters.MyfacesConfig;
import org.apache.myfaces.spi.FaceletConfigResourceProvider;
import org.apache.myfaces.spi.FaceletConfigResourceProviderFactory;
import org.apache.myfaces.spi.FacesConfigResourceProvider;
import org.apache.myfaces.spi.FacesConfigResourceProviderFactory;
import org.apache.myfaces.spi.FacesConfigurationProvider;
import org.apache.myfaces.spi.ServiceProviderFinder;
import org.apache.myfaces.spi.ServiceProviderFinderFactory;
import org.apache.myfaces.util.WebConfigParamUtils;
import org.apache.myfaces.util.lang.ClassUtils;
import org.apache.myfaces.util.lang.FastWriter;
import org.apache.myfaces.view.facelets.compiler.TagLibraryConfigUnmarshallerImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class DefaultFacesConfigurationProvider
extends FacesConfigurationProvider {
    private static final String STANDARD_FACES_CONFIG_RESOURCE = "META-INF/standard-faces-config.xml";
    private static final String DEFAULT_FACES_CONFIG = "/WEB-INF/faces-config.xml";
    private static final Set<String> FACTORY_NAMES = new HashSet<String>();
    private static final Logger log;
    private FacesConfigUnmarshaller<? extends FacesConfig> _unmarshaller;
    private AnnotationConfigurator _annotationConfigurator;

    protected void setUnmarshaller(ExternalContext ectx, FacesConfigUnmarshaller<? extends FacesConfig> unmarshaller) {
        this._unmarshaller = unmarshaller;
    }

    protected FacesConfigUnmarshaller<? extends FacesConfig> getUnmarshaller(ExternalContext ectx) {
        if (this._unmarshaller == null) {
            this._unmarshaller = new FacesConfigUnmarshallerImpl(ectx);
        }
        return this._unmarshaller;
    }

    protected void setAnnotationConfigurator(AnnotationConfigurator configurator) {
        this._annotationConfigurator = configurator;
    }

    protected AnnotationConfigurator getAnnotationConfigurator() {
        if (this._annotationConfigurator == null) {
            this._annotationConfigurator = new AnnotationConfigurator();
        }
        return this._annotationConfigurator;
    }

    @Override
    public FacesConfig getStandardFacesConfig(ExternalContext ectx) {
        FacesConfig facesConfig;
        block11: {
            URL url;
            if (MyfacesConfig.getCurrentInstance(ectx).isValidateXML() && (url = ClassUtils.getResource(STANDARD_FACES_CONFIG_RESOURCE)) != null) {
                this.validateFacesConfig(ectx, url);
            }
            InputStream stream = ClassUtils.getResourceAsStream(STANDARD_FACES_CONFIG_RESOURCE);
            try {
                FacesConfig facesConfig2;
                if (stream == null) {
                    throw new FacesException("Standard faces config META-INF/standard-faces-config.xml not found");
                }
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Reading standard config META-INF/standard-faces-config.xml");
                }
                facesConfig = facesConfig2 = this.getUnmarshaller(ectx).getFacesConfig(stream, STANDARD_FACES_CONFIG_RESOURCE);
                if (stream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | SAXException e) {
                    throw new FacesException((Throwable)e);
                }
            }
            stream.close();
        }
        return facesConfig;
    }

    @Override
    public FacesConfig getAnnotationsFacesConfig(ExternalContext ectx, boolean metadataComplete) {
        return this.getAnnotationConfigurator().createFacesConfig(ectx, metadataComplete);
    }

    @Override
    public FacesConfig getMetaInfServicesFacesConfig(ExternalContext ectx) {
        try {
            FacesConfigImpl facesConfig = new FacesConfigImpl();
            FactoryImpl factory = new FactoryImpl();
            facesConfig.addFactory(factory);
            for (String factoryName : FACTORY_NAMES) {
                List<String> classList = ServiceProviderFinderFactory.getServiceProviderFinder(ectx).getServiceProviderList(factoryName);
                block37: for (String className : classList) {
                    if (log.isLoggable(Level.INFO)) {
                        log.info("Found " + factoryName + " factory implementation: " + className);
                    }
                    switch (factoryName) {
                        case "jakarta.faces.application.ApplicationFactory": {
                            factory.addApplicationFactory(className);
                            continue block37;
                        }
                        case "jakarta.faces.context.ExceptionHandlerFactory": {
                            factory.addExceptionHandlerFactory(className);
                            continue block37;
                        }
                        case "jakarta.faces.context.ExternalContextFactory": {
                            factory.addExternalContextFactory(className);
                            continue block37;
                        }
                        case "jakarta.faces.context.FacesContextFactory": {
                            factory.addFacesContextFactory(className);
                            continue block37;
                        }
                        case "jakarta.faces.lifecycle.LifecycleFactory": {
                            factory.addLifecycleFactory(className);
                            continue block37;
                        }
                        case "jakarta.faces.render.RenderKitFactory": {
                            factory.addRenderkitFactory(className);
                            continue block37;
                        }
                        case "jakarta.faces.view.facelets.TagHandlerDelegateFactory": {
                            factory.addTagHandlerDelegateFactory(className);
                            continue block37;
                        }
                        case "jakarta.faces.context.PartialViewContextFactory": {
                            factory.addPartialViewContextFactory(className);
                            continue block37;
                        }
                        case "jakarta.faces.component.visit.VisitContextFactory": {
                            factory.addVisitContextFactory(className);
                            continue block37;
                        }
                        case "jakarta.faces.view.ViewDeclarationLanguageFactory": {
                            factory.addViewDeclarationLanguageFactory(className);
                            continue block37;
                        }
                        case "jakarta.faces.context.FlashFactory": {
                            factory.addFlashFactory(className);
                            continue block37;
                        }
                        case "jakarta.faces.flow.FlowHandlerFactory": {
                            factory.addFlowHandlerFactory(className);
                            continue block37;
                        }
                        case "jakarta.faces.lifecycle.ClientWindowFactory": {
                            factory.addClientWindowFactory(className);
                            continue block37;
                        }
                        case "jakarta.faces.view.facelets.FaceletCacheFactory": {
                            factory.addFaceletCacheFactory(className);
                            continue block37;
                        }
                        case "jakarta.faces.component.search.SearchExpressionContextFactory": {
                            factory.addSearchExpressionContextFactory(className);
                            continue block37;
                        }
                    }
                    throw new IllegalStateException("Unexpected factory name " + factoryName);
                }
            }
            return facesConfig;
        }
        catch (Throwable e) {
            throw new FacesException(e);
        }
    }

    @Override
    public List<FacesConfig> getClassloaderFacesConfig(ExternalContext ectx) {
        ArrayList<FacesConfig> appConfigResources = new ArrayList<FacesConfig>();
        try {
            FacesConfigResourceProvider provider = FacesConfigResourceProviderFactory.getFacesConfigResourceProviderFactory(ectx).createFacesConfigResourceProvider(ectx);
            Collection<URL> facesConfigs = provider.getMetaInfConfigurationResources(ectx);
            for (URL url : facesConfigs) {
                if (MyfacesConfig.getCurrentInstance(ectx).isValidateXML()) {
                    this.validateFacesConfig(ectx, url);
                }
                InputStream stream = this.openStreamWithoutCache(url);
                try {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Reading config: " + url.toExternalForm());
                    }
                    appConfigResources.add(this.getUnmarshaller(ectx).getFacesConfig(stream, url.toExternalForm()));
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
        }
        catch (Throwable e) {
            throw new FacesException(e);
        }
        return appConfigResources;
    }

    @Override
    public List<FacesConfig> getContextSpecifiedFacesConfig(ExternalContext ectx) {
        ArrayList<FacesConfig> appConfigResources = new ArrayList<FacesConfig>();
        try {
            for (String systemId : this.getConfigFilesList(ectx)) {
                URL url;
                if (MyfacesConfig.getCurrentInstance(ectx).isValidateXML() && (url = ectx.getResource(systemId)) != null) {
                    this.validateFacesConfig(ectx, url);
                }
                InputStream stream = ectx.getResourceAsStream(systemId);
                try {
                    if (stream == null) {
                        log.severe("Faces config resource " + systemId + " not found");
                        continue;
                    }
                    if (log.isLoggable(Level.INFO)) {
                        log.info("Reading config " + systemId);
                    }
                    appConfigResources.add(this.getUnmarshaller(ectx).getFacesConfig(stream, systemId));
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
        }
        catch (Throwable e) {
            throw new FacesException(e);
        }
        return appConfigResources;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FacesConfig getWebAppFacesConfig(ExternalContext ectx) {
        try {
            URL url;
            try (InputStream stream = ectx.getResourceAsStream(DEFAULT_FACES_CONFIG);){
                if (stream != null) {
                    int length;
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    byte[] buffer = new byte[1024];
                    while ((length = stream.read(buffer)) != -1) {
                        out.write(buffer, 0, length);
                    }
                    out.flush();
                    String content = out.toString();
                    if (content.trim().isEmpty()) {
                        FacesConfigImpl facesConfigImpl = new FacesConfigImpl();
                        return facesConfigImpl;
                    }
                }
            }
            if (MyfacesConfig.getCurrentInstance(ectx).isValidateXML() && (url = ectx.getResource(DEFAULT_FACES_CONFIG)) != null) {
                this.validateFacesConfig(ectx, url);
            }
            stream = ectx.getResourceAsStream(DEFAULT_FACES_CONFIG);
            try {
                if (stream == null) return null;
                if (log.isLoggable(Level.INFO)) {
                    log.info("Reading config /WEB-INF/faces-config.xml");
                }
                FacesConfig facesConfig = this.getUnmarshaller(ectx).getFacesConfig(stream, DEFAULT_FACES_CONFIG);
                return facesConfig;
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (IOException | SAXException e) {
            throw new FacesException((Throwable)e);
        }
    }

    private InputStream openStreamWithoutCache(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        return connection.getInputStream();
    }

    private List<String> getConfigFilesList(ExternalContext ectx) {
        String configFiles = ectx.getInitParameter("jakarta.faces.CONFIG_FILES");
        ArrayList<String> configFilesList = new ArrayList<String>();
        if (configFiles != null) {
            StringTokenizer st = new StringTokenizer(configFiles, ",", false);
            while (st.hasMoreTokens()) {
                String systemId = st.nextToken().trim();
                if (DEFAULT_FACES_CONFIG.equals(systemId)) {
                    if (!log.isLoggable(Level.WARNING)) continue;
                    log.warning("/WEB-INF/faces-config.xml has been specified in the jakarta.faces.CONFIG_FILES context parameter of the deployment descriptor. This will automatically be removed, if we wouldn't do this, it would be loaded twice.  See Faces spec 1.1, 10.3.2");
                    continue;
                }
                configFilesList.add(systemId);
            }
        }
        return configFilesList;
    }

    private void validateFacesConfig(ExternalContext ectx, URL url) throws IOException, SAXException {
        String version = ConfigFilesXmlValidationUtils.getFacesConfigVersion(url);
        if ("1.2".equals(version) || "2.0".equals(version) || "2.1".equals(version) || "2.2".equals(version) || "2.3".equals(version) || "3.0".equals(version) || "4.0".equals(version) || "4.1".equals(version)) {
            ConfigFilesXmlValidationUtils.validateFacesConfigFile(url, ectx, version);
        }
    }

    @Override
    public List<FacesConfig> getApplicationConfigurationResourceDocumentPopulatorFacesConfig(ExternalContext ectx) {
        ServiceProviderFinder spff = ServiceProviderFinderFactory.getServiceProviderFinder(ectx);
        ServiceLoader<ApplicationConfigurationPopulator> instances = spff.load(ApplicationConfigurationPopulator.class);
        if (instances != null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            try {
                factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
                factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                factory.setXIncludeAware(false);
                factory.setExpandEntityReferences(false);
            }
            catch (Throwable e) {
                log.log(Level.WARNING, "DocumentBuilderFactory#setFeature not implemented. Skipping...", e);
            }
            DocumentBuilder builder = null;
            DOMImplementation domImpl = null;
            try {
                builder = factory.newDocumentBuilder();
                domImpl = builder.getDOMImplementation();
            }
            catch (ParserConfigurationException ex) {
                log.log(Level.SEVERE, "Cannot create dom document builder, skipping it", ex);
            }
            if (builder != null) {
                ArrayList<FacesConfig> facesConfigList = new ArrayList<FacesConfig>();
                ArrayList<Document> documentList = new ArrayList<Document>();
                for (ApplicationConfigurationPopulator populator : instances) {
                    Document document = domImpl.createDocument("http://java.sun.com/xml/ns/javaee", "faces-config", null);
                    populator.populateApplicationConfiguration(document);
                    documentList.add(document);
                }
                Transformer trans = null;
                try {
                    trans = TransformerFactory.newInstance().newTransformer();
                    trans.setOutputProperty("indent", "no");
                    trans.setOutputProperty("method", "xml");
                    trans.setOutputProperty("version", "1.0");
                    trans.setOutputProperty("encoding", "UTF-8");
                }
                catch (TransformerConfigurationException ex) {
                    Logger.getLogger(DefaultFacesConfigurationProvider.class.getName()).log(Level.SEVERE, null, ex);
                }
                if (trans != null) {
                    FastWriter xmlAsWriter = new FastWriter();
                    for (int i = 0; i < documentList.size(); ++i) {
                        Document document = (Document)documentList.get(i);
                        xmlAsWriter.reset();
                        try {
                            DOMSource source = new DOMSource(document);
                            StreamResult result = new StreamResult(xmlAsWriter);
                            trans.transform(source, result);
                            FacesConfig facesConfig = this.getUnmarshaller(ectx).getFacesConfig(xmlAsWriter.toString());
                            facesConfigList.add(facesConfig);
                            continue;
                        }
                        catch (IOException | TransformerException | SAXException ex) {
                            log.log(Level.SEVERE, "Error while reading faces-config from populator", ex);
                        }
                    }
                    return facesConfigList;
                }
                log.log(Level.SEVERE, "Cannot create xml transformer, skipping it");
            }
        }
        return Collections.emptyList();
    }

    @Override
    public List<FacesConfig> getFacesFlowFacesConfig(ExternalContext ectx) {
        Set directoryPaths = ectx.getResourcePaths("/");
        if (directoryPaths == null) {
            return Collections.emptyList();
        }
        ArrayList<FacesConfig> configFilesList = new ArrayList<FacesConfig>();
        List<String> contextSpecifiedList = this.getConfigFilesList(ectx);
        for (String dirPath : directoryPaths) {
            String flowName;
            String filePath;
            if (dirPath.equals("/WEB-INF/")) {
                Set webDirectoryPaths = ectx.getResourcePaths(dirPath);
                for (String webDirPath : webDirectoryPaths) {
                    String flowName2;
                    String filePath2;
                    if (!webDirPath.endsWith("/") || webDirPath.equals("/WEB-INF/classes/") || contextSpecifiedList.contains(filePath2 = webDirPath + (flowName2 = webDirPath.substring(9, webDirPath.length() - 1)) + "-flow.xml")) continue;
                    try {
                        FacesConfig fc;
                        URL url = ectx.getResource(filePath2);
                        if (url == null || (fc = this.parseFacesConfig(ectx, filePath2, url)) == null) continue;
                        configFilesList.add(fc);
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
                continue;
            }
            if (dirPath.startsWith("/META-INF") || !dirPath.endsWith("/") || contextSpecifiedList.contains(filePath = dirPath + (flowName = dirPath.substring(1, dirPath.length() - 1)) + "-flow.xml")) continue;
            try {
                FacesConfig fc;
                URL url = ectx.getResource(filePath);
                if (url == null || (fc = this.parseFacesConfig(ectx, filePath, url)) == null) continue;
                configFilesList.add(fc);
            }
            catch (MalformedURLException malformedURLException) {
            }
        }
        return configFilesList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FacesConfig parseFacesConfig(ExternalContext ectx, String systemId, URL url) {
        try {
            if (MyfacesConfig.getCurrentInstance(ectx).isValidateXML()) {
                this.validateFacesConfig(ectx, url);
            }
        }
        catch (IOException | SAXException e) {
            throw new FacesException((Throwable)e);
        }
        InputStream stream = ectx.getResourceAsStream(systemId);
        PushbackInputStream pbstream = new PushbackInputStream(stream, 10);
        try {
            if (stream == null) {
                log.severe("Faces config resource " + systemId + " not found");
                FacesConfig facesConfig = null;
                return facesConfig;
            }
            String flowName = systemId.substring(systemId.lastIndexOf(47) + 1, systemId.lastIndexOf("-flow.xml"));
            String startNodePath = systemId.substring(0, systemId.lastIndexOf(47) + 1) + flowName + ".xhtml";
            int c = pbstream.read();
            if (c == -1) {
                FacesConfigImpl facesConfig = new FacesConfigImpl();
                FacesFlowDefinitionImpl flow = new FacesFlowDefinitionImpl();
                flow.setId(flowName);
                flow.setDefiningDocumentId(systemId);
                flow.setStartNode(startNodePath);
                FacesFlowReturnImpl returnNode = new FacesFlowReturnImpl();
                returnNode.setId(flowName + "-return");
                NavigationCaseImpl returnNavCase = new NavigationCaseImpl();
                returnNavCase.setFromOutcome("/" + flowName + "-return");
                returnNode.setNavigationCase(returnNavCase);
                flow.addReturn(returnNode);
                facesConfig.addFacesFlowDefinition(flow);
                FacesConfigImpl facesConfigImpl = facesConfig;
                return facesConfigImpl;
            }
            pbstream.unread(c);
            if (log.isLoggable(Level.INFO)) {
                log.info("Reading config " + systemId);
            }
            FacesConfigImpl facesConfig = (FacesConfigImpl)this.getUnmarshaller(ectx).getFacesConfig(pbstream, systemId);
            for (FacesFlowDefinition definition : facesConfig.getFacesFlowDefinitions()) {
                FacesFlowDefinitionImpl flow;
                if (!flowName.equals(definition.getId()) || (flow = (FacesFlowDefinitionImpl)definition).getStartNode() != null) continue;
                flow.setStartNode(startNodePath);
            }
            FacesConfigImpl facesConfigImpl = facesConfig;
            return facesConfigImpl;
        }
        catch (IOException | SAXException e) {
            throw new FacesException((Throwable)e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public List<FacesConfig> getFaceletTaglibFacesConfig(ExternalContext externalContext) {
        ArrayList<FacesConfig> facesConfigFilesList = new ArrayList<FacesConfig>();
        String param = WebConfigParamUtils.getStringInitParameter(externalContext, "jakarta.faces.FACELETS_LIBRARIES");
        if (param != null) {
            for (String library : param.split(";")) {
                try {
                    URL src = externalContext.getResource(library.trim());
                    if (src == null) {
                        throw new FileNotFoundException(library);
                    }
                    FaceletTagLibrary tl = TagLibraryConfigUnmarshallerImpl.create(externalContext, src);
                    if (tl != null) {
                        FacesConfigImpl config = new FacesConfigImpl();
                        config.addFaceletTagLibrary(tl);
                        facesConfigFilesList.add(config);
                    }
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.fine("Successfully loaded library: " + library);
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, "Error loading library: " + library, e);
                }
            }
        }
        try {
            FaceletConfigResourceProvider provider = FaceletConfigResourceProviderFactory.getFacesConfigResourceProviderFactory(externalContext).createFaceletConfigResourceProvider(externalContext);
            Collection<URL> urls = provider.getFaceletTagLibConfigurationResources(externalContext);
            for (URL url : urls) {
                try {
                    FaceletTagLibrary tl = TagLibraryConfigUnmarshallerImpl.create(externalContext, url);
                    if (tl != null) {
                        FacesConfigImpl config = new FacesConfigImpl();
                        config.addFaceletTagLibrary(tl);
                        facesConfigFilesList.add(config);
                    }
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.fine("Added library from: " + String.valueOf(url));
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Error loading library: " + String.valueOf(url), e);
                }
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Compiler initialization error", e);
        }
        return facesConfigFilesList;
    }

    static {
        FACTORY_NAMES.add("jakarta.faces.application.ApplicationFactory");
        FACTORY_NAMES.add("jakarta.faces.lifecycle.ClientWindowFactory");
        FACTORY_NAMES.add("jakarta.faces.context.ExceptionHandlerFactory");
        FACTORY_NAMES.add("jakarta.faces.context.ExternalContextFactory");
        FACTORY_NAMES.add("jakarta.faces.view.facelets.FaceletCacheFactory");
        FACTORY_NAMES.add("jakarta.faces.context.FacesContextFactory");
        FACTORY_NAMES.add("jakarta.faces.context.FlashFactory");
        FACTORY_NAMES.add("jakarta.faces.flow.FlowHandlerFactory");
        FACTORY_NAMES.add("jakarta.faces.lifecycle.LifecycleFactory");
        FACTORY_NAMES.add("jakarta.faces.render.RenderKitFactory");
        FACTORY_NAMES.add("jakarta.faces.view.facelets.TagHandlerDelegateFactory");
        FACTORY_NAMES.add("jakarta.faces.context.PartialViewContextFactory");
        FACTORY_NAMES.add("jakarta.faces.component.visit.VisitContextFactory");
        FACTORY_NAMES.add("jakarta.faces.view.ViewDeclarationLanguageFactory");
        FACTORY_NAMES.add("jakarta.faces.component.search.SearchExpressionContextFactory");
        log = Logger.getLogger(DefaultFacesConfigurationProvider.class.getName());
    }
}

