/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.impl.scope;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import org.eclipse.aether.impl.scope.BuildPath;
import org.eclipse.aether.impl.scope.ProjectPath;

public final class BuildScopeQuery {
    private final Mode mode;
    private final ProjectPath projectPath;
    private final BuildPath buildPath;

    private BuildScopeQuery(Mode mode, ProjectPath projectPath, BuildPath buildPath) {
        this.mode = Objects.requireNonNull(mode, "mode");
        mode.validate(projectPath, buildPath);
        this.projectPath = projectPath;
        this.buildPath = buildPath;
    }

    public Mode getMode() {
        return this.mode;
    }

    public ProjectPath getProjectPath() {
        return this.projectPath;
    }

    public BuildPath getBuildPath() {
        return this.buildPath;
    }

    public String toString() {
        if (this.mode == Mode.ALL) {
            return this.mode.name();
        }
        if (this.mode == Mode.BY_PROJECT_PATH) {
            return this.mode.name() + "(" + this.projectPath.getId() + ")";
        }
        if (this.mode == Mode.BY_BUILD_PATH) {
            return this.mode.name() + "(" + this.buildPath.getId() + ")";
        }
        return this.mode.name() + "(" + this.projectPath.getId() + ", " + this.buildPath.getId() + ")";
    }

    public static Collection<BuildScopeQuery> all() {
        return Collections.singleton(new BuildScopeQuery(Mode.ALL, null, null));
    }

    public static Collection<BuildScopeQuery> byProjectPath(ProjectPath projectPath) {
        return Collections.singleton(new BuildScopeQuery(Mode.BY_PROJECT_PATH, projectPath, null));
    }

    public static Collection<BuildScopeQuery> byBuildPath(BuildPath buildPath) {
        return Collections.singleton(new BuildScopeQuery(Mode.BY_BUILD_PATH, null, buildPath));
    }

    public static Collection<BuildScopeQuery> select(ProjectPath projectPath, BuildPath buildPath) {
        return Collections.singleton(new BuildScopeQuery(Mode.SELECT, projectPath, buildPath));
    }

    public static Collection<BuildScopeQuery> singleton(ProjectPath projectPath, BuildPath buildPath) {
        return Collections.singleton(new BuildScopeQuery(Mode.SINGLETON, projectPath, buildPath));
    }

    @SafeVarargs
    public static Collection<BuildScopeQuery> union(Collection<BuildScopeQuery> ... buildScopeQueries) {
        HashSet<BuildScopeQuery> result = new HashSet<BuildScopeQuery>();
        Arrays.asList(buildScopeQueries).forEach(result::addAll);
        return result;
    }

    public static enum Mode {
        ALL,
        BY_PROJECT_PATH,
        BY_BUILD_PATH,
        SELECT,
        SINGLETON;


        private void validate(ProjectPath projectPath, BuildPath buildPath) {
            if (this == ALL && (projectPath != null || buildPath != null)) {
                throw new IllegalArgumentException(this.name() + " requires no parameter");
            }
            if (this == BY_PROJECT_PATH && (projectPath == null || buildPath != null)) {
                throw new IllegalArgumentException(this.name() + " requires project path parameter only");
            }
            if (this == BY_BUILD_PATH && (projectPath != null || buildPath == null)) {
                throw new IllegalArgumentException(this.name() + " requires build path parameter only");
            }
            if (!(this != SELECT && this != SINGLETON || projectPath != null && buildPath != null)) {
                throw new IllegalArgumentException(this.name() + " requires both parameters");
            }
        }
    }
}

