/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.dev.failsafe.internal;

import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kyuubi.shade.dev.failsafe.Bulkhead;
import org.apache.kyuubi.shade.dev.failsafe.BulkheadConfig;
import org.apache.kyuubi.shade.dev.failsafe.internal.BulkheadExecutor;
import org.apache.kyuubi.shade.dev.failsafe.internal.util.FutureLinkedList;
import org.apache.kyuubi.shade.dev.failsafe.spi.PolicyExecutor;

public class BulkheadImpl<R>
implements Bulkhead<R> {
    private static final CompletableFuture<Void> NULL_FUTURE = CompletableFuture.completedFuture(null);
    private final BulkheadConfig<R> config;
    private final int maxPermits;
    private int permits;
    private final FutureLinkedList futures = new FutureLinkedList();

    public BulkheadImpl(BulkheadConfig<R> config) {
        this.config = config;
        this.permits = this.maxPermits = config.getMaxConcurrency();
    }

    @Override
    public BulkheadConfig<R> getConfig() {
        return this.config;
    }

    @Override
    public void acquirePermit() throws InterruptedException {
        try {
            this.acquirePermitAsync().get();
        }
        catch (CancellationException | ExecutionException exception) {
            // empty catch block
        }
    }

    @Override
    public synchronized boolean tryAcquirePermit() {
        if (this.permits > 0) {
            --this.permits;
            return true;
        }
        return false;
    }

    @Override
    public boolean tryAcquirePermit(Duration maxWaitTime) throws InterruptedException {
        CompletableFuture<Void> future = this.acquirePermitAsync();
        if (future == NULL_FUTURE) {
            return true;
        }
        try {
            future.get(maxWaitTime.toNanos(), TimeUnit.NANOSECONDS);
            return true;
        }
        catch (CancellationException | ExecutionException | TimeoutException e) {
            return false;
        }
    }

    synchronized CompletableFuture<Void> acquirePermitAsync() {
        if (this.permits > 0) {
            --this.permits;
            return NULL_FUTURE;
        }
        return this.futures.add();
    }

    @Override
    public synchronized void releasePermit() {
        if (this.permits < this.maxPermits) {
            ++this.permits;
            CompletableFuture<Void> future = this.futures.pollFirst();
            if (future != null) {
                --this.permits;
                future.complete(null);
            }
        }
    }

    @Override
    public PolicyExecutor<R> toExecutor(int policyIndex) {
        return new BulkheadExecutor(this, policyIndex);
    }
}

