/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.client;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.kyuubi.client.RestClientConf;
import org.apache.kyuubi.client.exception.KyuubiRestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientFactory.class);

    public static CloseableHttpClient createHttpClient(RestClientConf conf) {
        SSLConnectionSocketFactory sslSocketFactory;
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(conf.getSocketTimeout()).setConnectTimeout(conf.getConnectTimeout()).build();
        try {
            org.apache.http.conn.ssl.TrustStrategy acceptingTrustStrategy = (cert, authType) -> true;
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)acceptingTrustStrategy).build();
            sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }
        catch (Exception e) {
            LOG.error("Error: ", (Throwable)e);
            throw new KyuubiRestException("Failed to create HttpClient", e);
        }
        return HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).build();
    }
}

