/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.ha.client.etcd;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.KyuubiException$;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.ha.HighAvailabilityConf$;
import org.apache.kyuubi.ha.client.DiscoveryClient;
import org.apache.kyuubi.ha.client.DiscoveryClient$;
import org.apache.kyuubi.ha.client.DiscoveryPaths$;
import org.apache.kyuubi.ha.client.ServiceDiscovery;
import org.apache.kyuubi.ha.client.ServiceNodeInfo;
import org.apache.kyuubi.ha.client.etcd.EtcdDiscoveryClient$;
import org.apache.kyuubi.ha.client.etcd.EtcdDiscoveryClient$ServiceNode$;
import org.apache.kyuubi.package$;
import org.apache.kyuubi.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.kyuubi.shade.io.etcd.jetcd.ByteSequence;
import org.apache.kyuubi.shade.io.etcd.jetcd.Client;
import org.apache.kyuubi.shade.io.etcd.jetcd.KV;
import org.apache.kyuubi.shade.io.etcd.jetcd.KeyValue;
import org.apache.kyuubi.shade.io.etcd.jetcd.Lease;
import org.apache.kyuubi.shade.io.etcd.jetcd.Lock;
import org.apache.kyuubi.shade.io.etcd.jetcd.Watch;
import org.apache.kyuubi.shade.io.etcd.jetcd.kv.GetResponse;
import org.apache.kyuubi.shade.io.etcd.jetcd.kv.PutResponse;
import org.apache.kyuubi.shade.io.etcd.jetcd.lease.LeaseKeepAliveResponse;
import org.apache.kyuubi.shade.io.etcd.jetcd.options.DeleteOption;
import org.apache.kyuubi.shade.io.etcd.jetcd.options.GetOption;
import org.apache.kyuubi.shade.io.etcd.jetcd.options.PutOption;
import org.apache.kyuubi.shade.io.etcd.jetcd.watch.WatchEvent;
import org.apache.kyuubi.shade.io.etcd.jetcd.watch.WatchResponse;
import org.apache.kyuubi.shade.io.grpc.netty.GrpcSslContexts;
import org.apache.kyuubi.shade.io.grpc.stub.StreamObserver;
import org.apache.kyuubi.shade.io.netty.handler.ssl.SslContext;
import org.apache.kyuubi.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0011mc\u0001B0a\u00015D\u0001\u0002\u001f\u0001\u0003\u0002\u0003\u0006I!\u001f\u0005\u0007\u007f\u0002!\t!!\u0001\u0007\r\u0005%\u0001\u0001QA\u0006\u0011)\tYc\u0001BK\u0002\u0013\u0005\u0011Q\u0006\u0005\u000b\u0003\u007f\u0019!\u0011#Q\u0001\n\u0005=\u0002BCA!\u0007\tU\r\u0011\"\u0001\u0002D!Q\u00111J\u0002\u0003\u0012\u0003\u0006I!!\u0012\t\r}\u001cA\u0011AA'\u0011%\t9fAA\u0001\n\u0003\tI\u0006C\u0005\u0002`\r\t\n\u0011\"\u0001\u0002b!I\u0011qO\u0002\u0012\u0002\u0013\u0005\u0011\u0011\u0010\u0005\n\u0003{\u001a\u0011\u0011!C!\u0003\u007fB\u0011\"a$\u0004\u0003\u0003%\t!!%\t\u0013\u0005e5!!A\u0005\u0002\u0005m\u0005\"CAT\u0007\u0005\u0005I\u0011IAU\u0011%\t9lAA\u0001\n\u0003\tI\fC\u0005\u0002D\u000e\t\t\u0011\"\u0011\u0002F\"I\u0011\u0011Z\u0002\u0002\u0002\u0013\u0005\u00131\u001a\u0005\n\u0003\u001b\u001c\u0011\u0011!C!\u0003\u001fD\u0011\"!5\u0004\u0003\u0003%\t%a5\b\u0013\u0005]\u0007!!A\t\u0002\u0005eg!CA\u0005\u0001\u0005\u0005\t\u0012AAn\u0011\u0019yh\u0003\"\u0001\u0002t\"I\u0011Q\u001a\f\u0002\u0002\u0013\u0015\u0013q\u001a\u0005\n\u0003k4\u0012\u0011!CA\u0003oD\u0011\"!@\u0017\u0003\u0003%\t)a@\t\u0015\r\u0004\u0001\u0019!a\u0001\n\u0003\u0011\t\u0002C\u0006\u0003$\u0001\u0001\r\u00111A\u0005\u0002\t\u0015\u0002b\u0003B\u0018\u0001\u0001\u0007\t\u0011)Q\u0005\u0005'A1B!\u000f\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0003<!Y!1\t\u0001A\u0002\u0003\u0007I\u0011\u0001B#\u0011-\u0011I\u0005\u0001a\u0001\u0002\u0003\u0006KA!\u0010\t\u0017\t5\u0003\u00011AA\u0002\u0013\u0005!q\n\u0005\f\u0005/\u0002\u0001\u0019!a\u0001\n\u0003\u0011I\u0006C\u0006\u0003^\u0001\u0001\r\u0011!Q!\n\tE\u0003b\u0003B1\u0001\u0001\u0007\t\u0019!C\u0001\u0005GB1Ba\u001b\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0003n!Y!\u0011\u000f\u0001A\u0002\u0003\u0005\u000b\u0015\u0002B3\u0011-\u0011)\b\u0001a\u0001\u0002\u0004%\tAa\u001e\t\u0017\te\u0004\u00011AA\u0002\u0013\u0005!1\u0010\u0005\f\u0005\u007f\u0002\u0001\u0019!A!B\u0013\ty\u0005C\u0006\u0003\u0004\u0002\u0001\r\u00111A\u0005\u0002\u0005\r\u0003b\u0003BC\u0001\u0001\u0007\t\u0019!C\u0001\u0005\u000fC1Ba#\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002F!9!q\u0012\u0001\u0005\n\tE\u0005b\u0002BJ\u0001\u0011\u0005#Q\u0013\u0005\b\u0005/\u0003A\u0011\tBK\u0011\u001d\u0011I\n\u0001C!\u00057C\u0011Ba*\u0001#\u0003%\tA!+\t\u000f\t5\u0006\u0001\"\u0011\u00030\"9!q\u0018\u0001\u0005B\t\u0005\u0007b\u0002Be\u0001\u0011\u0005#1\u001a\u0005\b\u0005+\u0004A\u0011\tBl\u0011\u001d\u0011Y\u000e\u0001C!\u0005;D\u0011B!:\u0001#\u0003%\tA!+\t\u000f\t\u001d\b\u0001\"\u0011\u0003j\"I!\u0011\u001f\u0001\u0012\u0002\u0013\u0005!\u0011\u0016\u0005\b\u0005g\u0004A\u0011\tB{\u0011\u001d\u0019\t\u0001\u0001C!\u0007\u0007Aqaa\u000b\u0001\t\u0003\u001ai\u0003C\u0004\u00048\u0001!\te!\u000f\t\u000f\r\u0005\u0003\u0001\"\u0011\u0004D!I1Q\f\u0001\u0012\u0002\u0013\u00051q\f\u0005\n\u0007G\u0002\u0011\u0013!C\u0001\u0005SCqa!\u001a\u0001\t\u0003\u001a9\u0007C\u0005\u0004z\u0001\t\n\u0011\"\u0001\u0004|!I1q\u0010\u0001\u0012\u0002\u0013\u0005!\u0011\u0016\u0005\b\u0007\u0003\u0003A\u0011\tBK\u0011\u001d\u0019\u0019\t\u0001C!\u0007\u000bCqa!#\u0001\t\u0003\u001aY\tC\u0005\u0004\u001a\u0002\t\n\u0011\"\u0001\u0004|!I11\u0014\u0001\u0012\u0002\u0013\u0005!\u0011\u0016\u0005\b\u0007;\u0003A\u0011IBP\u0011%\u0019Y\rAI\u0001\n\u0003\u0011I\u000bC\u0004\u0004N\u0002!\tea4\t\u0013\r]\u0007!%A\u0005\u0002\re\u0007bBBo\u0001\u0011%1q\u001c\u0005\n\u0007k\u0004\u0011\u0013!C\u0005\u0007wB\u0011ba>\u0001#\u0003%IA!+\t\u0013\re\b!%A\u0005\n\rmhABB\u0000\u0001\u0001!\t\u0001\u0003\u0006\u0004\u0014F\u0013\t\u0011)A\u0005\u0003_A!B!?R\u0005\u0003\u0005\u000b\u0011\u0002B~\u0011\u0019y\u0018\u000b\"\u0001\u0005\u0018!9AqD)\u0005B\u0011\u0005\u0002b\u0002C\u001a#\u0012\u0005CQ\u0007\u0005\b\t\u0003\nF\u0011\tBK\u000f\u001d!\u0019\u0005\u0019E\u0001\t\u000b2aa\u00181\t\u0002\u0011\u001d\u0003BB@Z\t\u0003!I\u0005C\u0005\u0005Le\u0013\r\u0011\"\u0004\u0002D!AAQJ-!\u0002\u001b\t)\u0005\u0003\u0006\u0005Pe\u0013\r\u0011\"\u0002a\t#B\u0001\u0002\"\u0017ZA\u00035A1\u000b\u0002\u0014\u000bR\u001cG\rR5tG>4XM]=DY&,g\u000e\u001e\u0006\u0003C\n\fA!\u001a;dI*\u00111\rZ\u0001\u0007G2LWM\u001c;\u000b\u0005\u00154\u0017A\u00015b\u0015\t9\u0007.\u0001\u0004lsV,(-\u001b\u0006\u0003S*\fa!\u00199bG\",'\"A6\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001qG\u000f\u0005\u0002pe6\t\u0001OC\u0001r\u0003\u0015\u00198-\u00197b\u0013\t\u0019\bO\u0001\u0004B]f\u0014VM\u001a\t\u0003kZl\u0011AY\u0005\u0003o\n\u0014q\u0002R5tG>4XM]=DY&,g\u000e^\u0001\u0005G>tg\r\u0005\u0002{{6\t1P\u0003\u0002}M\u000611m\u001c8gS\u001eL!A`>\u0003\u0015-KX/\u001e2j\u0007>tg-\u0001\u0004=S:LGO\u0010\u000b\u0005\u0003\u0007\t9\u0001E\u0002\u0002\u0006\u0001i\u0011\u0001\u0019\u0005\u0006q\n\u0001\r!\u001f\u0002\f'\u0016\u0014h/[2f\u001d>$Wm\u0005\u0004\u0004]\u00065\u00111\u0003\t\u0004_\u0006=\u0011bAA\ta\n9\u0001K]8ek\u000e$\b\u0003BA\u000b\u0003KqA!a\u0006\u0002\"9!\u0011\u0011DA\u0010\u001b\t\tYBC\u0002\u0002\u001e1\fa\u0001\u0010:p_Rt\u0014\"A9\n\u0007\u0005\r\u0002/A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u001d\u0012\u0011\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0004\u0003G\u0001\u0018\u0001\u00029bi\",\"!a\f\u0011\t\u0005E\u0012\u0011\b\b\u0005\u0003g\t)\u0004E\u0002\u0002\u001aAL1!a\u000eq\u0003\u0019\u0001&/\u001a3fM&!\u00111HA\u001f\u0005\u0019\u0019FO]5oO*\u0019\u0011q\u00079\u0002\u000bA\fG\u000f\u001b\u0011\u0002\u000b1,\u0017m]3\u0016\u0005\u0005\u0015\u0003cA8\u0002H%\u0019\u0011\u0011\n9\u0003\t1{gnZ\u0001\u0007Y\u0016\f7/\u001a\u0011\u0015\r\u0005=\u00131KA+!\r\t\tfA\u0007\u0002\u0001!9\u00111\u0006\u0005A\u0002\u0005=\u0002bBA!\u0011\u0001\u0007\u0011QI\u0001\u0005G>\u0004\u0018\u0010\u0006\u0004\u0002P\u0005m\u0013Q\f\u0005\n\u0003WI\u0001\u0013!a\u0001\u0003_A\u0011\"!\u0011\n!\u0003\u0005\r!!\u0012\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\r\u0016\u0005\u0003_\t)g\u000b\u0002\u0002hA!\u0011\u0011NA:\u001b\t\tYG\u0003\u0003\u0002n\u0005=\u0014!C;oG\",7m[3e\u0015\r\t\t\b]\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA;\u0003W\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a\u001f+\t\u0005\u0015\u0013QM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\u0005\u0005\u0003BAB\u0003\u001bk!!!\"\u000b\t\u0005\u001d\u0015\u0011R\u0001\u0005Y\u0006twM\u0003\u0002\u0002\f\u0006!!.\u0019<b\u0013\u0011\tY$!\"\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005M\u0005cA8\u0002\u0016&\u0019\u0011q\u00139\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005u\u00151\u0015\t\u0004_\u0006}\u0015bAAQa\n\u0019\u0011I\\=\t\u0013\u0005\u0015f\"!AA\u0002\u0005M\u0015a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002,B1\u0011QVAZ\u0003;k!!a,\u000b\u0007\u0005E\u0006/\u0001\u0006d_2dWm\u0019;j_:LA!!.\u00020\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tY,!1\u0011\u0007=\fi,C\u0002\u0002@B\u0014qAQ8pY\u0016\fg\u000eC\u0005\u0002&B\t\t\u00111\u0001\u0002\u001e\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t\t)a2\t\u0013\u0005\u0015\u0016#!AA\u0002\u0005M\u0015\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005M\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\u0005\u0015AB3rk\u0006d7\u000f\u0006\u0003\u0002<\u0006U\u0007\"CAS)\u0005\u0005\t\u0019AAO\u0003-\u0019VM\u001d<jG\u0016tu\u000eZ3\u0011\u0007\u0005EccE\u0003\u0017\u0003;\fI\u000f\u0005\u0006\u0002`\u0006\u0015\u0018qFA#\u0003\u001fj!!!9\u000b\u0007\u0005\r\b/A\u0004sk:$\u0018.\\3\n\t\u0005\u001d\u0018\u0011\u001d\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004\u0003BAv\u0003cl!!!<\u000b\t\u0005=\u0018\u0011R\u0001\u0003S>LA!a\n\u0002nR\u0011\u0011\u0011\\\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u0003\u001f\nI0a?\t\u000f\u0005-\u0012\u00041\u0001\u00020!9\u0011\u0011I\rA\u0002\u0005\u0015\u0013aB;oCB\u0004H.\u001f\u000b\u0005\u0005\u0003\u0011i\u0001E\u0003p\u0005\u0007\u00119!C\u0002\u0003\u0006A\u0014aa\u00149uS>t\u0007cB8\u0003\n\u0005=\u0012QI\u0005\u0004\u0005\u0017\u0001(A\u0002+va2,'\u0007C\u0005\u0003\u0010i\t\t\u00111\u0001\u0002P\u0005\u0019\u0001\u0010\n\u0019\u0016\u0005\tM\u0001\u0003\u0002B\u000b\u0005?i!Aa\u0006\u000b\t\te!1D\u0001\u0006U\u0016$8\r\u001a\u0006\u0004C\nu!BAAx\u0013\u0011\u0011\tCa\u0006\u0003\r\rc\u0017.\u001a8u\u0003)\u0019G.[3oi~#S-\u001d\u000b\u0005\u0005O\u0011i\u0003E\u0002p\u0005SI1Aa\u000bq\u0005\u0011)f.\u001b;\t\u0013\u0005\u0015F$!AA\u0002\tM\u0011aB2mS\u0016tG\u000f\t\u0015\u0004;\tM\u0002cA8\u00036%\u0019!q\u00079\u0003\u0011Y|G.\u0019;jY\u0016\f\u0001b\u001b<DY&,g\u000e^\u000b\u0003\u0005{\u0001BA!\u0006\u0003@%!!\u0011\tB\f\u0005\tYe+\u0001\u0007lm\u000ec\u0017.\u001a8u?\u0012*\u0017\u000f\u0006\u0003\u0003(\t\u001d\u0003\"CAS?\u0005\u0005\t\u0019\u0001B\u001f\u0003%Ygo\u00117jK:$\b\u0005K\u0002!\u0005g\t!\u0002\\8dW\u000ec\u0017.\u001a8u+\t\u0011\t\u0006\u0005\u0003\u0003\u0016\tM\u0013\u0002\u0002B+\u0005/\u0011A\u0001T8dW\u0006qAn\\2l\u00072LWM\u001c;`I\u0015\fH\u0003\u0002B\u0014\u00057B\u0011\"!*#\u0003\u0003\u0005\rA!\u0015\u0002\u00171|7m[\"mS\u0016tG\u000f\t\u0015\u0004G\tM\u0012a\u00037fCN,7\t\\5f]R,\"A!\u001a\u0011\t\tU!qM\u0005\u0005\u0005S\u00129BA\u0003MK\u0006\u001cX-A\bmK\u0006\u001cXm\u00117jK:$x\fJ3r)\u0011\u00119Ca\u001c\t\u0013\u0005\u0015V%!AA\u0002\t\u0015\u0014\u0001\u00047fCN,7\t\\5f]R\u0004\u0003f\u0001\u0014\u00034\u0005Y1/\u001a:wS\u000e,gj\u001c3f+\t\ty%A\btKJ4\u0018nY3O_\u0012,w\fJ3r)\u0011\u00119C! \t\u0013\u0005\u0015\u0006&!AA\u0002\u0005=\u0013\u0001D:feZL7-\u001a(pI\u0016\u0004\u0003fA\u0015\u00034\u0005AA.Z1tKR#F*\u0001\u0007mK\u0006\u001cX\r\u0016+M?\u0012*\u0017\u000f\u0006\u0003\u0003(\t%\u0005\"CASW\u0005\u0005\t\u0019AA#\u0003%aW-Y:f)Rc\u0005\u0005K\u0002-\u0005g\t1BY;jY\u0012\u001cE.[3oiR\u0011!1C\u0001\rGJ,\u0017\r^3DY&,g\u000e\u001e\u000b\u0003\u0005O\t1b\u00197pg\u0016\u001cE.[3oi\u000611M]3bi\u0016$\u0002\"a\f\u0003\u001e\n}%1\u0015\u0005\b\u0003W\u0001\u0004\u0019AA\u0018\u0011\u001d\u0011\t\u000b\ra\u0001\u0003_\tA!\\8eK\"I!Q\u0015\u0019\u0011\u0002\u0003\u0007\u00111X\u0001\rGJ,\u0017\r^3QCJ,g\u000e^\u0001\u0011GJ,\u0017\r^3%I\u00164\u0017-\u001e7uIM*\"Aa++\t\u0005m\u0016QM\u0001\bO\u0016$H)\u0019;b)\u0011\u0011\tL!0\u0011\u000b=\u0014\u0019La.\n\u0007\tU\u0006OA\u0003BeJ\f\u0017\u0010E\u0002p\u0005sK1Aa/q\u0005\u0011\u0011\u0015\u0010^3\t\u000f\u0005-\"\u00071\u0001\u00020\u000591/\u001a;ECR\fGCBA^\u0005\u0007\u0014)\rC\u0004\u0002,M\u0002\r!a\f\t\u000f\t\u001d7\u00071\u0001\u00032\u0006!A-\u0019;b\u0003-9W\r^\"iS2$'/\u001a8\u0015\t\t5'1\u001b\t\u0007\u0003+\u0011y-a\f\n\t\tE\u0017\u0011\u0006\u0002\u0005\u0019&\u001cH\u000fC\u0004\u0002,Q\u0002\r!a\f\u0002\u0015A\fG\u000f[#ySN$8\u000f\u0006\u0003\u0002<\ne\u0007bBA\u0016k\u0001\u0007\u0011qF\u0001\u000ea\u0006$\bNT8o\u000bbL7\u000f^:\u0015\r\u0005m&q\u001cBq\u0011\u001d\tYC\u000ea\u0001\u0003_A\u0011Ba97!\u0003\u0005\r!a/\u0002\u0011%\u001c\bK]3gSb\fq\u0003]1uQ:{g.\u0012=jgR\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0002\r\u0011,G.\u001a;f)\u0019\u00119Ca;\u0003n\"9\u00111\u0006\u001dA\u0002\u0005=\u0002\"\u0003BxqA\u0005\t\u0019AA^\u00039!W\r\\3uK\u000eC\u0017\u000e\u001c3sK:\f\u0001\u0003Z3mKR,G\u0005Z3gCVdG\u000f\n\u001a\u0002\u00195|g.\u001b;peN#\u0018\r^3\u0015\t\t\u001d\"q\u001f\u0005\b\u0005sT\u0004\u0019\u0001B~\u0003A\u0019XM\u001d<jG\u0016$\u0015n]2pm\u0016\u0014\u0018\u0010E\u0002v\u0005{L1Aa@c\u0005A\u0019VM\u001d<jG\u0016$\u0015n]2pm\u0016\u0014\u00180A\u0006uef<\u0016\u000e\u001e5M_\u000e\\W\u0003BB\u0003\u0007\u001b!baa\u0002\u0004$\r\u001dB\u0003BB\u0005\u00073\u0001Baa\u0003\u0004\u000e1\u0001AaBB\bw\t\u00071\u0011\u0003\u0002\u0002)F!11CAO!\ry7QC\u0005\u0004\u0007/\u0001(a\u0002(pi\"Lgn\u001a\u0005\t\u00077YD\u00111\u0001\u0004\u001e\u0005\ta\rE\u0003p\u0007?\u0019I!C\u0002\u0004\"A\u0014\u0001\u0002\u00102z]\u0006lWM\u0010\u0005\b\u0007KY\u0004\u0019AA\u0018\u0003!awnY6QCRD\u0007bBB\u0015w\u0001\u0007\u0011QI\u0001\bi&lWm\\;u\u000359W\r^*feZ,'\u000fS8tiR!1qFB\u001a!\u0015y'1AB\u0019!\u001dy'\u0011BA\u0018\u0003'Cqa!\u000e=\u0001\u0004\ty#A\u0005oC6,7\u000f]1dK\u0006\u0001r-\u001a;F]\u001eLg.\u001a\"z%\u00164\u0017\n\u001a\u000b\u0007\u0007_\u0019Yd!\u0010\t\u000f\rUR\b1\u0001\u00020!91qH\u001fA\u0002\u0005=\u0012aC3oO&tWMU3g\u0013\u0012\f1cZ3u'\u0016\u0014h/[2f\u001d>$Wm]%oM>$\u0002b!\u0012\u0004R\rM3\u0011\f\t\u0007\u0003+\u00199ea\u0013\n\t\r%\u0013\u0011\u0006\u0002\u0004'\u0016\f\bcA;\u0004N%\u00191q\n2\u0003\u001fM+'O^5dK:{G-Z%oM>Dqa!\u000e?\u0001\u0004\ty\u0003C\u0005\u0004Vy\u0002\n\u00111\u0001\u0004X\u000591/\u001b>f\u001fB$\b#B8\u0003\u0004\u0005M\u0005\"CB.}A\u0005\t\u0019AA^\u0003\u0019\u0019\u0018\u000e\\3oi\u0006ir-\u001a;TKJ4\u0018nY3O_\u0012,7/\u00138g_\u0012\"WMZ1vYR$#'\u0006\u0002\u0004b)\"1qKA3\u0003u9W\r^*feZL7-\u001a(pI\u0016\u001c\u0018J\u001c4pI\u0011,g-Y;mi\u0012\u001a\u0014a\u0004:fO&\u001cH/\u001a:TKJ4\u0018nY3\u0015\u0019\t\u001d2\u0011NB6\u0007[\u001ayg!\u001e\t\u000ba\f\u0005\u0019A=\t\u000f\rU\u0012\t1\u0001\u00020!9!\u0011`!A\u0002\tm\b\"CB9\u0003B\u0005\t\u0019AB:\u0003\u001d1XM]:j_:\u0004Ra\u001cB\u0002\u0003_A\u0011ba\u001eB!\u0003\u0005\r!a/\u0002\u0011\u0015DH/\u001a:oC2\f\u0011D]3hSN$XM]*feZL7-\u001a\u0013eK\u001a\fW\u000f\u001c;%iU\u00111Q\u0010\u0016\u0005\u0007g\n)'A\rsK\u001eL7\u000f^3s'\u0016\u0014h/[2fI\u0011,g-Y;mi\u0012*\u0014!\u00053fe\u0016<\u0017n\u001d;feN+'O^5dK\u0006)\u0002o\\:u\t\u0016\u0014XmZ5ti\u0016\u00148+\u001a:wS\u000e,G\u0003BA^\u0007\u000fCqa!\u000eF\u0001\u0004\ty#A\fde\u0016\fG/Z!oI\u001e+GoU3sm&\u001cWMT8eKRa\u0011qFBG\u0007\u001f\u001b\tj!&\u0004\u0018\")\u0001P\u0012a\u0001s\"91Q\u0007$A\u0002\u0005=\u0002bBBJ\r\u0002\u0007\u0011qF\u0001\tS:\u001cH/\u00198dK\"I1\u0011\u000f$\u0011\u0002\u0003\u000711\u000f\u0005\n\u0007o2\u0005\u0013!a\u0001\u0003w\u000b\u0011e\u0019:fCR,\u0017I\u001c3HKR\u001cVM\u001d<jG\u0016tu\u000eZ3%I\u00164\u0017-\u001e7uIQ\n\u0011e\u0019:fCR,\u0017I\u001c3HKR\u001cVM\u001d<jG\u0016tu\u000eZ3%I\u00164\u0017-\u001e7uIU\nqb\u001d;beR\u001cVm\u0019:fi:{G-\u001a\u000b\u000b\u0005O\u0019\tk!*\u0004*\u000e5\u0006bBBR\u0013\u0002\u0007\u0011qF\u0001\u000bGJ,\u0017\r^3N_\u0012,\u0007bBBT\u0013\u0002\u0007\u0011qF\u0001\tE\u0006\u001cX\rU1uQ\"911V%A\u0002\u0005=\u0012\u0001C5oSR$\u0015\r^1\t\u0013\r=\u0016\n%AA\u0002\u0005m\u0016!D;tKB\u0013x\u000e^3di&|g\u000eK\u0002J\u0007g\u0003Ba!.\u0004H6\u00111q\u0017\u0006\u0005\u0007s\u001bY,A\u0006b]:|G/\u0019;j_:\u001c(\u0002BB_\u0007\u007f\u000baaY8n[>t'\u0002BBa\u0007\u0007\faaZ8pO2,'BABc\u0003\r\u0019w.\\\u0005\u0005\u0007\u0013\u001c9LA\tWSNL'\r\\3G_J$Vm\u001d;j]\u001e\f\u0011d\u001d;beR\u001cVm\u0019:fi:{G-\u001a\u0013eK\u001a\fW\u000f\u001c;%i\u0005yq-\u001a;B]\u0012Len\u0019:f[\u0016tG\u000f\u0006\u0004\u0002\u0014\u000eE71\u001b\u0005\b\u0003WY\u0005\u0019AA\u0018\u0011%\u0019)n\u0013I\u0001\u0002\u0004\t\u0019*A\u0003eK2$\u0018-A\rhKR\fe\u000eZ%oGJ,W.\u001a8uI\u0011,g-Y;mi\u0012\u0012TCABnU\u0011\t\u0019*!\u001a\u0002)\r\u0014X-\u0019;f!\u0016\u00148/[:uK:$hj\u001c3f)9\tye!9\u0004d\u000e\u00158q]Bu\u0007WDQ\u0001_'A\u0002eDqa!\u000eN\u0001\u0004\ty\u0003C\u0004\u0004\u00146\u0003\r!a\f\t\u0013\rET\n%AA\u0002\rM\u0004\"CB<\u001bB\u0005\t\u0019AA^\u0011%\u0019i/\u0014I\u0001\u0002\u0004\u0019y/\u0001\u0006biR\u0014\u0018NY;uKN\u0004\u0002\"!\r\u0004r\u0006=\u0012qF\u0005\u0005\u0007g\fiDA\u0002NCB\fad\u0019:fCR,\u0007+\u001a:tSN$XM\u001c;O_\u0012,G\u0005Z3gCVdG\u000f\n\u001b\u0002=\r\u0014X-\u0019;f!\u0016\u00148/[:uK:$hj\u001c3fI\u0011,g-Y;mi\u0012*\u0014AH2sK\u0006$X\rU3sg&\u001cH/\u001a8u\u001d>$W\r\n3fM\u0006,H\u000e\u001e\u00137+\t\u0019iP\u000b\u0003\u0004p\u0006\u0015$!\u0005#f%\u0016<\u0017n\u001d;fe^\u000bGo\u00195feN)\u0011\u000bb\u0001\u0005\nA!\u00111\u0011C\u0003\u0013\u0011!9!!\"\u0003\r=\u0013'.Z2u!\u0011!Y\u0001\"\u0005\u000f\t\tUAQB\u0005\u0005\t\u001f\u00119\"A\u0003XCR\u001c\u0007.\u0003\u0003\u0005\u0014\u0011U!\u0001\u0003'jgR,g.\u001a:\u000b\t\u0011=!q\u0003\u000b\u0007\t3!Y\u0002\"\b\u0011\u0007\u0005E\u0013\u000bC\u0004\u0004\u0014R\u0003\r!a\f\t\u000f\teH\u000b1\u0001\u0003|\u00061qN\u001c(fqR$BAa\n\u0005$!9AQE+A\u0002\u0011\u001d\u0012!D<bi\u000eD'+Z:q_:\u001cX\r\u0005\u0003\u0005*\u0011=RB\u0001C\u0016\u0015\u0011!iCa\u0006\u0002\u000b]\fGo\u00195\n\t\u0011EB1\u0006\u0002\u000e/\u0006$8\r\u001b*fgB|gn]3\u0002\u000f=tWI\u001d:peR!!q\u0005C\u001c\u0011\u001d!ID\u0016a\u0001\tw\t\u0011\u0002\u001e5s_^\f'\r\\3\u0011\t\u0005UAQH\u0005\u0005\t\u007f\tICA\u0005UQJ|w/\u00192mK\u0006YqN\\\"p[BdW\r^3e\u0003M)Eo\u00193ESN\u001cwN^3ss\u000ec\u0017.\u001a8u!\r\t)!W\n\u00033:$\"\u0001\"\u0012\u0002!1+\u0015iU#`\u001dVcEj\u0018,B\u0019V+\u0015!\u0005'F\u0003N+uLT+M\u0019~3\u0016\tT+FA\u0005\u0001BjT\"L?B\u000bE\u000bS0T+\u001a3\u0015\nW\u000b\u0003\t'z!\u0001\"\u0016\"\u0005\u0011]\u0013!B\u0018m_\u000e\\\u0017!\u0005'P\u0007.{\u0006+\u0011+I?N+fIR%YA\u0001")
public class EtcdDiscoveryClient
implements DiscoveryClient {
    private volatile EtcdDiscoveryClient$ServiceNode$ ServiceNode$module;
    private final KyuubiConf conf;
    private volatile Client client;
    private volatile KV kvClient;
    private volatile Lock lockClient;
    private volatile Lease leaseClient;
    private volatile ServiceNode serviceNode;
    private volatile long leaseTTL;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$(this, message, t);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$(this, message);
    }

    @Override
    public void info(Function0<Object> message, Throwable t) {
        Logging.info$(this, message, t);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$(this, message);
    }

    @Override
    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$(this, isInterpreter);
    }

    public EtcdDiscoveryClient$ServiceNode$ ServiceNode() {
        if (this.ServiceNode$module == null) {
            this.ServiceNode$lzycompute$1();
        }
        return this.ServiceNode$module;
    }

    @Override
    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    @Override
    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    public Client client() {
        return this.client;
    }

    public void client_$eq(Client x$1) {
        this.client = x$1;
    }

    public KV kvClient() {
        return this.kvClient;
    }

    public void kvClient_$eq(KV x$1) {
        this.kvClient = x$1;
    }

    public Lock lockClient() {
        return this.lockClient;
    }

    public void lockClient_$eq(Lock x$1) {
        this.lockClient = x$1;
    }

    public Lease leaseClient() {
        return this.leaseClient;
    }

    public void leaseClient_$eq(Lease x$1) {
        this.leaseClient = x$1;
    }

    public ServiceNode serviceNode() {
        return this.serviceNode;
    }

    public void serviceNode_$eq(ServiceNode x$1) {
        this.serviceNode = x$1;
    }

    public long leaseTTL() {
        return this.leaseTTL;
    }

    public void leaseTTL_$eq(long x$1) {
        this.leaseTTL = x$1;
    }

    private Client buildClient() {
        String[] endpoints = this.conf.get(HighAvailabilityConf$.MODULE$.HA_ADDRESSES()).split(",");
        boolean sslEnabled = BoxesRunTime.unboxToBoolean((Object)this.conf.get(HighAvailabilityConf$.MODULE$.HA_ETCD_SSL_ENABLED()));
        if (!sslEnabled) {
            return Client.builder().endpoints(endpoints).build();
        }
        String caPath = (String)this.conf.getOption(HighAvailabilityConf$.MODULE$.HA_ETCD_SSL_CA_PATH().key()).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(15).append(HighAvailabilityConf$.MODULE$.HA_ETCD_SSL_CA_PATH().key()).append(" is not defined").toString());
        });
        String crtPath = (String)this.conf.getOption(HighAvailabilityConf$.MODULE$.HA_ETCD_SSL_CLIENT_CRT_PATH().key()).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(15).append(HighAvailabilityConf$.MODULE$.HA_ETCD_SSL_CLIENT_CRT_PATH().key()).append(" is not defined").toString());
        });
        String keyPath = (String)this.conf.getOption(HighAvailabilityConf$.MODULE$.HA_ETCD_SSL_CLIENT_KEY_PATH().key()).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(15).append(HighAvailabilityConf$.MODULE$.HA_ETCD_SSL_CLIENT_KEY_PATH().key()).append(" is not defined").toString());
        });
        SslContext context = GrpcSslContexts.forClient().trustManager(new File(caPath)).keyManager(new File(crtPath), new File(keyPath)).build();
        return Client.builder().endpoints(endpoints).sslContext(context).build();
    }

    @Override
    public void createClient() {
        this.client_$eq(this.buildClient());
        this.kvClient_$eq(this.client().getKVClient());
        this.lockClient_$eq(this.client().getLockClient());
        this.leaseClient_$eq(this.client().getLeaseClient());
        this.leaseTTL_$eq(BoxesRunTime.unboxToLong((Object)this.conf.get(HighAvailabilityConf$.MODULE$.HA_ETCD_LEASE_TIMEOUT())) / 1000L);
    }

    @Override
    public void closeClient() {
        if (this.client() != null) {
            this.client().close();
            return;
        }
    }

    @Override
    public String create(String path, String mode, boolean createParent) {
        block3: {
            String string = mode;
            switch (string == null ? 0 : string.hashCode()) {
                case 997554839: {
                    if (!"PERSISTENT".equals(string)) break;
                    this.kvClient().put(ByteSequence.from(path.getBytes()), ByteSequence.from(path.getBytes())).get();
                    break block3;
                }
            }
            throw new KyuubiException(new StringBuilder(36).append("Create mode ").append(string).append(" is not support in etcd!").toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
        }
        return path;
    }

    @Override
    public boolean create$default$3() {
        return true;
    }

    @Override
    public byte[] getData(String path) {
        GetResponse response = this.kvClient().get(ByteSequence.from(path.getBytes())).get();
        if (response.getKvs().isEmpty()) {
            throw new KyuubiException(new StringBuilder(42).append("Key[").append(path).append("] not exists in ETCD, please check it.").toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
        }
        return response.getKvs().get(0).getValue().getBytes();
    }

    @Override
    public boolean setData(String path, byte[] data) {
        PutResponse response = this.kvClient().put(ByteSequence.from(path.getBytes()), ByteSequence.from(data)).get();
        return response != null;
    }

    @Override
    public List<String> getChildren(String path) {
        java.util.List<KeyValue> kvs = this.kvClient().get(ByteSequence.from(path.getBytes()), GetOption.newBuilder().isPrefix(true).build()).get().getKvs();
        if (kvs.isEmpty()) {
            return scala.package$.MODULE$.List().empty();
        }
        return ((IterableOnceOps)((IterableOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(kvs).asScala()).map((Function1 & Serializable)kv -> StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(kv.getKey().toString(StandardCharsets.UTF_8)), path)), "/"))).filter((Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)EtcdDiscoveryClient.$anonfun$getChildren$2(key)))).toList();
    }

    @Override
    public boolean pathExists(String path) {
        return !this.pathNonExists(path, this.pathNonExists$default$2());
    }

    @Override
    public boolean pathNonExists(String path, boolean isPrefix) {
        return this.kvClient().get(ByteSequence.from(path.getBytes()), GetOption.newBuilder().isPrefix(isPrefix).build()).get().getKvs().isEmpty();
    }

    @Override
    public boolean pathNonExists$default$2() {
        return true;
    }

    @Override
    public void delete(String path, boolean deleteChildren) {
        this.kvClient().delete(ByteSequence.from(path.getBytes()), DeleteOption.newBuilder().isPrefix(deleteChildren).build()).get();
    }

    @Override
    public boolean delete$default$2() {
        return false;
    }

    @Override
    public void monitorState(ServiceDiscovery serviceDiscovery) {
    }

    @Override
    public <T> T tryWithLock(String lockPath, long timeout, Function0<T> f) {
        Object object;
        long leaseTime = timeout / 1000L + 3L;
        long leaseId = this.leaseClient().grant(leaseTime).get().getID();
        try {
            try {
                this.lockClient().lock(ByteSequence.from(lockPath.getBytes()), leaseId).get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
                throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(111).append("Timeout to lock on path [").append(lockPath).append("] after ").append(timeout).append(" ms. There would be some problem that other session may ").append("create engine timeout.").toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
            }
            catch (Exception e) {
                throw new KyuubiException(new StringBuilder(22).append("Lock failed on path [").append(lockPath).append("]").toString(), e);
            }
            object = f.apply();
        }
        catch (Throwable throwable) {
            try {
                this.lockClient().unlock(ByteSequence.from(lockPath.getBytes())).get();
                this.leaseClient().revoke(leaseId).get();
            }
            catch (Exception e) {
                throw new KyuubiException(e.getMessage(), e.getCause());
            }
            throw throwable;
        }
        Object object2 = object;
        try {
            this.lockClient().unlock(ByteSequence.from(lockPath.getBytes())).get();
            this.leaseClient().revoke(leaseId).get();
        }
        catch (Exception e) {
            throw new KyuubiException(e.getMessage(), e.getCause());
        }
        return (T)object2;
    }

    @Override
    public Option<Tuple2<String, Object>> getServerHost(String namespace) {
        SeqOps seqOps;
        Seq<ServiceNodeInfo> seq = this.getServiceNodesInfo(namespace, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)1)), true);
        if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = scala.package$.MODULE$.Seq().unapplySeq(seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
            ServiceNodeInfo sn = (ServiceNodeInfo)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            return new Some((Object)new Tuple2((Object)sn.host(), (Object)BoxesRunTime.boxToInteger((int)sn.port())));
        }
        return None$.MODULE$;
    }

    @Override
    public Option<Tuple2<String, Object>> getEngineByRefId(String namespace, String engineRefId) {
        String x$1 = namespace;
        boolean x$2 = true;
        Option<Object> x$3 = this.getServiceNodesInfo$default$2();
        return this.getServiceNodesInfo(x$1, x$3, true).find((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)EtcdDiscoveryClient.$anonfun$getEngineByRefId$1(engineRefId, x$7))).map((Function1 & Serializable)data -> new Tuple2((Object)data.host(), (Object)BoxesRunTime.boxToInteger((int)data.port())));
    }

    @Override
    public Seq<ServiceNodeInfo> getServiceNodesInfo(String namespace, Option<Object> sizeOpt, boolean silent) {
        Nil$ nil$;
        try {
            List<String> hosts = this.getChildren(DiscoveryPaths$.MODULE$.makePath(null, namespace, (Seq<String>)Nil$.MODULE$));
            int size = BoxesRunTime.unboxToInt((Object)sizeOpt.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> hosts.size()));
            nil$ = hosts.takeRight(size).map((Function1 & Serializable)p -> {
                String path = DiscoveryPaths$.MODULE$.makePath(namespace, (String)p, (Seq<String>)Nil$.MODULE$);
                String instance = new String(this.getData(path), StandardCharsets.UTF_8);
                Tuple2<String, Object> tuple2 = DiscoveryClient$.MODULE$.parseInstanceHostPort(instance);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                String host = (String)tuple2._1();
                int port = tuple2._2$mcI$sp();
                Tuple2 tuple22 = new Tuple2((Object)host, (Object)BoxesRunTime.boxToInteger((int)port));
                String host2 = (String)tuple22._1();
                int port2 = tuple22._2$mcI$sp();
                Map attributes = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])p.split(";")), (Function1 & Serializable)x$10 -> x$10.split("=", 2), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))), (Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)EtcdDiscoveryClient.$anonfun$getServiceNodesInfo$4(x$11)))), (Function1 & Serializable)kv -> new Tuple2(ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])kv)), ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])kv))), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                Option version = attributes.get((Object)"version");
                Option engineRefId = attributes.get((Object)"refId");
                String engineIdStr = (String)attributes.get((Object)"kyuubi.engine.id").map((Function1 & Serializable)x$12 -> new StringBuilder(11).append(" engine id:").append((String)x$12).toString()).getOrElse((Function0 & Serializable)() -> "");
                this.info((Function0<Object>)(Function0 & Serializable)() -> new StringBuilder(41).append("Get service instance:").append(instance).append(engineIdStr).append(" and version:").append(version.getOrElse((Function0 & Serializable)() -> "")).append(" ").append("under ").append(namespace).toString());
                return new ServiceNodeInfo(namespace, (String)p, host2, port2, (Option<String>)version, (Option<String>)engineRefId, (Map<String, String>)attributes);
            });
        }
        catch (Exception exception) {
            if (silent) {
                nil$ = Nil$.MODULE$;
            } else {
                this.error((Function0<Object>)(Function0 & Serializable)() -> "Failed to get service node info", exception);
                nil$ = Nil$.MODULE$;
            }
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        return nil$;
    }

    @Override
    public Option<Object> getServiceNodesInfo$default$2() {
        return None$.MODULE$;
    }

    @Override
    public boolean getServiceNodesInfo$default$3() {
        return false;
    }

    @Override
    public void registerService(KyuubiConf conf, String namespace, ServiceDiscovery serviceDiscovery, Option<String> version, boolean external) {
        String instance = serviceDiscovery.fe().connectionUrl();
        DeRegisterWatcher watcher = new DeRegisterWatcher(this, instance, serviceDiscovery);
        this.serviceNode_$eq(this.createPersistentNode(conf, namespace, instance, version, external, serviceDiscovery.fe().attributes()));
        this.client().getWatchClient().watch(ByteSequence.from(this.serviceNode().path().getBytes()), watcher);
        if (this.pathNonExists(this.serviceNode().path(), this.pathNonExists$default$2())) {
            throw new KyuubiException(new StringBuilder(61).append("Unable to create keyValue for this Kyuubi ").append("instance[").append(instance).append("] on ETCD.").toString(), KyuubiException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    @Override
    public Option<String> registerService$default$4() {
        return None$.MODULE$;
    }

    @Override
    public boolean registerService$default$5() {
        return false;
    }

    @Override
    public void deregisterService() {
        if (this.serviceNode() != null) {
            if (this.serviceNode().lease() != EtcdDiscoveryClient$.MODULE$.org$apache$kyuubi$ha$client$etcd$EtcdDiscoveryClient$$LEASE_NULL_VALUE()) {
                this.client().getLeaseClient().revoke(this.serviceNode().lease());
                this.delete(this.serviceNode().path(), this.delete$default$2());
            }
            this.serviceNode_$eq(null);
            return;
        }
    }

    @Override
    public boolean postDeregisterService(String namespace) {
        if (namespace != null) {
            this.delete(DiscoveryPaths$.MODULE$.makePath(null, namespace, (Seq<String>)Nil$.MODULE$), true);
            return true;
        }
        return false;
    }

    @Override
    public String createAndGetServiceNode(KyuubiConf conf, String namespace, String instance, Option<String> version, boolean external) {
        return this.createPersistentNode(conf, namespace, instance, version, external, this.createPersistentNode$default$6()).path();
    }

    @Override
    public Option<String> createAndGetServiceNode$default$4() {
        return None$.MODULE$;
    }

    @Override
    public boolean createAndGetServiceNode$default$5() {
        return false;
    }

    @Override
    @VisibleForTesting
    public void startSecretNode(String createMode, String basePath, String initData, boolean useProtection) {
        this.client().getKVClient().put(ByteSequence.from(basePath.getBytes()), ByteSequence.from(initData.getBytes())).get();
    }

    @Override
    public boolean startSecretNode$default$4() {
        return false;
    }

    @Override
    public int getAndIncrement(String path, int delta) {
        String lockPath = new StringBuilder(13).append(path).append("_tmp_for_lock").toString();
        return BoxesRunTime.unboxToInt(this.tryWithLock(lockPath, 60000L, (Function0)(JFunction0.mcI.sp & Serializable)() -> {
            Object object;
            if (this.pathNonExists(path, false)) {
                this.create(path, "PERSISTENT", this.create$default$3());
                object = BoxesRunTime.boxToBoolean((boolean)this.setData(path, String.valueOf(0).getBytes()));
            } else {
                object = BoxedUnit.UNIT;
            }
            int s = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(new String(this.getData(path))));
            this.setData(path, String.valueOf(s + delta).getBytes());
            return s;
        }));
    }

    @Override
    public int getAndIncrement$default$2() {
        return 1;
    }

    private ServiceNode createPersistentNode(KyuubiConf conf, String namespace, String instance, Option<String> version, boolean external, Map<String, String> attributes) {
        String ns = DiscoveryPaths$.MODULE$.makePath(null, namespace, (Seq<String>)Nil$.MODULE$);
        this.create(ns, "PERSISTENT", this.create$default$3());
        String session = (String)((Option)conf.get(HighAvailabilityConf$.MODULE$.HA_ENGINE_REF_ID())).map((Function1 & Serializable)refId -> new StringBuilder(7).append("refId=").append((String)refId).append(";").toString()).getOrElse((Function0 & Serializable)() -> "");
        String extraInfo = ((IterableOnceOps)attributes.map((Function1 & Serializable)kv -> new StringBuilder(1).append((String)kv._1()).append("=").append(kv._2()).toString())).mkString(";", ";", "");
        String pathPrefix = DiscoveryPaths$.MODULE$.makePath(namespace, new StringBuilder(29).append("serverUri=").append(instance).append(";version=").append(version.getOrElse((Function0 & Serializable)() -> package$.MODULE$.KYUUBI_VERSION())).append(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(extraInfo), ";")).append(";").append(session).append("sequence=").toString(), (Seq<String>)Nil$.MODULE$);
        String znode = instance;
        LongRef leaseId = LongRef.create((long)EtcdDiscoveryClient$.MODULE$.org$apache$kyuubi$ha$client$etcd$EtcdDiscoveryClient$$LEASE_NULL_VALUE());
        ObjectRef realPath = ObjectRef.create(null);
        long timeout = BoxesRunTime.unboxToLong((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_INIT_TIMEOUT()));
        this.tryWithLock(new StringBuilder(5).append(ns).append("/lock").toString(), timeout, (Function0 & Serializable)() -> {
            List instances = this.getChildren(pathPrefix).map((Function1 & Serializable)x$13 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(x$13), pathPrefix)))));
            long sequence = instances.isEmpty() ? 0L : BoxesRunTime.unboxToLong((Object)instances.max((Ordering)Ordering.Long$.MODULE$)) + 1L;
            realPath$1.elem = new StringBuilder(0).append(pathPrefix).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%010d"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)sequence)}))).toString();
            if (external) {
                return this.client().getKVClient().put(ByteSequence.from(((String)realPath$1.elem).getBytes()), ByteSequence.from(znode.getBytes())).get();
            }
            leaseId$1.elem = this.client().getLeaseClient().grant(this.leaseTTL()).get().getID();
            this.client().getLeaseClient().keepAlive(leaseId$1.elem, new StreamObserver<LeaseKeepAliveResponse>(null){

                public void onNext(LeaseKeepAliveResponse v) {
                }

                public void onError(Throwable throwable) {
                }

                public void onCompleted() {
                }
            });
            return this.client().getKVClient().put(ByteSequence.from(((String)realPath$1.elem).getBytes()), ByteSequence.from(znode.getBytes()), PutOption.newBuilder().withLeaseId(leaseId$1.elem).build()).get();
        });
        return new ServiceNode(this, (String)realPath.elem, leaseId.elem);
    }

    private Option<String> createPersistentNode$default$4() {
        return None$.MODULE$;
    }

    private boolean createPersistentNode$default$5() {
        return false;
    }

    private Map<String, String> createPersistentNode$default$6() {
        return Predef$.MODULE$.Map().empty();
    }

    private final void ServiceNode$lzycompute$1() {
        EtcdDiscoveryClient etcdDiscoveryClient = this;
        synchronized (etcdDiscoveryClient) {
            if (this.ServiceNode$module == null) {
                this.ServiceNode$module = new EtcdDiscoveryClient$ServiceNode$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$getChildren$2(String key) {
        return StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(key)) && !key.startsWith("lock");
    }

    public static final /* synthetic */ boolean $anonfun$getEngineByRefId$1(String engineRefId$1, ServiceNodeInfo x$7) {
        return x$7.engineRefId().exists((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.equals(engineRefId$1)));
    }

    public static final /* synthetic */ boolean $anonfun$getServiceNodesInfo$4(String[] x$11) {
        return x$11.length == 2;
    }

    public EtcdDiscoveryClient(KyuubiConf conf) {
        this.conf = conf;
        Logging.$init$(this);
    }

    public class DeRegisterWatcher
    implements Watch.Listener {
        private final String instance;
        private final ServiceDiscovery serviceDiscovery;
        public final /* synthetic */ EtcdDiscoveryClient $outer;

        @Override
        public void onNext(WatchResponse watchResponse) {
            ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(watchResponse.getEvents()).asScala()).filter((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)DeRegisterWatcher.$anonfun$onNext$1(x$14)))).foreach((Function1 & Serializable)x$15 -> {
                DeRegisterWatcher.$anonfun$onNext$2(this, x$15);
                return BoxedUnit.UNIT;
            });
        }

        @Override
        public void onError(Throwable throwable) {
            throw new KyuubiException(throwable.getMessage(), throwable.getCause());
        }

        @Override
        public void onCompleted() {
        }

        public /* synthetic */ EtcdDiscoveryClient org$apache$kyuubi$ha$client$etcd$EtcdDiscoveryClient$DeRegisterWatcher$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ boolean $anonfun$onNext$1(WatchEvent x$14) {
            WatchEvent.EventType eventType = x$14.getEventType();
            WatchEvent.EventType eventType2 = WatchEvent.EventType.DELETE;
            return !(eventType != null ? !((Object)((Object)eventType)).equals((Object)eventType2) : eventType2 != null);
        }

        public static final /* synthetic */ void $anonfun$onNext$2(DeRegisterWatcher $this, WatchEvent x$15) {
            $this.org$apache$kyuubi$ha$client$etcd$EtcdDiscoveryClient$DeRegisterWatcher$$$outer().warn((Function0<Object>)(Function0 & Serializable)() -> new StringBuilder(123).append("This Kyuubi instance ").append($this.instance).append(" is now de-registered from").append(" ETCD. The server will be shut down after the last client session completes.").toString());
            ThreadUtils$.MODULE$.runInNewThread("deregister-watcher-thread", false, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> $this.serviceDiscovery.stopGracefully($this.serviceDiscovery.stopGracefully$default$1()));
        }

        public DeRegisterWatcher(EtcdDiscoveryClient $outer, String instance, ServiceDiscovery serviceDiscovery) {
            this.instance = instance;
            this.serviceDiscovery = serviceDiscovery;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    public class ServiceNode
    implements Product,
    Serializable {
        private final String path;
        private final long lease;
        public final /* synthetic */ EtcdDiscoveryClient $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String path() {
            return this.path;
        }

        public long lease() {
            return this.lease;
        }

        public ServiceNode copy(String path, long lease) {
            return new ServiceNode(this.org$apache$kyuubi$ha$client$etcd$EtcdDiscoveryClient$ServiceNode$$$outer(), path, lease);
        }

        public String copy$default$1() {
            return this.path();
        }

        public long copy$default$2() {
            return this.lease();
        }

        public String productPrefix() {
            return "ServiceNode";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.path();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.lease());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ServiceNode;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "path";
                }
                case 1: {
                    return "lease";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)-260690377);
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.path()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.lease()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ServiceNode)) return false;
            if (((ServiceNode)object).org$apache$kyuubi$ha$client$etcd$EtcdDiscoveryClient$ServiceNode$$$outer() != this.org$apache$kyuubi$ha$client$etcd$EtcdDiscoveryClient$ServiceNode$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ServiceNode serviceNode = (ServiceNode)x$1;
            if (this.lease() != serviceNode.lease()) return false;
            String string = this.path();
            String string2 = serviceNode.path();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!serviceNode.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ EtcdDiscoveryClient org$apache$kyuubi$ha$client$etcd$EtcdDiscoveryClient$ServiceNode$$$outer() {
            return this.$outer;
        }

        public ServiceNode(EtcdDiscoveryClient $outer, String path, long lease) {
            this.path = path;
            this.lease = lease;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

