/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.model.jackson;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerBuilder;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import io.fabric8.kubernetes.model.jackson.BeanPropertyWriterDelegate;
import io.fabric8.kubernetes.model.jackson.SettableBeanPropertyDelegate;
import java.lang.reflect.Member;
import java.util.List;
import java.util.stream.Collectors;

public class UnmatchedFieldTypeModule
extends SimpleModule {
    private boolean logWarnings;
    private boolean restrictToTemplates;
    private static final ThreadLocal<Boolean> IN_TEMPLATE = ThreadLocal.withInitial(() -> false);

    public UnmatchedFieldTypeModule() {
        this(true, true);
    }

    public UnmatchedFieldTypeModule(boolean logWarnings, boolean restrictToTemplates) {
        this.logWarnings = logWarnings;
        this.restrictToTemplates = restrictToTemplates;
        this.setDeserializerModifier(new BeanDeserializerModifier(){

            public BeanDeserializerBuilder updateBuilder(DeserializationConfig config, BeanDescription beanDesc, BeanDeserializerBuilder builder) {
                builder.getProperties().forEachRemaining(p -> builder.addOrReplaceProperty((SettableBeanProperty)new SettableBeanPropertyDelegate((SettableBeanProperty)p, builder.getAnySetter(), UnmatchedFieldTypeModule.this::useAnySetter){}, true));
                return builder;
            }
        });
        this.setSerializerModifier(new BeanSerializerModifier(){

            public BeanSerializerBuilder updateBuilder(SerializationConfig config, BeanDescription beanDesc, BeanSerializerBuilder builder) {
                AnnotatedMember anyGetter = beanDesc.findAnyGetter();
                Member anyGetterMember = anyGetter != null ? anyGetter.getMember() : null;
                List customWriters = builder.getProperties().stream().map(writer -> {
                    if (UnmatchedFieldTypeModule.isAnyGetterWriter(writer, anyGetterMember)) {
                        return writer;
                    }
                    return new BeanPropertyWriterDelegate((BeanPropertyWriter)writer, anyGetter, UnmatchedFieldTypeModule.this::isLogWarnings);
                }).collect(Collectors.toList());
                builder.setProperties(customWriters);
                return builder;
            }
        });
    }

    boolean isLogWarnings() {
        return this.logWarnings;
    }

    public void setLogWarnings(boolean logWarnings) {
        this.logWarnings = logWarnings;
    }

    boolean isRestrictToTemplates() {
        return this.restrictToTemplates;
    }

    boolean useAnySetter() {
        return !this.restrictToTemplates || UnmatchedFieldTypeModule.isInTemplate();
    }

    public void setRestrictToTemplates(boolean restrictToTemplates) {
        this.restrictToTemplates = restrictToTemplates;
    }

    public static boolean isInTemplate() {
        return Boolean.TRUE.equals(IN_TEMPLATE.get());
    }

    public static void setInTemplate() {
        IN_TEMPLATE.set(true);
    }

    public static void removeInTemplate() {
        IN_TEMPLATE.remove();
    }

    private static boolean isAnyGetterWriter(BeanPropertyWriter writer, Member anyGetterMember) {
        if (writer == null || anyGetterMember == null) {
            return false;
        }
        AnnotatedMember annotated = writer.getMember();
        Member member = annotated != null ? annotated.getMember() : null;
        return member != null && member.equals(anyGetterMember);
    }
}

