/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.nimbusds.jose.crypto.impl;

import java.util.Collection;
import org.apache.hadoop.shaded.com.nimbusds.jose.EncryptionMethod;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWEAlgorithm;
import org.apache.hadoop.shaded.com.nimbusds.jose.JWSAlgorithm;
import org.apache.hadoop.shaded.com.nimbusds.jose.jwk.Curve;

public class AlgorithmSupportMessage {
    private static String itemize(Collection collection) {
        StringBuilder sb = new StringBuilder();
        Object[] items = collection.toArray();
        for (int i = 0; i < items.length; ++i) {
            if (i != 0) {
                if (i < items.length - 1) {
                    sb.append(", ");
                } else if (i == items.length - 1) {
                    sb.append(" or ");
                }
            }
            sb.append(items[i].toString());
        }
        return sb.toString();
    }

    public static String unsupportedJWSAlgorithm(JWSAlgorithm unsupported, Collection<JWSAlgorithm> supported) {
        return "Unsupported JWS algorithm " + unsupported + ", must be " + AlgorithmSupportMessage.itemize(supported);
    }

    public static String unsupportedJWEAlgorithm(JWEAlgorithm unsupported, Collection<JWEAlgorithm> supported) {
        return "Unsupported JWE algorithm " + unsupported + ", must be " + AlgorithmSupportMessage.itemize(supported);
    }

    public static String unsupportedEncryptionMethod(EncryptionMethod unsupported, Collection<EncryptionMethod> supported) {
        return "Unsupported JWE encryption method " + unsupported + ", must be " + AlgorithmSupportMessage.itemize(supported);
    }

    public static String unsupportedEllipticCurve(Curve unsupported, Collection<Curve> supported) {
        return "Unsupported elliptic curve " + unsupported + ", must be " + AlgorithmSupportMessage.itemize(supported);
    }

    private AlgorithmSupportMessage() {
    }
}

