/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.grpc.internal;

import javax.annotation.Nullable;
import org.apache.kyuubi.shade.com.google.common.collect.ImmutableList;
import org.apache.kyuubi.shade.com.google.common.collect.Lists;
import org.apache.kyuubi.shade.io.grpc.LongCounterMetricInstrument;
import org.apache.kyuubi.shade.io.grpc.LongUpDownCounterMetricInstrument;
import org.apache.kyuubi.shade.io.grpc.MetricInstrumentRegistry;
import org.apache.kyuubi.shade.io.grpc.MetricRecorder;

final class SubchannelMetrics {
    private static final LongCounterMetricInstrument disconnections;
    private static final LongCounterMetricInstrument connectionAttemptsSucceeded;
    private static final LongCounterMetricInstrument connectionAttemptsFailed;
    private static final LongUpDownCounterMetricInstrument openConnections;
    private final MetricRecorder metricRecorder;

    public SubchannelMetrics(MetricRecorder metricRecorder) {
        this.metricRecorder = metricRecorder;
    }

    public void recordConnectionAttemptSucceeded(String target, String backendService, String locality, String securityLevel) {
        this.metricRecorder.addLongCounter(connectionAttemptsSucceeded, 1L, ImmutableList.of(target), ImmutableList.of(backendService, locality));
        this.metricRecorder.addLongUpDownCounter(openConnections, 1L, ImmutableList.of(target), ImmutableList.of(securityLevel, backendService, locality));
    }

    public void recordConnectionAttemptFailed(String target, String backendService, String locality) {
        this.metricRecorder.addLongCounter(connectionAttemptsFailed, 1L, ImmutableList.of(target), ImmutableList.of(backendService, locality));
    }

    public void recordDisconnection(String target, String backendService, String locality, String disconnectError, String securityLevel) {
        this.metricRecorder.addLongCounter(disconnections, 1L, ImmutableList.of(target), ImmutableList.of(backendService, locality, disconnectError));
        this.metricRecorder.addLongUpDownCounter(openConnections, -1L, ImmutableList.of(target), ImmutableList.of(securityLevel, backendService, locality));
    }

    static {
        MetricInstrumentRegistry metricInstrumentRegistry = MetricInstrumentRegistry.getDefaultRegistry();
        disconnections = metricInstrumentRegistry.registerLongCounter("grpc.subchannel.disconnections", "EXPERIMENTAL. Number of times the selected subchannel becomes disconnected", "{disconnection}", Lists.newArrayList("grpc.target"), Lists.newArrayList("grpc.lb.backend_service", "grpc.lb.locality", "grpc.disconnect_error"), false);
        connectionAttemptsSucceeded = metricInstrumentRegistry.registerLongCounter("grpc.subchannel.connection_attempts_succeeded", "EXPERIMENTAL. Number of successful connection attempts", "{attempt}", Lists.newArrayList("grpc.target"), Lists.newArrayList("grpc.lb.backend_service", "grpc.lb.locality"), false);
        connectionAttemptsFailed = metricInstrumentRegistry.registerLongCounter("grpc.subchannel.connection_attempts_failed", "EXPERIMENTAL. Number of failed connection attempts", "{attempt}", Lists.newArrayList("grpc.target"), Lists.newArrayList("grpc.lb.backend_service", "grpc.lb.locality"), false);
        openConnections = metricInstrumentRegistry.registerLongUpDownCounter("grpc.subchannel.open_connections", "EXPERIMENTAL. Number of open connections.", "{connection}", Lists.newArrayList("grpc.target"), Lists.newArrayList("grpc.security_level", "grpc.lb.backend_service", "grpc.lb.locality"), false);
    }

    public static enum DisconnectError {
        GOAWAY("goaway"),
        SUBCHANNEL_SHUTDOWN("subchannel shutdown"),
        CONNECTION_RESET("connection reset"),
        CONNECTION_TIMED_OUT("connection timed out"),
        CONNECTION_ABORTED("connection aborted"),
        SOCKET_ERROR("socket error"),
        UNKNOWN("unknown");

        private final String errorTag;

        private DisconnectError(String errorTag) {
            this.errorTag = errorTag;
        }

        public String getErrorString(@Nullable String goawayErrorCode) {
            if (this == GOAWAY) {
                if (goawayErrorCode == null || goawayErrorCode.isEmpty()) {
                    return this.errorTag;
                }
                return this.errorTag + " " + goawayErrorCode;
            }
            return this.errorTag;
        }
    }
}

