/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.AbstractMapWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class SortedMapWritable<K extends WritableComparable<? super K>>
extends AbstractMapWritable
implements SortedMap<K, Writable> {
    private SortedMap<K, Writable> instance = new TreeMap<K, Writable>();

    public SortedMapWritable() {
    }

    public SortedMapWritable(SortedMapWritable<K> other) {
        this();
        this.copy(other);
    }

    @Override
    public Comparator<? super K> comparator() {
        return null;
    }

    @Override
    public K firstKey() {
        return (K)((WritableComparable)this.instance.firstKey());
    }

    @Override
    public SortedMap<K, Writable> headMap(K toKey) {
        return this.instance.headMap(toKey);
    }

    @Override
    public K lastKey() {
        return (K)((WritableComparable)this.instance.lastKey());
    }

    @Override
    public SortedMap<K, Writable> subMap(K fromKey, K toKey) {
        return this.instance.subMap(fromKey, toKey);
    }

    @Override
    public SortedMap<K, Writable> tailMap(K fromKey) {
        return this.instance.tailMap(fromKey);
    }

    @Override
    public void clear() {
        this.instance.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.instance.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.instance.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, Writable>> entrySet() {
        return this.instance.entrySet();
    }

    @Override
    public Writable get(Object key) {
        return (Writable)this.instance.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.instance.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.instance.keySet();
    }

    @Override
    public Writable put(K key, Writable value) {
        this.addToMap(key.getClass());
        this.addToMap(value.getClass());
        return this.instance.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends Writable> t) {
        for (Map.Entry<K, Writable> e : t.entrySet()) {
            this.put((K)((WritableComparable)e.getKey()), e.getValue());
        }
    }

    @Override
    public Writable remove(Object key) {
        return (Writable)this.instance.remove(key);
    }

    @Override
    public int size() {
        return this.instance.size();
    }

    @Override
    public Collection<Writable> values() {
        return this.instance.values();
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        int entries = in.readInt();
        for (int i = 0; i < entries; ++i) {
            WritableComparable key = (WritableComparable)ReflectionUtils.newInstance(this.getClass(in.readByte()), this.getConf());
            key.readFields(in);
            Writable value = (Writable)ReflectionUtils.newInstance(this.getClass(in.readByte()), this.getConf());
            value.readFields(in);
            this.instance.put(key, value);
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.instance.size());
        for (Map.Entry<K, Writable> e : this.instance.entrySet()) {
            out.writeByte(this.getId(((WritableComparable)e.getKey()).getClass()));
            ((WritableComparable)e.getKey()).write(out);
            out.writeByte(this.getId(e.getValue().getClass()));
            e.getValue().write(out);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SortedMapWritable) {
            Map map = (Map)obj;
            if (this.size() != map.size()) {
                return false;
            }
            return this.entrySet().equals(map.entrySet());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.instance.hashCode();
    }
}

