/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.jee.util;

import java.security.Principal;
import java.util.Collection;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.pac4j.core.profile.ProfileHelper;
import org.pac4j.core.profile.UserProfile;

public class Pac4JHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private Collection<UserProfile> profiles;

    public Pac4JHttpServletRequestWrapper(HttpServletRequest request, Collection<UserProfile> profiles) {
        super(request);
        this.profiles = profiles;
    }

    public String getRemoteUser() {
        return this.getPrincipal().map(p -> p.getName()).orElse(null);
    }

    private Optional<UserProfile> getProfile() {
        return ProfileHelper.flatIntoOneProfile(this.profiles);
    }

    private Optional<Principal> getPrincipal() {
        return this.getProfile().map(UserProfile::asPrincipal);
    }

    public Principal getUserPrincipal() {
        return this.getPrincipal().orElse(null);
    }

    public boolean isUserInRole(String role) {
        return this.profiles.stream().anyMatch(p -> p.getRoles().contains(role));
    }
}

