/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.dispatch;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.knox.gateway.dispatch.NiFiRequestUtil;
import org.apache.knox.gateway.dispatch.NiFiResponseUtil;
import org.apache.knox.gateway.ha.dispatch.DefaultHaDispatch;

public class NiFiHaDispatch
extends DefaultHaDispatch {
    public NiFiHaDispatch() {
        this.setServiceRole("NIFI");
    }

    protected void executeRequest(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse) throws IOException {
        HttpResponse inboundResponse = null;
        try {
            outboundRequest = NiFiRequestUtil.modifyOutboundRequest(outboundRequest, inboundRequest);
            inboundResponse = this.executeOutboundRequest(outboundRequest);
            this.writeOutboundResponse(outboundRequest, inboundRequest, outboundResponse, inboundResponse);
        }
        catch (IOException e) {
            LOG.errorConnectingToServer(outboundRequest.getURI().toString(), (Exception)e);
            this.failoverRequest(outboundRequest, inboundRequest, outboundResponse, inboundResponse, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeOutboundResponse(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse, HttpResponse inboundResponse) throws IOException {
        outboundResponse.setStatus(inboundResponse.getStatusLine().getStatusCode());
        Header[] headers = inboundResponse.getAllHeaders();
        Set excludeHeaders = this.getOutboundResponseExcludeHeaders();
        boolean hasExcludeHeaders = false;
        if (excludeHeaders != null && !excludeHeaders.isEmpty()) {
            hasExcludeHeaders = true;
        }
        for (Header header : headers) {
            String name = header.getName();
            if (hasExcludeHeaders && excludeHeaders.contains(name.toUpperCase(Locale.ROOT))) continue;
            String value = header.getValue();
            outboundResponse.addHeader(name, value);
        }
        HttpEntity entity = inboundResponse.getEntity();
        if (entity != null) {
            outboundResponse.setContentType(this.getInboundResponseContentType(entity));
            InputStream stream = entity.getContent();
            try {
                NiFiResponseUtil.modifyOutboundResponse(inboundRequest, outboundResponse, inboundResponse);
                this.writeResponse(inboundRequest, outboundResponse, stream);
            }
            finally {
                this.closeInboundResponse(inboundResponse, stream);
            }
        }
    }
}

