/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.result;

import aQute.bnd.exceptions.ConsumerWithException;
import aQute.bnd.exceptions.FunctionWithException;
import aQute.bnd.exceptions.SupplierWithException;
import aQute.bnd.result.Err;
import aQute.bnd.result.Ok;
import java.util.Arrays;
import java.util.Optional;

public interface Result<V> {
    public static <V> Result<V> of(V value, CharSequence error) {
        return value != null ? Result.ok(value) : Result.err(error);
    }

    public static <V> Result<V> ok(V value) {
        return new Ok<V>(value);
    }

    public static <V> Result<V> err(CharSequence error) {
        return new Err(error);
    }

    public static <V> Result<V> err(String format, Object ... args) {
        try {
            return Result.err(String.format(format, args));
        }
        catch (Exception e) {
            return Result.err(format + " " + Arrays.toString(args));
        }
    }

    public boolean isOk();

    public boolean isErr();

    public Optional<V> value();

    public Optional<String> error();

    public V unwrap();

    public V unwrap(CharSequence var1);

    public V orElse(V var1);

    public V orElseGet(SupplierWithException<? extends V> var1);

    public <R extends Throwable> V orElseThrow(FunctionWithException<? super String, ? extends R> var1) throws R;

    public <U> Result<U> map(FunctionWithException<? super V, ? extends U> var1);

    public Result<V> mapErr(FunctionWithException<? super String, ? extends CharSequence> var1);

    public <U> Result<U> flatMap(FunctionWithException<? super V, ? extends Result<? extends U>> var1);

    public Result<V> recover(FunctionWithException<? super String, ? extends V> var1);

    public Result<V> recoverWith(FunctionWithException<? super String, ? extends Result<? extends V>> var1);

    public void accept(ConsumerWithException<? super V> var1, ConsumerWithException<? super String> var2);

    public <U> Result<U> asError();
}

