/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.errorhandler;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.builder.DefaultErrorHandlerBuilder;
import org.apache.camel.processor.ErrorHandler;
import org.apache.camel.processor.errorhandler.DefaultErrorHandler;
import org.apache.camel.processor.errorhandler.ExceptionPolicyStrategy;
import org.apache.camel.reifier.errorhandler.ErrorHandlerReifier;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.ThreadPoolProfile;

public class DefaultErrorHandlerReifier<T extends DefaultErrorHandlerBuilder>
extends ErrorHandlerReifier<T> {
    public DefaultErrorHandlerReifier(Route route, ErrorHandlerFactory definition) {
        super(route, (DefaultErrorHandlerBuilder)definition);
    }

    @Override
    public Processor createErrorHandler(Processor processor) throws Exception {
        DefaultErrorHandler answer = new DefaultErrorHandler(this.camelContext, processor, ((DefaultErrorHandlerBuilder)this.definition).getLogger(), this.getBean(Processor.class, ((DefaultErrorHandlerBuilder)this.definition).getOnRedelivery(), ((DefaultErrorHandlerBuilder)this.definition).getOnRedeliveryRef()), ((DefaultErrorHandlerBuilder)this.definition).getRedeliveryPolicy(), this.getBean(ExceptionPolicyStrategy.class, ((DefaultErrorHandlerBuilder)this.definition).getExceptionPolicyStrategy(), ((DefaultErrorHandlerBuilder)this.definition).getExceptionPolicyStrategyRef()), this.getPredicate(((DefaultErrorHandlerBuilder)this.definition).getRetryWhile(), ((DefaultErrorHandlerBuilder)this.definition).getRetryWhileRef()), this.getExecutorService(((DefaultErrorHandlerBuilder)this.definition).getExecutorService(), ((DefaultErrorHandlerBuilder)this.definition).getExecutorServiceRef()), this.getBean(Processor.class, ((DefaultErrorHandlerBuilder)this.definition).getOnPrepareFailure(), ((DefaultErrorHandlerBuilder)this.definition).getOnPrepareFailureRef()), this.getBean(Processor.class, ((DefaultErrorHandlerBuilder)this.definition).getOnExceptionOccurred(), ((DefaultErrorHandlerBuilder)this.definition).getOnExceptionOccurredRef()));
        this.configure((ErrorHandler)answer);
        return answer;
    }

    protected synchronized ScheduledExecutorService getExecutorService(ScheduledExecutorService executorService, String executorServiceRef) {
        if (executorService == null || executorService.isShutdown()) {
            if (executorServiceRef != null) {
                executorService = this.lookup(executorServiceRef, ScheduledExecutorService.class);
                if (executorService == null) {
                    ExecutorServiceManager manager = this.camelContext.getExecutorServiceManager();
                    ThreadPoolProfile profile = manager.getThreadPoolProfile(executorServiceRef);
                    executorService = manager.newScheduledThreadPool((Object)this, executorServiceRef, profile);
                }
                if (executorService == null) {
                    throw new IllegalArgumentException("ExecutorServiceRef " + executorServiceRef + " not found in registry.");
                }
            } else {
                executorService = null;
            }
        }
        return executorService;
    }
}

