/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.util.filesystem.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.aries.util.IORuntimeException;
import org.apache.aries.util.filesystem.ICloseableDirectory;
import org.apache.aries.util.filesystem.IDirectory;
import org.apache.aries.util.filesystem.IFile;
import org.apache.aries.util.filesystem.impl.DirectoryImpl;
import org.apache.aries.util.filesystem.impl.InputStreamClosableDirectory;
import org.apache.aries.util.filesystem.impl.ZipDirectory;
import org.apache.aries.util.io.IOUtils;

public class FileSystemImpl {
    public static IDirectory getFSRoot(File fs, IDirectory parent) {
        IDirectory dir = null;
        if (fs.exists()) {
            if (fs.isDirectory()) {
                dir = new DirectoryImpl(fs, fs);
            } else if (fs.isFile() && FileSystemImpl.isValidZip(fs)) {
                try {
                    dir = new ZipDirectory(fs, parent);
                }
                catch (IOException e) {
                    throw new IORuntimeException("IOException in IDirectory.getFSRoot", e);
                }
            }
        } else {
            throw new IORuntimeException("File not found in IDirectory.getFSRoot", new FileNotFoundException(fs.getPath()));
        }
        return dir;
    }

    public static boolean isValidZip(File zip) {
        try {
            ZipFile zf = new ZipFile(zip);
            zf.close();
            return true;
        }
        catch (IOException e) {
            throw new IORuntimeException("Not a valid zip: " + zip, e);
        }
    }

    public static boolean isValidZip(IFile zip) {
        boolean bl;
        ZipInputStream zis = null;
        try {
            zis = new ZipInputStream(zip.open());
            bl = zis.getNextEntry() != null;
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException("Not a valid zip: " + zip, e);
            }
            catch (Throwable throwable) {
                IOUtils.close(zis);
                throw throwable;
            }
        }
        IOUtils.close(zis);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ICloseableDirectory getFSRoot(InputStream is) {
        File tempFile = null;
        try {
            tempFile = File.createTempFile("inputStreamExtract", ".zip");
        }
        catch (IOException e1) {
            throw new IORuntimeException("IOException in IDirectory.getFSRoot", e1);
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(tempFile);
            IOUtils.copy(is, fos);
        }
        catch (IOException e) {
            ICloseableDirectory iCloseableDirectory;
            try {
                iCloseableDirectory = null;
            }
            catch (Throwable throwable) {
                IOUtils.close(fos);
                throw throwable;
            }
            IOUtils.close(fos);
            return iCloseableDirectory;
        }
        IOUtils.close(fos);
        IDirectory dir = FileSystemImpl.getFSRoot(tempFile, null);
        if (dir == null) {
            return null;
        }
        return new InputStreamClosableDirectory(dir, tempFile);
    }
}

