/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.errors;

import java.util.Map;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.streams.errors.ErrorHandlerContext;
import org.apache.kafka.streams.errors.ProductionExceptionHandler;
import org.apache.kafka.streams.errors.internals.ExceptionHandlerUtils;

public class DefaultProductionExceptionHandler
implements ProductionExceptionHandler {
    private String deadLetterQueueTopic = null;

    @Override
    public ProductionExceptionHandler.Response handleError(ErrorHandlerContext context, ProducerRecord<byte[], byte[]> record, Exception exception) {
        return exception instanceof RetriableException ? ProductionExceptionHandler.Response.retry() : ProductionExceptionHandler.Response.fail(ExceptionHandlerUtils.maybeBuildDeadLetterQueueRecords(this.deadLetterQueueTopic, context.sourceRawKey(), context.sourceRawValue(), context, exception));
    }

    @Override
    public ProductionExceptionHandler.Response handleSerializationError(ErrorHandlerContext context, ProducerRecord record, Exception exception, ProductionExceptionHandler.SerializationExceptionOrigin origin) {
        return ProductionExceptionHandler.Response.fail(ExceptionHandlerUtils.maybeBuildDeadLetterQueueRecords(this.deadLetterQueueTopic, context.sourceRawKey(), context.sourceRawValue(), context, exception));
    }

    public void configure(Map<String, ?> configs) {
        if (configs.get("errors.dead.letter.queue.topic.name") != null) {
            this.deadLetterQueueTopic = String.valueOf(configs.get("errors.dead.letter.queue.topic.name"));
        }
    }
}

