/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft.internals;

import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.common.message.AddRaftVoterResponseData;
import org.apache.kafka.common.message.ApiVersionsRequestData;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.Endpoints;
import org.apache.kafka.raft.LeaderState;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.raft.RaftUtil;
import org.apache.kafka.raft.ReplicaKey;
import org.apache.kafka.raft.VoterSet;
import org.apache.kafka.raft.internals.AddVoterHandlerState;
import org.apache.kafka.raft.internals.KRaftControlRecordStateMachine;
import org.apache.kafka.raft.internals.LogHistory;
import org.apache.kafka.raft.internals.RequestSender;
import org.apache.kafka.server.common.KRaftVersion;
import org.slf4j.Logger;

public final class AddVoterHandler {
    private final KRaftControlRecordStateMachine partitionState;
    private final RequestSender requestSender;
    private final Time time;
    private final Logger logger;

    public AddVoterHandler(KRaftControlRecordStateMachine partitionState, RequestSender requestSender, Time time, LogContext logContext) {
        this.partitionState = partitionState;
        this.requestSender = requestSender;
        this.time = time;
        this.logger = logContext.logger(AddVoterHandler.class);
    }

    public CompletableFuture<AddRaftVoterResponseData> handleAddVoterRequest(LeaderState<?> leaderState, ReplicaKey voterKey, Endpoints voterEndpoints, boolean ackWhenCommitted, long currentTimeMs) {
        if (leaderState.isOperationPending(currentTimeMs)) {
            return CompletableFuture.completedFuture(RaftUtil.addVoterResponse(Errors.REQUEST_TIMED_OUT, "Request timed out waiting for leader to handle previous voter change request"));
        }
        Optional<Long> highWatermark = leaderState.highWatermark().map(LogOffsetMetadata::offset);
        if (highWatermark.isEmpty()) {
            return CompletableFuture.completedFuture(RaftUtil.addVoterResponse(Errors.REQUEST_TIMED_OUT, "Request timed out waiting for leader to establish HWM and fence previous voter changes"));
        }
        KRaftVersion kraftVersion = this.partitionState.lastKraftVersion();
        if (!kraftVersion.isReconfigSupported()) {
            return CompletableFuture.completedFuture(RaftUtil.addVoterResponse(Errors.UNSUPPORTED_VERSION, String.format("Cluster doesn't support adding voter because the %s feature is %s", kraftVersion.featureName(), kraftVersion.featureLevel())));
        }
        Optional<LogHistory.Entry<VoterSet>> votersEntry = this.partitionState.lastVoterSetEntry();
        if (votersEntry.isEmpty() || votersEntry.get().offset() >= highWatermark.get()) {
            return CompletableFuture.completedFuture(RaftUtil.addVoterResponse(Errors.REQUEST_TIMED_OUT, String.format("Request timed out waiting for voters to commit the latest voter change at %s with HWM %d", votersEntry.map(LogHistory.Entry::offset), highWatermark.get())));
        }
        VoterSet voters = votersEntry.get().value();
        if (voters.voterIds().contains(voterKey.id())) {
            return CompletableFuture.completedFuture(RaftUtil.addVoterResponse(Errors.DUPLICATE_VOTER, String.format("The voter id for %s is already part of the set of voters %s.", voterKey, voters.voterKeys())));
        }
        OptionalLong timeout = this.requestSender.send(voterEndpoints.address(this.requestSender.listenerName()).map(address -> new Node(voterKey.id(), address.getHostName(), address.getPort())).orElseThrow(() -> new IllegalArgumentException(String.format("Provided listeners %s do not contain a listener for %s", voterEndpoints, this.requestSender.listenerName()))), this::buildApiVersionsRequest, currentTimeMs);
        if (timeout.isEmpty()) {
            return CompletableFuture.completedFuture(RaftUtil.addVoterResponse(Errors.REQUEST_TIMED_OUT, String.format("New voter %s is not ready to receive requests", voterKey)));
        }
        AddVoterHandlerState state = new AddVoterHandlerState(voterKey, voterEndpoints, ackWhenCommitted, this.time.timer(timeout.getAsLong()));
        leaderState.resetAddVoterHandlerState(Errors.UNKNOWN_SERVER_ERROR, null, Optional.of(state));
        return state.future();
    }

    public boolean handleApiVersionsResponse(LeaderState<?> leaderState, Node source, Errors error, Optional<ApiVersionsResponseData.SupportedFeatureKey> supportedKraftVersions, long currentTimeMs) {
        Optional<AddVoterHandlerState> handlerState = leaderState.addVoterHandlerState();
        if (handlerState.isEmpty()) {
            return true;
        }
        AddVoterHandlerState current = handlerState.get();
        if (!current.expectingApiResponse(source.id())) {
            this.logger.info("API_VERSIONS response is not expected from {}: voterKey is {}, lastOffset is {}", new Object[]{source, current.voterKey(), current.lastOffset()});
            return true;
        }
        if (error != Errors.NONE) {
            this.logger.info("Aborting add voter operation for {} at {} since API_VERSIONS returned an error {}", new Object[]{current.voterKey(), current.voterEndpoints(), error});
            leaderState.resetAddVoterHandlerState(Errors.REQUEST_TIMED_OUT, String.format("Aborted add voter operation for since API_VERSIONS returned an error %s", error), Optional.empty());
            return false;
        }
        KRaftVersion kraftVersion = this.partitionState.lastKraftVersion();
        if (!this.validVersionRange(kraftVersion, supportedKraftVersions)) {
            this.logger.info("Aborting add voter operation for {} at {} since kraft.version range {} doesn't support reconfiguration", new Object[]{current.voterKey(), current.voterEndpoints(), supportedKraftVersions});
            leaderState.resetAddVoterHandlerState(Errors.INVALID_REQUEST, String.format("Aborted add voter operation for %s since the %s range %s doesn't support the finalized version %s", current.voterKey(), "kraft.version", supportedKraftVersions.map(range -> String.format("(min: %s, max: %s", range.minVersion(), range.maxVersion())).orElse("(min: 0, max: 0)"), kraftVersion.featureLevel()), Optional.empty());
            return true;
        }
        if (!leaderState.isReplicaCaughtUp(current.voterKey(), currentTimeMs)) {
            this.logger.info("Aborting add voter operation for {} at {} since it is lagging behind: {}", new Object[]{current.voterKey(), current.voterEndpoints(), leaderState.getReplicaState(current.voterKey())});
            leaderState.resetAddVoterHandlerState(Errors.REQUEST_TIMED_OUT, String.format("Aborted add voter operation for %s since it is lagging behind", current.voterKey()), Optional.empty());
            return true;
        }
        VoterSet newVoters = this.partitionState.lastVoterSet().addVoter(VoterSet.VoterNode.of(current.voterKey(), current.voterEndpoints(), new SupportedVersionRange(supportedKraftVersions.get().minVersion(), supportedKraftVersions.get().maxVersion()))).orElseThrow(() -> new IllegalStateException(String.format("Unable to add %s to the set of voters %s", current.voterKey(), this.partitionState.lastVoterSet())));
        current.setLastOffset(leaderState.appendVotersRecord(newVoters, currentTimeMs));
        if (!current.ackWhenCommitted()) {
            current.future().complete(RaftUtil.addVoterResponse(Errors.NONE, null));
        }
        return true;
    }

    public void highWatermarkUpdated(LeaderState<?> leaderState) {
        leaderState.addVoterHandlerState().ifPresent(current -> leaderState.highWatermark().ifPresent(highWatermark -> current.lastOffset().ifPresent(lastOffset -> {
            if (highWatermark.offset() > lastOffset) {
                leaderState.resetAddVoterHandlerState(Errors.NONE, null, Optional.empty());
            }
        })));
    }

    private ApiVersionsRequestData buildApiVersionsRequest() {
        return ((ApiVersionsRequest)new ApiVersionsRequest.Builder().build()).data();
    }

    private boolean validVersionRange(KRaftVersion finalizedVersion, Optional<ApiVersionsResponseData.SupportedFeatureKey> supportedKraftVersions) {
        return supportedKraftVersions.isPresent() && supportedKraftVersions.get().minVersion() <= finalizedVersion.featureLevel() && supportedKraftVersions.get().maxVersion() >= finalizedVersion.featureLevel();
    }
}

