/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import org.apache.kafka.common.errors.InvalidOffsetException;
import org.apache.kafka.storage.internals.log.AbstractIndex;
import org.apache.kafka.storage.internals.log.CorruptIndexException;
import org.apache.kafka.storage.internals.log.IndexSearchType;
import org.apache.kafka.storage.internals.log.TimestampOffset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeIndex
extends AbstractIndex {
    private static final Logger log = LoggerFactory.getLogger(TimeIndex.class);
    private static final int ENTRY_SIZE = 12;
    private volatile TimestampOffset lastEntry = this.lastEntryFromIndexFile();

    public TimeIndex(File file, long baseOffset, int maxIndexSize) throws IOException {
        this(file, baseOffset, maxIndexSize, true);
    }

    public TimeIndex(File file, long baseOffset, int maxIndexSize, boolean writable) throws IOException {
        super(file, baseOffset, maxIndexSize, writable);
        log.debug("Loaded index file {} with maxEntries = {}, maxIndexSize = {}, entries = {}, lastOffset = {}, file position = {}", new Object[]{file.getAbsolutePath(), this.maxEntries(), maxIndexSize, this.entries(), this.lastEntry.offset(), this.mmap().position()});
    }

    @Override
    public void sanityCheck() {
        TimestampOffset entry = this.lastEntry();
        long lastTimestamp = entry.timestamp();
        long lastOffset = entry.offset();
        this.inRemapReadLock(() -> {
            if (this.entries() != 0 && lastTimestamp < this.timestamp(this.mmap(), 0)) {
                throw new CorruptIndexException("Corrupt time index found, time index file (" + this.file().getAbsolutePath() + ") has non-zero size but the last timestamp is " + lastTimestamp + " which is less than the first timestamp " + this.timestamp(this.mmap(), 0));
            }
        });
        if (this.entries() != 0 && lastOffset < this.baseOffset()) {
            throw new CorruptIndexException("Corrupt time index found, time index file (" + this.file().getAbsolutePath() + ") has non-zero size but the last offset is " + lastOffset + " which is less than the first offset " + this.baseOffset());
        }
        if (this.length() % 12L != 0L) {
            throw new CorruptIndexException("Time index file " + this.file().getAbsolutePath() + " is corrupt, found " + this.length() + " bytes which is neither positive nor a multiple of 12");
        }
    }

    @Override
    public void truncateTo(long offset) {
        this.inLock(() -> {
            MappedByteBuffer idx = this.mmap().duplicate();
            int slot = this.largestLowerBoundSlotFor(idx, offset, IndexSearchType.VALUE);
            int newEntries = slot < 0 ? 0 : ((long)this.relativeOffset(idx, slot) == offset - this.baseOffset() ? slot : slot + 1);
            this.truncateToEntries(newEntries);
        });
    }

    @Override
    public boolean isFull() {
        return this.entries() >= this.maxEntries() - 1;
    }

    public TimestampOffset lastEntry() {
        return this.lastEntry;
    }

    public TimestampOffset entry(int n) {
        return (TimestampOffset)this.inRemapReadLock(() -> {
            if (n >= this.entries()) {
                throw new IllegalArgumentException("Attempt to fetch the " + n + "th entry from time index " + this.file().getAbsolutePath() + " which has size " + this.entries());
            }
            return this.parseEntry(this.mmap(), n);
        });
    }

    public TimestampOffset lookup(long targetTimestamp) {
        return (TimestampOffset)this.inRemapReadLock(() -> {
            MappedByteBuffer idx = this.mmap().duplicate();
            int slot = this.largestLowerBoundSlotFor(idx, targetTimestamp, IndexSearchType.KEY);
            if (slot == -1) {
                return new TimestampOffset(-1L, this.baseOffset());
            }
            return this.parseEntry(idx, slot);
        });
    }

    public void maybeAppend(long timestamp, long offset) {
        this.maybeAppend(timestamp, offset, false);
    }

    public void maybeAppend(long timestamp, long offset, boolean skipFullCheck) {
        this.inLock(() -> {
            if (!skipFullCheck && this.isFull()) {
                throw new IllegalArgumentException("Attempt to append to a full time index (size = " + this.entries() + ").");
            }
            if (this.entries() != 0 && offset < this.lastEntry.offset()) {
                throw new InvalidOffsetException("Attempt to append an offset (" + offset + ") to slot " + this.entries() + " no larger than the last offset appended (" + this.lastEntry.offset() + ") to " + this.file().getAbsolutePath());
            }
            if (this.entries() != 0 && timestamp < this.lastEntry.timestamp()) {
                throw new IllegalStateException("Attempt to append a timestamp (" + timestamp + ") to slot " + this.entries() + " no larger than the last timestamp appended (" + this.lastEntry.timestamp() + ") to " + this.file().getAbsolutePath());
            }
            if (timestamp > this.lastEntry.timestamp()) {
                log.trace("Adding index entry {} => {} to {}.", new Object[]{timestamp, offset, this.file().getAbsolutePath()});
                MappedByteBuffer mmap = this.mmap();
                mmap.putLong(timestamp);
                mmap.putInt(this.relativeOffset(offset));
                this.incrementEntries();
                this.lastEntry = new TimestampOffset(timestamp, offset);
                if (this.entries() * 12 != mmap.position()) {
                    throw new IllegalStateException(this.entries() + " entries but file position in index is " + mmap.position());
                }
            }
        });
    }

    @Override
    public boolean resize(int newSize) throws IOException {
        return (Boolean)this.inLock(() -> {
            if (super.resize(newSize)) {
                this.lastEntry = this.lastEntryFromIndexFile();
                return true;
            }
            return false;
        });
    }

    @Override
    public void truncate() {
        this.truncateToEntries(0);
    }

    @Override
    protected int entrySize() {
        return 12;
    }

    @Override
    protected TimestampOffset parseEntry(ByteBuffer buffer, int n) {
        return new TimestampOffset(this.timestamp(buffer, n), this.baseOffset() + (long)this.relativeOffset(buffer, n));
    }

    private long timestamp(ByteBuffer buffer, int n) {
        return buffer.getLong(n * 12);
    }

    private int relativeOffset(ByteBuffer buffer, int n) {
        return buffer.getInt(n * 12 + 8);
    }

    private TimestampOffset lastEntryFromIndexFile() {
        return (TimestampOffset)this.inRemapReadLock(() -> {
            int entries = this.entries();
            if (entries == 0) {
                return new TimestampOffset(-1L, this.baseOffset());
            }
            return this.parseEntry(this.mmap(), entries - 1);
        });
    }

    private void truncateToEntries(int entries) {
        this.inLock(() -> {
            super.truncateToEntries0(entries);
            this.lastEntry = this.lastEntryFromIndexFile();
            log.debug("Truncated index {} to {} entries; position is now {} and last entry is now {}", new Object[]{this.file().getAbsolutePath(), entries, this.mmap().position(), this.lastEntry.offset()});
        });
    }
}

