/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.hashing;

import com.dynatrace.hash4j.hashing.AbstractHasher64;
import com.dynatrace.hash4j.internal.ByteArrayUtil;
import com.dynatrace.hash4j.internal.UnsignedMultiplyUtil;

abstract class XXH3Base
implements AbstractHasher64 {
    protected static final int BLOCK_LEN_EXP = 10;
    protected static final long SECRET_00 = -4734510112055689544L;
    protected static final long SECRET_01 = 2066345149520216444L;
    protected static final long SECRET_02 = -2623469361688619810L;
    protected static final long SECRET_03 = 2262974939099578482L;
    protected static final long SECRET_04 = 8711581037947681227L;
    protected static final long SECRET_05 = 2410270004345854594L;
    protected static final long SECRET_06 = -8204357891075471176L;
    protected static final long SECRET_07 = 5487137525590930912L;
    protected static final long SECRET_08 = -3818837453329782724L;
    protected static final long SECRET_09 = -6688317018830679928L;
    protected static final long SECRET_10 = 5690594596133299313L;
    protected static final long SECRET_11 = -2833645246901970632L;
    protected static final long SECRET_12 = 4554437623014685352L;
    protected static final long SECRET_13 = 2111919702937427193L;
    protected static final long SECRET_14 = 3556072174620004746L;
    protected static final long SECRET_15 = 7238261902898274248L;
    protected static final long SECRET_16 = -4329134394285701654L;
    protected static final long SECRET_17 = -1485321483350670907L;
    protected static final long SECRET_18 = 5321830579834785047L;
    protected static final long SECRET_19 = -7032137544937171245L;
    protected static final long SECRET_20 = -242834301215959509L;
    protected static final long SECRET_21 = -3588858202114426737L;
    protected static final long SECRET_22 = 2883454493032893253L;
    protected static final long SECRET_23 = 9097354517224871855L;
    protected static final long INIT_ACC_0 = 3266489917L;
    protected static final long INIT_ACC_1 = -7046029288634856825L;
    protected static final long INIT_ACC_2 = -4417276706812531889L;
    protected static final long INIT_ACC_3 = 1609587929392839161L;
    protected static final long INIT_ACC_4 = -8796714831421723037L;
    protected static final long INIT_ACC_5 = 2246822519L;
    protected static final long INIT_ACC_6 = 2870177450012600261L;
    protected static final long INIT_ACC_7 = 2654435761L;
    protected final long secret00;
    protected final long secret01;
    protected final long secret02;
    protected final long secret03;
    protected final long secret04;
    protected final long secret05;
    protected final long secret06;
    protected final long secret07;
    protected final long secret08;
    protected final long secret09;
    protected final long secret10;
    protected final long secret11;
    protected final long secret12;
    protected final long secret13;
    protected final long secret14;
    protected final long secret15;
    protected final long secret16;
    protected final long secret17;
    protected final long secret18;
    protected final long secret19;
    protected final long secret20;
    protected final long secret21;
    protected final long secret22;
    protected final long secret23;
    protected final long[] secret;
    protected final long secShift00;
    protected final long secShift01;
    protected final long secShift02;
    protected final long secShift03;
    protected final long secShift04;
    protected final long secShift05;
    protected final long secShift06;
    protected final long secShift07;
    protected final long secShift08;
    protected final long secShift09;
    protected final long secShift10;
    protected final long secShift11;
    protected final long secShift16;
    protected final long secShift17;
    protected final long secShift18;
    protected final long secShift19;
    protected final long secShift20;
    protected final long secShift21;
    protected final long secShift22;
    protected final long secShift23;
    protected final long secShiftFinal0;
    protected final long secShiftFinal1;
    protected final long secShiftFinal2;
    protected final long secShiftFinal3;
    protected final long secShiftFinal4;
    protected final long secShiftFinal5;
    protected final long secShiftFinal6;
    protected final long secShiftFinal7;

    protected XXH3Base(long seed) {
        this.secret00 = -4734510112055689544L + seed;
        this.secret01 = 2066345149520216444L - seed;
        this.secret02 = -2623469361688619810L + seed;
        this.secret03 = 2262974939099578482L - seed;
        this.secret04 = 8711581037947681227L + seed;
        this.secret05 = 2410270004345854594L - seed;
        this.secret06 = -8204357891075471176L + seed;
        this.secret07 = 5487137525590930912L - seed;
        this.secret08 = -3818837453329782724L + seed;
        this.secret09 = -6688317018830679928L - seed;
        this.secret10 = 5690594596133299313L + seed;
        this.secret11 = -2833645246901970632L - seed;
        this.secret12 = 4554437623014685352L + seed;
        this.secret13 = 2111919702937427193L - seed;
        this.secret14 = 3556072174620004746L + seed;
        this.secret15 = 7238261902898274248L - seed;
        this.secret16 = -4329134394285701654L + seed;
        this.secret17 = -1485321483350670907L - seed;
        this.secret18 = 5321830579834785047L + seed;
        this.secret19 = -7032137544937171245L - seed;
        this.secret20 = -242834301215959509L + seed;
        this.secret21 = -3588858202114426737L - seed;
        this.secret22 = 2883454493032893253L + seed;
        this.secret23 = 9097354517224871855L - seed;
        this.secShift00 = -9150895811085458631L + seed;
        this.secShift01 = 7914194659941938988L - seed;
        this.secShift02 = -6611157965513653271L + seed;
        this.secShift03 = -1839215637059881052L - seed;
        this.secShift04 = -3433288310154277810L + seed;
        this.secShift05 = 5046485836271438973L - seed;
        this.secShift06 = -8055285457383852172L + seed;
        this.secShift07 = 5920048007935066598L - seed;
        this.secShift08 = 7336514198459093435L + seed;
        this.secShift09 = 5216419214072683403L - seed;
        this.secShift10 = -1217880312389983593L + seed;
        this.secShift11 = 8573350489219836230L - seed;
        this.secShift16 = this.secret15 >>> 8 | this.secret16 << 56;
        this.secShift17 = this.secret16 >>> 8 | this.secret17 << 56;
        this.secShift18 = this.secret17 >>> 8 | this.secret18 << 56;
        this.secShift19 = this.secret18 >>> 8 | this.secret19 << 56;
        this.secShift20 = this.secret19 >>> 8 | this.secret20 << 56;
        this.secShift21 = this.secret20 >>> 8 | this.secret21 << 56;
        this.secShift22 = this.secret21 >>> 8 | this.secret22 << 56;
        this.secShift23 = this.secret22 >>> 8 | this.secret23 << 56;
        this.secShiftFinal0 = this.secret01 >>> 24 | this.secret02 << 40;
        this.secShiftFinal1 = this.secret02 >>> 24 | this.secret03 << 40;
        this.secShiftFinal2 = this.secret03 >>> 24 | this.secret04 << 40;
        this.secShiftFinal3 = this.secret04 >>> 24 | this.secret05 << 40;
        this.secShiftFinal4 = this.secret05 >>> 24 | this.secret06 << 40;
        this.secShiftFinal5 = this.secret06 >>> 24 | this.secret07 << 40;
        this.secShiftFinal6 = this.secret07 >>> 24 | this.secret08 << 40;
        this.secShiftFinal7 = this.secret08 >>> 24 | this.secret09 << 40;
        this.secret = new long[]{this.secret00, this.secret01, this.secret02, this.secret03, this.secret04, this.secret05, this.secret06, this.secret07, this.secret08, this.secret09, this.secret10, this.secret11, this.secret12, this.secret13, this.secret14, this.secret15, this.secret16, this.secret17, this.secret18, this.secret19, this.secret20, this.secret21, this.secret22, this.secret23};
    }

    protected static long unsignedLongMulXorFold(long lhs, long rhs) {
        long upper = UnsignedMultiplyUtil.unsignedMultiplyHigh(lhs, rhs);
        long lower = lhs * rhs;
        return lower ^ upper;
    }

    protected static long avalanche64(long h64) {
        h64 ^= h64 >>> 33;
        h64 *= -4417276706812531889L;
        h64 ^= h64 >>> 29;
        return (h64 *= 1609587929392839161L) ^ h64 >>> 32;
    }

    protected static long avalanche3(long h64) {
        h64 ^= h64 >>> 37;
        return (h64 *= 1609587791953885689L) ^ h64 >>> 32;
    }

    protected static long mix2Accs(long lh, long rh, long sec0, long sec8) {
        return XXH3Base.unsignedLongMulXorFold(lh ^ sec0, rh ^ sec8);
    }

    protected static long contrib(long a, long b) {
        long k = a ^ b;
        return (0xFFFFFFFFL & k) * (k >>> 32);
    }

    protected static long mixAcc(long acc, long sec) {
        return (acc ^ acc >>> 47 ^ sec) * 2654435761L;
    }

    protected abstract long finish12Bytes(long var1, long var3);

    @Override
    public long hashLongIntToLong(long v1, int v2) {
        return this.finish12Bytes(v1, (long)v2 << 32 ^ v1 >>> 32);
    }

    @Override
    public long hashIntIntIntToLong(int v1, int v2, int v3) {
        return this.finish12Bytes((long)v1 & 0xFFFFFFFFL ^ (long)v2 << 32, (long)v3 << 32 ^ (long)v2 & 0xFFFFFFFFL);
    }

    @Override
    public long hashIntLongToLong(int v1, long v2) {
        return this.finish12Bytes((long)v1 & 0xFFFFFFFFL ^ v2 << 32, v2);
    }

    protected abstract class HashStreamImplBase {
        protected static final int BULK_SIZE = 256;
        protected static final int BULK_SIZE_HALF = 128;
        protected static final int BULK_SIZE_MASK = 255;
        protected long acc0 = 3266489917L;
        protected long acc1 = -7046029288634856825L;
        protected long acc2 = -4417276706812531889L;
        protected long acc3 = 1609587929392839161L;
        protected long acc4 = -8796714831421723037L;
        protected long acc5 = 2246822519L;
        protected long acc6 = 2870177450012600261L;
        protected long acc7 = 2654435761L;
        protected final byte[] buffer = new byte[264];
        protected int offset = 0;
        protected long byteCount = 0L;

        protected HashStreamImplBase() {
        }

        protected void putByteImpl(byte v) {
            if (this.offset >= 256) {
                this.processBuffer();
                this.offset -= 256;
            }
            this.buffer[this.offset] = v;
            ++this.offset;
            ++this.byteCount;
        }

        protected void putShortImpl(short v) {
            ByteArrayUtil.setShort(this.buffer, this.offset, v);
            if (this.offset >= 255) {
                this.processBuffer();
                this.offset -= 256;
                ByteArrayUtil.setShort(this.buffer, 0, (short)(v >>> (-this.offset << 3)));
            }
            this.offset += 2;
            this.byteCount += 2L;
        }

        protected void putCharImpl(char v) {
            ByteArrayUtil.setChar(this.buffer, this.offset, v);
            if (this.offset >= 255) {
                this.processBuffer();
                this.offset -= 256;
                ByteArrayUtil.setChar(this.buffer, 0, (char)(v >>> (-this.offset << 3)));
            }
            this.offset += 2;
            this.byteCount += 2L;
        }

        protected void putIntImpl(int v) {
            ByteArrayUtil.setInt(this.buffer, this.offset, v);
            if (this.offset >= 253) {
                this.processBuffer();
                this.offset -= 256;
                ByteArrayUtil.setInt(this.buffer, 0, v >>> (-this.offset << 3));
            }
            this.offset += 4;
            this.byteCount += 4L;
        }

        protected void putLongImpl(long v) {
            ByteArrayUtil.setLong(this.buffer, this.offset, v);
            if (this.offset >= 249) {
                this.processBuffer();
                this.offset -= 256;
                ByteArrayUtil.setLong(this.buffer, 0, v >>> (-this.offset << 3));
            }
            this.offset += 8;
            this.byteCount += 8L;
        }

        protected void putBytesImpl(byte[] b, int off, int len) {
            int remaining = len;
            int x = 256 - this.offset;
            if (len > x) {
                int s = (int)(this.byteCount - 1L >>> 6) & 0xC;
                if (this.offset > 0) {
                    System.arraycopy(b, off, this.buffer, this.offset, x);
                    this.processBuffer(0, this.buffer, s);
                    this.offset = 0;
                    off += x;
                    remaining -= x;
                }
                if (remaining > 256) {
                    do {
                        s += 4;
                        this.processBuffer(off, b, s &= 0xC);
                        off += 256;
                    } while ((remaining -= 256) > 256);
                    if (remaining < 64) {
                        int l = 64 - remaining;
                        System.arraycopy(b, off - l, this.buffer, 256 - l, l);
                    }
                }
            }
            System.arraycopy(b, off, this.buffer, this.offset, remaining);
            this.offset += remaining;
            this.byteCount += (long)len;
        }

        protected void putCharsImpl(CharSequence c) {
            int off = 0;
            int remaining = c.length();
            int x = 128 - (this.offset >>> 1);
            if ((this.offset & 1) == 0) {
                if (c.length() > x) {
                    int s = (int)(this.byteCount - 1L >>> 6) & 0xC;
                    if (this.offset > 0) {
                        ByteArrayUtil.copyCharsToByteArray(c, 0, this.buffer, this.offset, x);
                        this.processBuffer(0, this.buffer, s);
                        this.offset = 0;
                        off += x;
                        remaining -= x;
                    }
                    if (remaining > 128) {
                        do {
                            s += 4;
                            this.processBuffer(off, c, s &= 0xC);
                            off += 128;
                        } while ((remaining -= 128) > 128);
                        if (remaining < 32) {
                            int l = 32 - remaining;
                            ByteArrayUtil.copyCharsToByteArray(c, off - l, this.buffer, 256 - (l << 1), l);
                        }
                    }
                }
            } else if (c.length() >= x) {
                int s = (int)(this.byteCount - 1L >>> 6) & 0xC;
                ByteArrayUtil.copyCharsToByteArray(c, 0, this.buffer, this.offset, x);
                long extraByte = (long)this.buffer[256] & 0xFFL;
                this.processBuffer(0, this.buffer, s);
                this.offset = 1;
                off += x;
                if ((remaining -= x) >= 128) {
                    do {
                        s += 4;
                        extraByte = this.processBuffer(off, c, s &= 0xC, extraByte);
                        off += 128;
                    } while ((remaining -= 128) >= 128);
                    if (remaining < 32) {
                        int l = 32 - remaining;
                        ByteArrayUtil.copyCharsToByteArray(c, off - l, this.buffer, 257 - (l << 1), l);
                    }
                }
                this.buffer[0] = (byte)extraByte;
            }
            ByteArrayUtil.copyCharsToByteArray(c, off, this.buffer, this.offset, remaining);
            this.offset += remaining << 1;
            this.byteCount += (long)c.length() << 1;
        }

        protected void resetImpl() {
            this.acc0 = 3266489917L;
            this.acc1 = -7046029288634856825L;
            this.acc2 = -4417276706812531889L;
            this.acc3 = 1609587929392839161L;
            this.acc4 = -8796714831421723037L;
            this.acc5 = 2246822519L;
            this.acc6 = 2870177450012600261L;
            this.acc7 = 2654435761L;
            this.offset = 0;
            this.byteCount = 0L;
        }

        protected void copyImpl(HashStreamImplBase hashStream) {
            hashStream.acc0 = this.acc0;
            hashStream.acc1 = this.acc1;
            hashStream.acc2 = this.acc2;
            hashStream.acc3 = this.acc3;
            hashStream.acc4 = this.acc4;
            hashStream.acc5 = this.acc5;
            hashStream.acc6 = this.acc6;
            hashStream.acc7 = this.acc7;
            hashStream.offset = this.offset;
            hashStream.byteCount = this.byteCount;
            System.arraycopy(this.buffer, 0, hashStream.buffer, 0, this.buffer.length);
        }

        private void processBuffer() {
            int s = (int)(this.byteCount - 1L >>> 6) & 0xC;
            this.processBuffer(0, this.buffer, s);
        }

        private void mixAcc() {
            this.acc0 = XXH3Base.mixAcc(this.acc0, XXH3Base.this.secret16);
            this.acc1 = XXH3Base.mixAcc(this.acc1, XXH3Base.this.secret17);
            this.acc2 = XXH3Base.mixAcc(this.acc2, XXH3Base.this.secret18);
            this.acc3 = XXH3Base.mixAcc(this.acc3, XXH3Base.this.secret19);
            this.acc4 = XXH3Base.mixAcc(this.acc4, XXH3Base.this.secret20);
            this.acc5 = XXH3Base.mixAcc(this.acc5, XXH3Base.this.secret21);
            this.acc6 = XXH3Base.mixAcc(this.acc6, XXH3Base.this.secret22);
            this.acc7 = XXH3Base.mixAcc(this.acc7, XXH3Base.this.secret23);
        }

        private void processBuffer(int off, byte[] buffer, int s) {
            for (int i = 0; i < 4; ++i) {
                int o = off + (i << 6);
                long b0 = ByteArrayUtil.getLong(buffer, o + 0);
                long b1 = ByteArrayUtil.getLong(buffer, o + 8);
                long b2 = ByteArrayUtil.getLong(buffer, o + 16);
                long b3 = ByteArrayUtil.getLong(buffer, o + 24);
                long b4 = ByteArrayUtil.getLong(buffer, o + 32);
                long b5 = ByteArrayUtil.getLong(buffer, o + 40);
                long b6 = ByteArrayUtil.getLong(buffer, o + 48);
                long b7 = ByteArrayUtil.getLong(buffer, o + 56);
                this.processBuffer(b0, b1, b2, b3, b4, b5, b6, b7, s + i);
            }
            if (s == 12) {
                this.mixAcc();
            }
        }

        private void processBuffer(int off, CharSequence c, int s) {
            for (int i = 0; i < 4; ++i) {
                int o = off + (i << 5);
                long b0 = ByteArrayUtil.getLong(c, o + 0);
                long b1 = ByteArrayUtil.getLong(c, o + 4);
                long b2 = ByteArrayUtil.getLong(c, o + 8);
                long b3 = ByteArrayUtil.getLong(c, o + 12);
                long b4 = ByteArrayUtil.getLong(c, o + 16);
                long b5 = ByteArrayUtil.getLong(c, o + 20);
                long b6 = ByteArrayUtil.getLong(c, o + 24);
                long b7 = ByteArrayUtil.getLong(c, o + 28);
                this.processBuffer(b0, b1, b2, b3, b4, b5, b6, b7, s + i);
            }
            if (s == 12) {
                this.mixAcc();
            }
        }

        private long processBuffer(int off, CharSequence c, int s, long extraByte) {
            for (int i = 0; i < 4; ++i) {
                int o = off + (i << 5);
                long b0 = ByteArrayUtil.getLong(c, o + 0);
                long b1 = ByteArrayUtil.getLong(c, o + 4);
                long b2 = ByteArrayUtil.getLong(c, o + 8);
                long b3 = ByteArrayUtil.getLong(c, o + 12);
                long b4 = ByteArrayUtil.getLong(c, o + 16);
                long b5 = ByteArrayUtil.getLong(c, o + 20);
                long b6 = ByteArrayUtil.getLong(c, o + 24);
                long b7 = ByteArrayUtil.getLong(c, o + 28);
                long y = b7 >>> 56;
                b7 = b6 >>> 56 | b7 << 8;
                b6 = b5 >>> 56 | b6 << 8;
                b5 = b4 >>> 56 | b5 << 8;
                b4 = b3 >>> 56 | b4 << 8;
                b3 = b2 >>> 56 | b3 << 8;
                b2 = b1 >>> 56 | b2 << 8;
                b1 = b0 >>> 56 | b1 << 8;
                b0 = extraByte | b0 << 8;
                extraByte = y;
                this.processBuffer(b0, b1, b2, b3, b4, b5, b6, b7, s + i);
            }
            if (s == 12) {
                this.mixAcc();
            }
            return extraByte;
        }

        private void processBuffer(long b0, long b1, long b2, long b3, long b4, long b5, long b6, long b7, int s) {
            this.acc0 += b1 + XXH3Base.contrib(b0, XXH3Base.this.secret[s + 0]);
            this.acc1 += b0 + XXH3Base.contrib(b1, XXH3Base.this.secret[s + 1]);
            this.acc2 += b3 + XXH3Base.contrib(b2, XXH3Base.this.secret[s + 2]);
            this.acc3 += b2 + XXH3Base.contrib(b3, XXH3Base.this.secret[s + 3]);
            this.acc4 += b5 + XXH3Base.contrib(b4, XXH3Base.this.secret[s + 4]);
            this.acc5 += b4 + XXH3Base.contrib(b5, XXH3Base.this.secret[s + 5]);
            this.acc6 += b7 + XXH3Base.contrib(b6, XXH3Base.this.secret[s + 6]);
            this.acc7 += b6 + XXH3Base.contrib(b7, XXH3Base.this.secret[s + 7]);
        }
    }
}

