/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class PartitionRecord
implements ApiMessage {
    int partitionId;
    Uuid topicId;
    List<Integer> replicas;
    List<Integer> isr;
    List<Integer> removingReplicas;
    List<Integer> addingReplicas;
    int leader;
    byte leaderRecoveryState;
    int leaderEpoch;
    int partitionEpoch;
    List<Uuid> directories;
    List<Integer> eligibleLeaderReplicas;
    List<Integer> lastKnownElr;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("partition_id", (Type)Type.INT32, "The partition id."), new Field("topic_id", (Type)Type.UUID, "The unique ID of this topic."), new Field("replicas", (Type)new CompactArrayOf((Type)Type.INT32), "The replicas of this partition, sorted by preferred order."), new Field("isr", (Type)new CompactArrayOf((Type)Type.INT32), "The in-sync replicas of this partition"), new Field("removing_replicas", (Type)new CompactArrayOf((Type)Type.INT32), "The replicas that we are in the process of removing."), new Field("adding_replicas", (Type)new CompactArrayOf((Type)Type.INT32), "The replicas that we are in the process of adding."), new Field("leader", (Type)Type.INT32, "The lead replica, or -1 if there is no leader."), new Field("leader_epoch", (Type)Type.INT32, "The epoch of the partition leader."), new Field("partition_epoch", (Type)Type.INT32, "An epoch that gets incremented each time we change anything in the partition."), Field.TaggedFieldsSection.of((Object[])new Object[]{0, new Field("leader_recovery_state", (Type)Type.INT8, "1 if the partition is recovering from an unclean leader election; 0 otherwise.")})});
    public static final Schema SCHEMA_1 = new Schema(new Field[]{new Field("partition_id", (Type)Type.INT32, "The partition id."), new Field("topic_id", (Type)Type.UUID, "The unique ID of this topic."), new Field("replicas", (Type)new CompactArrayOf((Type)Type.INT32), "The replicas of this partition, sorted by preferred order."), new Field("isr", (Type)new CompactArrayOf((Type)Type.INT32), "The in-sync replicas of this partition"), new Field("removing_replicas", (Type)new CompactArrayOf((Type)Type.INT32), "The replicas that we are in the process of removing."), new Field("adding_replicas", (Type)new CompactArrayOf((Type)Type.INT32), "The replicas that we are in the process of adding."), new Field("leader", (Type)Type.INT32, "The lead replica, or -1 if there is no leader."), new Field("leader_epoch", (Type)Type.INT32, "The epoch of the partition leader."), new Field("partition_epoch", (Type)Type.INT32, "An epoch that gets incremented each time we change anything in the partition."), new Field("directories", (Type)new CompactArrayOf((Type)Type.UUID), "The log directory hosting each replica, sorted in the same exact order as the Replicas field."), Field.TaggedFieldsSection.of((Object[])new Object[]{0, new Field("leader_recovery_state", (Type)Type.INT8, "1 if the partition is recovering from an unclean leader election; 0 otherwise.")})});
    public static final Schema SCHEMA_2 = new Schema(new Field[]{new Field("partition_id", (Type)Type.INT32, "The partition id."), new Field("topic_id", (Type)Type.UUID, "The unique ID of this topic."), new Field("replicas", (Type)new CompactArrayOf((Type)Type.INT32), "The replicas of this partition, sorted by preferred order."), new Field("isr", (Type)new CompactArrayOf((Type)Type.INT32), "The in-sync replicas of this partition"), new Field("removing_replicas", (Type)new CompactArrayOf((Type)Type.INT32), "The replicas that we are in the process of removing."), new Field("adding_replicas", (Type)new CompactArrayOf((Type)Type.INT32), "The replicas that we are in the process of adding."), new Field("leader", (Type)Type.INT32, "The lead replica, or -1 if there is no leader."), new Field("leader_epoch", (Type)Type.INT32, "The epoch of the partition leader."), new Field("partition_epoch", (Type)Type.INT32, "An epoch that gets incremented each time we change anything in the partition."), new Field("directories", (Type)new CompactArrayOf((Type)Type.UUID), "The log directory hosting each replica, sorted in the same exact order as the Replicas field."), Field.TaggedFieldsSection.of((Object[])new Object[]{0, new Field("leader_recovery_state", (Type)Type.INT8, "1 if the partition is recovering from an unclean leader election; 0 otherwise."), 1, new Field("eligible_leader_replicas", (Type)CompactArrayOf.nullable((Type)Type.INT32), "The eligible leader replicas of this partition."), 2, new Field("last_known_elr", (Type)CompactArrayOf.nullable((Type)Type.INT32), "The last known eligible leader replicas of this partition.")})});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 2;

    public PartitionRecord(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public PartitionRecord() {
        this.partitionId = -1;
        this.topicId = Uuid.ZERO_UUID;
        this.replicas = new ArrayList<Integer>(0);
        this.isr = new ArrayList<Integer>(0);
        this.removingReplicas = new ArrayList<Integer>(0);
        this.addingReplicas = new ArrayList<Integer>(0);
        this.leader = -1;
        this.leaderRecoveryState = 0;
        this.leaderEpoch = -1;
        this.partitionEpoch = -1;
        this.directories = new ArrayList<Uuid>(0);
        this.eligibleLeaderReplicas = null;
        this.lastKnownElr = null;
    }

    public short apiKey() {
        return 3;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 2;
    }

    public final void read(Readable _readable, short _version) {
        int i;
        this.partitionId = _readable.readInt();
        this.topicId = _readable.readUuid();
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field replicas was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            newCollection.add(_readable.readInt());
        }
        this.replicas = newCollection;
        arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field isr was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        newCollection = new ArrayList(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            newCollection.add(_readable.readInt());
        }
        this.isr = newCollection;
        arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field removingReplicas was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        newCollection = new ArrayList(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            newCollection.add(_readable.readInt());
        }
        this.removingReplicas = newCollection;
        arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field addingReplicas was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        newCollection = new ArrayList(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            newCollection.add(_readable.readInt());
        }
        this.addingReplicas = newCollection;
        this.leader = _readable.readInt();
        this.leaderRecoveryState = 0;
        this.leaderEpoch = _readable.readInt();
        this.partitionEpoch = _readable.readInt();
        if (_version >= 1) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field directories was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add((Integer)_readable.readUuid());
            }
            this.directories = newCollection;
        } else {
            this.directories = new ArrayList<Uuid>(0);
        }
        this.eligibleLeaderReplicas = null;
        this.lastKnownElr = null;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        block10: for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                case 0: {
                    this.leaderRecoveryState = _readable.readByte();
                    continue block10;
                }
                case 1: {
                    int i2;
                    ArrayList<Integer> newCollection2;
                    int arrayLength2;
                    if (_version >= 2) {
                        arrayLength2 = _readable.readUnsignedVarint() - 1;
                        if (arrayLength2 < 0) {
                            this.eligibleLeaderReplicas = null;
                            continue block10;
                        }
                        if (arrayLength2 > _readable.remaining()) {
                            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength2 + ", but there are only " + _readable.remaining() + " bytes remaining.");
                        }
                        newCollection2 = new ArrayList<Integer>(arrayLength2);
                        for (i2 = 0; i2 < arrayLength2; ++i2) {
                            newCollection2.add(_readable.readInt());
                        }
                        this.eligibleLeaderReplicas = newCollection2;
                        continue block10;
                    }
                    throw new RuntimeException("Tag 1 is not valid for version " + _version);
                }
                case 2: {
                    int i2;
                    ArrayList<Integer> newCollection2;
                    int arrayLength2;
                    if (_version >= 2) {
                        arrayLength2 = _readable.readUnsignedVarint() - 1;
                        if (arrayLength2 < 0) {
                            this.lastKnownElr = null;
                            continue block10;
                        }
                        if (arrayLength2 > _readable.remaining()) {
                            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength2 + ", but there are only " + _readable.remaining() + " bytes remaining.");
                        }
                        newCollection2 = new ArrayList(arrayLength2);
                        for (i2 = 0; i2 < arrayLength2; ++i2) {
                            newCollection2.add(_readable.readInt());
                        }
                        this.lastKnownElr = newCollection2;
                        continue block10;
                    }
                    throw new RuntimeException("Tag 2 is not valid for version " + _version);
                }
                default: {
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.partitionId);
        _writable.writeUuid(this.topicId);
        _writable.writeUnsignedVarint(this.replicas.size() + 1);
        for (Integer replicasElement : this.replicas) {
            _writable.writeInt(replicasElement.intValue());
        }
        _writable.writeUnsignedVarint(this.isr.size() + 1);
        for (Integer isrElement : this.isr) {
            _writable.writeInt(isrElement.intValue());
        }
        _writable.writeUnsignedVarint(this.removingReplicas.size() + 1);
        for (Integer removingReplicasElement : this.removingReplicas) {
            _writable.writeInt(removingReplicasElement.intValue());
        }
        _writable.writeUnsignedVarint(this.addingReplicas.size() + 1);
        for (Integer addingReplicasElement : this.addingReplicas) {
            _writable.writeInt(addingReplicasElement.intValue());
        }
        _writable.writeInt(this.leader);
        if (this.leaderRecoveryState != 0) {
            ++_numTaggedFields;
        }
        _writable.writeInt(this.leaderEpoch);
        _writable.writeInt(this.partitionEpoch);
        if (_version >= 1) {
            _writable.writeUnsignedVarint(this.directories.size() + 1);
            for (Uuid directoriesElement : this.directories) {
                _writable.writeUuid(directoriesElement);
            }
        } else if (!this.directories.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default directories at version " + _version);
        }
        if (_version >= 2) {
            if (this.eligibleLeaderReplicas != null) {
                ++_numTaggedFields;
            }
        } else if (this.eligibleLeaderReplicas != null) {
            throw new UnsupportedVersionException("Attempted to write a non-default eligibleLeaderReplicas at version " + _version);
        }
        if (_version >= 2) {
            if (this.lastKnownElr != null) {
                ++_numTaggedFields;
            }
        } else if (this.lastKnownElr != null) {
            throw new UnsupportedVersionException("Attempted to write a non-default lastKnownElr at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        if (this.leaderRecoveryState != 0) {
            _writable.writeUnsignedVarint(0);
            _writable.writeUnsignedVarint(1);
            _writable.writeByte(this.leaderRecoveryState);
        }
        if (_version >= 2 && this.eligibleLeaderReplicas != null) {
            _writable.writeUnsignedVarint(1);
            _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.eligibleLeaderReplicas).intValue());
            _writable.writeUnsignedVarint(this.eligibleLeaderReplicas.size() + 1);
            for (Integer eligibleLeaderReplicasElement : this.eligibleLeaderReplicas) {
                _writable.writeInt(eligibleLeaderReplicasElement.intValue());
            }
        }
        if (_version >= 2 && this.lastKnownElr != null) {
            _writable.writeUnsignedVarint(2);
            _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.lastKnownElr).intValue());
            _writable.writeUnsignedVarint(this.lastKnownElr.size() + 1);
            for (Integer lastKnownElrElement : this.lastKnownElr) {
                _writable.writeInt(lastKnownElrElement.intValue());
            }
        }
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _arraySize;
        int _sizeBeforeArray;
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(16);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.replicas.size() + 1)));
        _size.addBytes(this.replicas.size() * 4);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.isr.size() + 1)));
        _size.addBytes(this.isr.size() * 4);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.removingReplicas.size() + 1)));
        _size.addBytes(this.removingReplicas.size() * 4);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.addingReplicas.size() + 1)));
        _size.addBytes(this.addingReplicas.size() * 4);
        _size.addBytes(4);
        if (this.leaderRecoveryState != 0) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _size.addBytes(1);
            _size.addBytes(1);
        }
        _size.addBytes(4);
        _size.addBytes(4);
        if (_version >= 1) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.directories.size() + 1)));
            _size.addBytes(this.directories.size() * 16);
        }
        if (_version >= 2 && this.eligibleLeaderReplicas != null) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _sizeBeforeArray = _size.totalSize();
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.eligibleLeaderReplicas.size() + 1)));
            _size.addBytes(this.eligibleLeaderReplicas.size() * 4);
            _arraySize = _size.totalSize() - _sizeBeforeArray;
            _cache.setArraySizeInBytes(this.eligibleLeaderReplicas, Integer.valueOf(_arraySize));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_arraySize));
        }
        if (_version >= 2 && this.lastKnownElr != null) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _sizeBeforeArray = _size.totalSize();
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.lastKnownElr.size() + 1)));
            _size.addBytes(this.lastKnownElr.size() * 4);
            _arraySize = _size.totalSize() - _sizeBeforeArray;
            _cache.setArraySizeInBytes(this.lastKnownElr, Integer.valueOf(_arraySize));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_arraySize));
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PartitionRecord)) {
            return false;
        }
        PartitionRecord other = (PartitionRecord)obj;
        if (this.partitionId != other.partitionId) {
            return false;
        }
        if (!this.topicId.equals((Object)other.topicId)) {
            return false;
        }
        if (this.replicas == null ? other.replicas != null : !this.replicas.equals(other.replicas)) {
            return false;
        }
        if (this.isr == null ? other.isr != null : !this.isr.equals(other.isr)) {
            return false;
        }
        if (this.removingReplicas == null ? other.removingReplicas != null : !this.removingReplicas.equals(other.removingReplicas)) {
            return false;
        }
        if (this.addingReplicas == null ? other.addingReplicas != null : !this.addingReplicas.equals(other.addingReplicas)) {
            return false;
        }
        if (this.leader != other.leader) {
            return false;
        }
        if (this.leaderRecoveryState != other.leaderRecoveryState) {
            return false;
        }
        if (this.leaderEpoch != other.leaderEpoch) {
            return false;
        }
        if (this.partitionEpoch != other.partitionEpoch) {
            return false;
        }
        if (this.directories == null ? other.directories != null : !this.directories.equals(other.directories)) {
            return false;
        }
        if (this.eligibleLeaderReplicas == null ? other.eligibleLeaderReplicas != null : !this.eligibleLeaderReplicas.equals(other.eligibleLeaderReplicas)) {
            return false;
        }
        if (this.lastKnownElr == null ? other.lastKnownElr != null : !this.lastKnownElr.equals(other.lastKnownElr)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.partitionId;
        hashCode = 31 * hashCode + this.topicId.hashCode();
        hashCode = 31 * hashCode + (this.replicas == null ? 0 : this.replicas.hashCode());
        hashCode = 31 * hashCode + (this.isr == null ? 0 : this.isr.hashCode());
        hashCode = 31 * hashCode + (this.removingReplicas == null ? 0 : this.removingReplicas.hashCode());
        hashCode = 31 * hashCode + (this.addingReplicas == null ? 0 : this.addingReplicas.hashCode());
        hashCode = 31 * hashCode + this.leader;
        hashCode = 31 * hashCode + this.leaderRecoveryState;
        hashCode = 31 * hashCode + this.leaderEpoch;
        hashCode = 31 * hashCode + this.partitionEpoch;
        hashCode = 31 * hashCode + (this.directories == null ? 0 : this.directories.hashCode());
        hashCode = 31 * hashCode + (this.eligibleLeaderReplicas == null ? 0 : this.eligibleLeaderReplicas.hashCode());
        hashCode = 31 * hashCode + (this.lastKnownElr == null ? 0 : this.lastKnownElr.hashCode());
        return hashCode;
    }

    public PartitionRecord duplicate() {
        PartitionRecord _duplicate = new PartitionRecord();
        _duplicate.partitionId = this.partitionId;
        _duplicate.topicId = this.topicId;
        ArrayList<Integer> newReplicas = new ArrayList<Integer>(this.replicas.size());
        for (Integer n : this.replicas) {
            newReplicas.add(n);
        }
        _duplicate.replicas = newReplicas;
        ArrayList<Integer> newIsr = new ArrayList<Integer>(this.isr.size());
        for (Integer n : this.isr) {
            newIsr.add(n);
        }
        _duplicate.isr = newIsr;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.removingReplicas.size());
        for (Integer n : this.removingReplicas) {
            arrayList.add(n);
        }
        _duplicate.removingReplicas = arrayList;
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>(this.addingReplicas.size());
        for (Integer n : this.addingReplicas) {
            arrayList2.add(n);
        }
        _duplicate.addingReplicas = arrayList2;
        _duplicate.leader = this.leader;
        _duplicate.leaderRecoveryState = this.leaderRecoveryState;
        _duplicate.leaderEpoch = this.leaderEpoch;
        _duplicate.partitionEpoch = this.partitionEpoch;
        ArrayList<Uuid> arrayList3 = new ArrayList<Uuid>(this.directories.size());
        for (Uuid _element : this.directories) {
            arrayList3.add(_element);
        }
        _duplicate.directories = arrayList3;
        if (this.eligibleLeaderReplicas == null) {
            _duplicate.eligibleLeaderReplicas = null;
        } else {
            ArrayList<Integer> arrayList4 = new ArrayList<Integer>(this.eligibleLeaderReplicas.size());
            for (Integer _element : this.eligibleLeaderReplicas) {
                arrayList4.add(_element);
            }
            _duplicate.eligibleLeaderReplicas = arrayList4;
        }
        if (this.lastKnownElr == null) {
            _duplicate.lastKnownElr = null;
        } else {
            ArrayList<Integer> arrayList5 = new ArrayList<Integer>(this.lastKnownElr.size());
            for (Integer _element : this.lastKnownElr) {
                arrayList5.add(_element);
            }
            _duplicate.lastKnownElr = arrayList5;
        }
        return _duplicate;
    }

    public String toString() {
        return "PartitionRecord(partitionId=" + this.partitionId + ", topicId=" + this.topicId.toString() + ", replicas=" + MessageUtil.deepToString(this.replicas.iterator()) + ", isr=" + MessageUtil.deepToString(this.isr.iterator()) + ", removingReplicas=" + MessageUtil.deepToString(this.removingReplicas.iterator()) + ", addingReplicas=" + MessageUtil.deepToString(this.addingReplicas.iterator()) + ", leader=" + this.leader + ", leaderRecoveryState=" + this.leaderRecoveryState + ", leaderEpoch=" + this.leaderEpoch + ", partitionEpoch=" + this.partitionEpoch + ", directories=" + MessageUtil.deepToString(this.directories.iterator()) + ", eligibleLeaderReplicas=" + (this.eligibleLeaderReplicas == null ? "null" : MessageUtil.deepToString(this.eligibleLeaderReplicas.iterator())) + ", lastKnownElr=" + (this.lastKnownElr == null ? "null" : MessageUtil.deepToString(this.lastKnownElr.iterator())) + ")";
    }

    public int partitionId() {
        return this.partitionId;
    }

    public Uuid topicId() {
        return this.topicId;
    }

    public List<Integer> replicas() {
        return this.replicas;
    }

    public List<Integer> isr() {
        return this.isr;
    }

    public List<Integer> removingReplicas() {
        return this.removingReplicas;
    }

    public List<Integer> addingReplicas() {
        return this.addingReplicas;
    }

    public int leader() {
        return this.leader;
    }

    public byte leaderRecoveryState() {
        return this.leaderRecoveryState;
    }

    public int leaderEpoch() {
        return this.leaderEpoch;
    }

    public int partitionEpoch() {
        return this.partitionEpoch;
    }

    public List<Uuid> directories() {
        return this.directories;
    }

    public List<Integer> eligibleLeaderReplicas() {
        return this.eligibleLeaderReplicas;
    }

    public List<Integer> lastKnownElr() {
        return this.lastKnownElr;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public PartitionRecord setPartitionId(int v) {
        this.partitionId = v;
        return this;
    }

    public PartitionRecord setTopicId(Uuid v) {
        this.topicId = v;
        return this;
    }

    public PartitionRecord setReplicas(List<Integer> v) {
        this.replicas = v;
        return this;
    }

    public PartitionRecord setIsr(List<Integer> v) {
        this.isr = v;
        return this;
    }

    public PartitionRecord setRemovingReplicas(List<Integer> v) {
        this.removingReplicas = v;
        return this;
    }

    public PartitionRecord setAddingReplicas(List<Integer> v) {
        this.addingReplicas = v;
        return this;
    }

    public PartitionRecord setLeader(int v) {
        this.leader = v;
        return this;
    }

    public PartitionRecord setLeaderRecoveryState(byte v) {
        this.leaderRecoveryState = v;
        return this;
    }

    public PartitionRecord setLeaderEpoch(int v) {
        this.leaderEpoch = v;
        return this;
    }

    public PartitionRecord setPartitionEpoch(int v) {
        this.partitionEpoch = v;
        return this;
    }

    public PartitionRecord setDirectories(List<Uuid> v) {
        this.directories = v;
        return this;
    }

    public PartitionRecord setEligibleLeaderReplicas(List<Integer> v) {
        this.eligibleLeaderReplicas = v;
        return this;
    }

    public PartitionRecord setLastKnownElr(List<Integer> v) {
        this.lastKnownElr = v;
        return this;
    }
}

