/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.query;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.streams.query.Query;
import org.apache.kafka.streams.state.VersionedRecord;

@InterfaceStability.Evolving
public final class VersionedKeyQuery<K, V>
implements Query<VersionedRecord<V>> {
    private final K key;
    private final Optional<Instant> asOfTimestamp;

    private VersionedKeyQuery(K key, Optional<Instant> asOfTimestamp) {
        this.key = key;
        this.asOfTimestamp = asOfTimestamp;
    }

    public static <K, V> VersionedKeyQuery<K, V> withKey(K key) {
        Objects.requireNonNull(key, "key cannot be null.");
        return new VersionedKeyQuery<K, V>(key, Optional.empty());
    }

    public VersionedKeyQuery<K, V> asOf(Instant asOfTimestamp) {
        Objects.requireNonNull(asOfTimestamp, "asOf timestamp cannot be null.");
        return new VersionedKeyQuery<K, V>(this.key, Optional.of(asOfTimestamp));
    }

    public K key() {
        return this.key;
    }

    public Optional<Instant> asOfTimestamp() {
        return this.asOfTimestamp;
    }
}

