/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.streams.errors.DeserializationExceptionHandler;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.errors.internals.DefaultErrorHandlerContext;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.SourceNode;
import org.slf4j.Logger;

public class RecordDeserializer {
    private final Logger log;
    private final SourceNode<?, ?> sourceNode;
    private final Sensor droppedRecordsSensor;
    private final DeserializationExceptionHandler deserializationExceptionHandler;

    RecordDeserializer(SourceNode<?, ?> sourceNode, DeserializationExceptionHandler deserializationExceptionHandler, LogContext logContext, Sensor droppedRecordsSensor) {
        this.sourceNode = sourceNode;
        this.deserializationExceptionHandler = deserializationExceptionHandler;
        this.log = logContext.logger(RecordDeserializer.class);
        this.droppedRecordsSensor = droppedRecordsSensor;
    }

    ConsumerRecord<Object, Object> deserialize(ProcessorContext<?, ?> processorContext, ConsumerRecord<byte[], byte[]> rawRecord) {
        try {
            return new ConsumerRecord(rawRecord.topic(), rawRecord.partition(), rawRecord.offset(), rawRecord.timestamp(), TimestampType.CREATE_TIME, rawRecord.serializedKeySize(), rawRecord.serializedValueSize(), this.sourceNode.deserializeKey(rawRecord.topic(), rawRecord.headers(), (byte[])rawRecord.key()), this.sourceNode.deserializeValue(rawRecord.topic(), rawRecord.headers(), (byte[])rawRecord.value()), rawRecord.headers(), Optional.empty());
        }
        catch (Exception deserializationException) {
            RecordDeserializer.handleDeserializationFailure(this.deserializationExceptionHandler, processorContext, deserializationException, rawRecord, this.log, this.droppedRecordsSensor, this.sourceNode().name());
            return null;
        }
    }

    public static void handleDeserializationFailure(DeserializationExceptionHandler deserializationExceptionHandler, ProcessorContext<?, ?> processorContext, Exception deserializationException, ConsumerRecord<byte[], byte[]> rawRecord, Logger log, Sensor droppedRecordsSensor, String sourceNodeName) {
        DeserializationExceptionHandler.DeserializationHandlerResponse response;
        DefaultErrorHandlerContext errorHandlerContext = new DefaultErrorHandlerContext((InternalProcessorContext)processorContext, rawRecord.topic(), rawRecord.partition(), rawRecord.offset(), rawRecord.headers(), sourceNodeName, processorContext.taskId(), rawRecord.timestamp());
        try {
            response = Objects.requireNonNull(deserializationExceptionHandler.handle(errorHandlerContext, rawRecord, deserializationException), "Invalid DeserializationExceptionHandler response.");
        }
        catch (Exception fatalUserException) {
            log.error("Deserialization error callback failed after deserialization error for record {}", rawRecord, (Object)deserializationException);
            throw new StreamsException("Fatal user code error in deserialization error callback", fatalUserException);
        }
        if (response == DeserializationExceptionHandler.DeserializationHandlerResponse.FAIL) {
            throw new StreamsException("Deserialization exception handler is set to fail upon a deserialization error. If you would rather have the streaming pipeline continue after a deserialization error, please set the default.deserialization.exception.handler appropriately.", deserializationException);
        }
        log.warn("Skipping record due to deserialization error. topic=[{}] partition=[{}] offset=[{}]", new Object[]{rawRecord.topic(), rawRecord.partition(), rawRecord.offset(), deserializationException});
        droppedRecordsSensor.record();
    }

    SourceNode<?, ?> sourceNode() {
        return this.sourceNode;
    }
}

