/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.assertions;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.juneau.assertions.Assertion;
import org.apache.juneau.assertions.FluentAnyAssertion;
import org.apache.juneau.assertions.FluentIntegerAssertion;
import org.apache.juneau.assertions.FluentListAssertion;
import org.apache.juneau.assertions.FluentObjectAssertion;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.Messages;

public class FluentMapAssertion<K, V, R>
extends FluentObjectAssertion<Map<K, V>, R> {
    private static final Messages MESSAGES = Messages.of(FluentMapAssertion.class, (String)"Messages");
    private static final String MSG_mapWasNotEmpty = MESSAGES.getString("mapWasNotEmpty");
    private static final String MSG_mapDidNotContainExpectedKey = MESSAGES.getString("mapDidNotContainExpectedKey");
    private static final String MSG_mapContainedUnexpectedKey = MESSAGES.getString("mapContainedUnexpectedKey");
    private static final String MSG_mapWasEmpty = MESSAGES.getString("mapWasEmpty");
    private static final String MSG_mapDidNotHaveTheExpectedSize = MESSAGES.getString("mapDidNotHaveTheExpectedSize");

    public FluentMapAssertion(Assertion creator, Map<K, V> value, R returns) {
        super(creator, value, returns);
    }

    public FluentMapAssertion(Map<K, V> value, R returns) {
        this((Assertion)null, value, returns);
    }

    public FluentIntegerAssertion<R> asSize() {
        return new FluentIntegerAssertion((Assertion)this, this.valueIsNull() ? null : Integer.valueOf(((Map)this.value()).size()), this.returns());
    }

    public FluentMapAssertion<K, V, R> asTransformed(Function<Map<K, V>, Map<K, V>> function) {
        return new FluentMapAssertion((Assertion)this, function.apply(this.orElse(null)), this.returns());
    }

    public FluentAnyAssertion<V, R> asValue(K key) {
        return new FluentAnyAssertion(this, this.get(key), this.returns());
    }

    public FluentMapAssertion<K, V, R> asValueMap(K ... keys) {
        if (this.valueIsNull()) {
            return new FluentMapAssertion((Assertion)this, null, this.returns());
        }
        Map m1 = (Map)this.value();
        LinkedHashMap m2 = CollectionUtils.map();
        if (Utils.nn((Object)m1)) {
            for (K k : keys) {
                m2.put(k, m1.get(k));
            }
        }
        return new FluentMapAssertion((Assertion)this, m2, this.returns());
    }

    public FluentListAssertion<Object, R> asValues(K ... keys) {
        return new FluentListAssertion((Assertion)this, this.valueIsNull() ? null : Arrays.stream(keys).map(this::get).collect(Collectors.toList()), this.returns());
    }

    public R isContainsKey(String name) throws AssertionError {
        if (((Map)this.value()).containsKey(name)) {
            return this.returns();
        }
        throw this.error(MSG_mapDidNotContainExpectedKey, name, this.value());
    }

    public R isEmpty() throws AssertionError {
        if (!((Map)this.value()).isEmpty()) {
            throw this.error(MSG_mapWasNotEmpty, new Object[0]);
        }
        return this.returns();
    }

    public R isNotContainsKey(String name) throws AssertionError {
        if (!((Map)this.value()).containsKey(name)) {
            return this.returns();
        }
        throw this.error(MSG_mapContainedUnexpectedKey, name, this.value());
    }

    public R isNotEmpty() throws AssertionError {
        if (((Map)this.value()).isEmpty()) {
            throw this.error(MSG_mapWasEmpty, new Object[0]);
        }
        return this.returns();
    }

    public R isSize(int size) throws AssertionError {
        if (this.size2() != size) {
            throw this.error(MSG_mapDidNotHaveTheExpectedSize, size, this.size2());
        }
        return this.returns();
    }

    @Override
    public FluentMapAssertion<K, V, R> setMsg(String msg, Object ... args) {
        super.setMsg(msg, args);
        return this;
    }

    @Override
    public FluentMapAssertion<K, V, R> setOut(PrintStream value) {
        super.setOut(value);
        return this;
    }

    @Override
    public FluentMapAssertion<K, V, R> setSilent() {
        super.setSilent();
        return this;
    }

    @Override
    public FluentMapAssertion<K, V, R> setStdOut() {
        super.setStdOut();
        return this;
    }

    @Override
    public FluentMapAssertion<K, V, R> setThrowable(Class<? extends RuntimeException> value) {
        super.setThrowable((Class)value);
        return this;
    }

    private V get(K key) {
        return this.orElse(Collections.emptyMap()).get(key);
    }

    private int size2() {
        return ((Map)this.value()).size();
    }
}

