/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;

@Bean(sort=true)
public class Namespace {
    private static final ConcurrentHashMap<String, Namespace> CACHE = new ConcurrentHashMap();
    final String key;
    final String name;
    final String uri;

    public static Namespace create(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Namespace) {
            Namespace o2 = (Namespace)o;
            return o2;
        }
        if (o instanceof CharSequence) {
            CharSequence o3 = (CharSequence)o;
            return Namespace.of(o3.toString());
        }
        throw ThrowableUtils.rex("Invalid object type passed to Namespace.create(Object):  ''{0}''", Utils.cn(o));
    }

    public static Namespace[] createArray(Object o) {
        if (o instanceof Namespace[]) {
            return (Namespace[])o;
        }
        if (o instanceof String[]) {
            String[] ss = (String[])o;
            Namespace[] n = new Namespace[ss.length];
            for (int i = 0; i < ss.length; ++i) {
                n[i] = Namespace.create(ss[i]);
            }
            return n;
        }
        if (o instanceof CharSequence) {
            CharSequence o2 = (CharSequence)o;
            String[] ss = StringUtils.splita(o2.toString());
            Namespace[] n = new Namespace[ss.length];
            for (int i = 0; i < ss.length; ++i) {
                n[i] = Namespace.create(ss[i]);
            }
            return n;
        }
        if (o instanceof Collection) {
            Collection o2 = (Collection)o;
            Namespace[] n = new Namespace[o2.size()];
            int i = 0;
            for (Object o3 : o2) {
                if (o3 instanceof Namespace) {
                    Namespace o4 = (Namespace)o3;
                    n[i++] = o4;
                    continue;
                }
                if (o3 instanceof CharSequence) {
                    CharSequence o4 = (CharSequence)o3;
                    n[i++] = Namespace.create(o4.toString());
                    continue;
                }
                throw ThrowableUtils.rex("Invalid type passed to NamespaceFactory.createArray: ''{0}''", Utils.cn(o));
            }
            return n;
        }
        throw ThrowableUtils.rex("Invalid type passed to NamespaceFactory.createArray: ''{0}''", Utils.cn(o));
    }

    public static Namespace of(String key) {
        Namespace n = CACHE.get(key);
        if (Utils.nn(n)) {
            return n;
        }
        int i = key.indexOf(58);
        if (i == -1) {
            return Namespace.of(key, null);
        }
        if (key.startsWith("http://") || key.startsWith("https://")) {
            return Namespace.of(null, key);
        }
        return Namespace.of(key.substring(0, i).trim(), key.substring(i + 1).trim());
    }

    public static Namespace of(String name, String uri) {
        String key = name + ":" + uri;
        Namespace n = CACHE.get(key);
        if (n == null) {
            n = new Namespace(key, name, uri);
            Namespace n2 = CACHE.putIfAbsent(key, n);
            return n2 == null ? n : n2;
        }
        return n;
    }

    private Namespace(String key, String name, String uri) {
        this.key = key;
        this.name = name;
        this.uri = uri;
    }

    public String getName() {
        return this.name;
    }

    public String getUri() {
        return this.uri;
    }

    public String toString() {
        return this.key;
    }
}

