/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.header.BasicCsvHeader;

@Header(value="Thrown")
public class Thrown
extends BasicCsvHeader {
    private static final long serialVersionUID = 1L;
    private static final String NAME = "Thrown";
    public static final Thrown EMPTY = new Thrown((String)null);
    private final List<Part> value;

    public static Thrown of(String value) {
        return value == null ? null : new Thrown(value);
    }

    public static Thrown of(Throwable ... values) {
        return new Thrown(CollectionUtils.l((Object[])values).stream().map(Part::new).collect(Collectors.toList()));
    }

    public Thrown(List<Part> value) {
        super(NAME, StringUtils.join(value, (String)", "));
        this.value = CollectionUtils.u(value);
    }

    public Thrown(String value) {
        super(NAME, value);
        List l = CollectionUtils.list((Object[])new Part[0]);
        StringUtils.split((String)value, x -> l.add(new Part((String)x)));
        this.value = value == null ? null : CollectionUtils.u((List)l);
    }

    public Optional<List<Part>> asParts() {
        return Utils.opt(this.value);
    }

    public static class Part {
        String className;
        String message;
        String value;

        public Part(String value) {
            this.value = value;
            int i = value.indexOf(59);
            this.className = StringUtils.urlDecode((String)(i == -1 ? value.trim() : value.substring(0, i).trim()));
            this.message = StringUtils.urlDecode(i == -1 ? null : value.substring(i + 1).trim());
        }

        public Part(Throwable value) {
            this.className = Utils.cn((Object)value);
            this.message = value.getMessage();
            this.value = StringUtils.urlEncode((String)this.className) + ";" + StringUtils.urlEncode((String)value.getMessage());
        }

        public String getClassName() {
            return this.className;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            return this.value;
        }
    }
}

