/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.cp;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.io.LocalDir;
import org.apache.juneau.commons.io.LocalFile;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.FileUtils;
import org.apache.juneau.commons.utils.IoUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.FileFinder;

public class BasicFileFinder
implements FileFinder {
    private static final ResourceBundle.Control RB_CONTROL = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_DEFAULT);
    private final Map<String, LocalFile> files = new ConcurrentHashMap<String, LocalFile>();
    private final Map<Locale, Map<String, LocalFile>> localizedFiles = new ConcurrentHashMap<Locale, Map<String, LocalFile>>();
    private final LocalDir[] roots;
    private final long cachingLimit;
    private final Pattern[] include;
    private final Pattern[] exclude;
    private final String[] includePatterns;
    private final String[] excludePatterns;
    private final int hashCode;

    public BasicFileFinder(FileFinder.Builder builder) {
        this.roots = builder.roots.toArray(new LocalDir[builder.roots.size()]);
        this.cachingLimit = builder.cachingLimit;
        this.include = builder.include;
        this.exclude = builder.exclude;
        this.includePatterns = (String[])CollectionUtils.l((Object[])this.include).stream().map(Pattern::pattern).toArray(String[]::new);
        this.excludePatterns = (String[])CollectionUtils.l((Object[])this.exclude).stream().map(Pattern::pattern).toArray(String[]::new);
        this.hashCode = Utils.h((Object[])new Object[]{this.getClass(), this.roots, this.cachingLimit, this.includePatterns, this.excludePatterns});
    }

    protected BasicFileFinder() {
        this.roots = new LocalDir[0];
        this.cachingLimit = -1L;
        this.include = new Pattern[0];
        this.exclude = new Pattern[0];
        this.includePatterns = new String[0];
        this.excludePatterns = new String[0];
        this.hashCode = Utils.h((Object[])new Object[]{this.getClass(), this.roots, this.cachingLimit, this.includePatterns, this.excludePatterns});
    }

    public boolean equals(Object o) {
        BasicFileFinder o2;
        return o instanceof BasicFileFinder && Utils.eq((Object)this, (Object)(o2 = (BasicFileFinder)o), (x, y) -> Utils.eq((Object)x.hashCode, (Object)y.hashCode) && Utils.eq(x.getClass(), y.getClass()) && Utils.eq((Object)x.roots, (Object)y.roots) && Utils.eq((Object)x.cachingLimit, (Object)y.cachingLimit) && Utils.eq((Object)x.includePatterns, (Object)y.includePatterns) && Utils.eq((Object)x.excludePatterns, (Object)y.excludePatterns));
    }

    @Override
    public final Optional<InputStream> getStream(String name, Locale locale) throws IOException {
        return this.find(name, locale);
    }

    @Override
    public Optional<String> getString(String name, Locale locale) throws IOException {
        return Utils.opt((Object)IoUtils.read((InputStream)this.find(name, locale).orElse(null)));
    }

    public int hashCode() {
        return this.hashCode;
    }

    protected FluentMap<String, Object> properties() {
        return CollectionUtils.filteredBeanPropertyMap().a((Object)"cachingLimit", (Object)this.cachingLimit).a((Object)"class", (Object)Utils.cns(this.getClass())).a((Object)"exclude", (Object)this.excludePatterns).a((Object)"include", (Object)this.includePatterns).a((Object)"roots", (Object)this.roots).a((Object)"hashCode", (Object)this.hashCode);
    }

    public String toString() {
        return Utils.r(this.properties());
    }

    protected Optional<InputStream> find(String name, Locale locale) throws IOException {
        Map<String, LocalFile> fileCache;
        LocalFile lf;
        if (this.isInvalidPath(name = StringUtils.trimSlashesAndSpaces((String)name))) {
            return Utils.opte();
        }
        if (Utils.nn((Object)locale)) {
            this.localizedFiles.putIfAbsent(locale, new ConcurrentHashMap());
        }
        if ((lf = (fileCache = locale == null ? this.files : this.localizedFiles.get(locale)).get(name)) == null) {
            List<String> candidateFileNames = this.getCandidateFileNames(name, locale);
            block0: for (LocalDir root : this.roots) {
                for (String cfn : candidateFileNames) {
                    lf = root.resolve(cfn);
                    if (!Utils.nn((Object)lf)) continue;
                    break block0;
                }
            }
            if (Utils.nn((Object)lf) && this.isIgnoredFile(lf.getName())) {
                lf = null;
            }
            if (Utils.nn((Object)lf)) {
                long size;
                fileCache.put(name, lf);
                if (this.cachingLimit >= 0L && (size = lf.size()) > 0L && size <= this.cachingLimit) {
                    lf.cache();
                }
            }
        }
        return Utils.opt((Object)(lf == null ? null : lf.read()));
    }

    protected List<String> getCandidateFileNames(String fileName, Locale locale) {
        if (locale == null) {
            return Collections.singletonList(fileName);
        }
        ArrayList<String> list = new ArrayList<String>();
        String baseName = FileUtils.getBaseName((String)fileName);
        String ext = FileUtils.getFileExtension((String)fileName);
        this.getCandidateLocales(locale).forEach(x -> {
            String ls = x.toString();
            if (ls.isEmpty()) {
                list.add(fileName);
            } else {
                list.add(baseName + "_" + ls + (String)(ext.isEmpty() ? "" : "." + ext));
                list.add(ls.replace('_', '/') + "/" + fileName);
            }
        });
        return list;
    }

    protected List<Locale> getCandidateLocales(Locale locale) {
        return RB_CONTROL.getCandidateLocales("", locale);
    }

    protected boolean isIgnoredFile(String name) {
        for (Pattern p : this.exclude) {
            if (!p.matcher(name).matches()) continue;
            return true;
        }
        for (Pattern p : this.include) {
            if (!p.matcher(name).matches()) continue;
            return false;
        }
        return true;
    }

    protected boolean isInvalidPath(String path) {
        return StringUtils.isEmpty((String)path) || path.contains("..") || path.contains("%");
    }
}

