/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.reflect.ReflectionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.json.Json5Serializer;

public class BeanProxyInvocationHandler<T>
implements InvocationHandler {
    private final BeanMeta<T> meta;
    private Map<String, Object> beanProps;

    public BeanProxyInvocationHandler(BeanMeta<T> meta) {
        this.meta = meta;
        this.beanProps = new HashMap<String, Object>();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        MethodInfo mi = ReflectionUtils.info((Method)method);
        if (mi.hasName("equals") && mi.hasParameterTypes(new Class[]{Object.class})) {
            InvocationHandler ih;
            Object arg = args[0];
            if (arg == null) {
                return false;
            }
            if (proxy == arg) {
                return true;
            }
            if (Utils.eq(proxy.getClass(), arg.getClass()) && (ih = Proxy.getInvocationHandler(arg)) instanceof BeanProxyInvocationHandler) {
                BeanProxyInvocationHandler ih2 = (BeanProxyInvocationHandler)ih;
                return this.beanProps.equals(ih2.beanProps);
            }
            return Utils.eq(this.beanProps, this.meta.getBeanContext().toBeanMap(arg));
        }
        if (mi.hasName("hashCode") && mi.getParameterCount() == 0) {
            return this.beanProps.hashCode();
        }
        if (mi.hasName("toString") && mi.getParameterCount() == 0) {
            return Json5Serializer.DEFAULT.toString(this.beanProps);
        }
        String prop = this.meta.getGetterProps().get(method);
        if (Utils.nn((Object)prop)) {
            return this.beanProps.get(prop);
        }
        prop = this.meta.getSetterProps().get(method);
        if (Utils.nn((Object)prop)) {
            this.beanProps.put(prop, args[0]);
            return null;
        }
        throw ThrowableUtils.unsupportedOp((String)"Unsupported bean method.  method=''{0}''", (Object[])new Object[]{method});
    }
}

