/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.httppart;

import java.util.NoSuchElementException;
import java.util.function.Supplier;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.assertions.FluentObjectAssertion;
import org.apache.juneau.assertions.FluentStringAssertion;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.rest.httppart.NamedAttribute;

@BeanIgnore
public class BasicNamedAttribute
implements NamedAttribute {
    private final String name;
    private final Object value;

    public static BasicNamedAttribute of(String name, Object value) {
        return new BasicNamedAttribute(name, value);
    }

    public static BasicNamedAttribute of(String name, Supplier<?> value) {
        return new BasicNamedAttribute(name, value);
    }

    public static BasicNamedAttribute ofPair(String pair) {
        if (pair == null) {
            return null;
        }
        int i = pair.indexOf(58);
        if (i == -1) {
            i = pair.indexOf(61);
        }
        if (i == -1) {
            return BasicNamedAttribute.of(pair, "");
        }
        return BasicNamedAttribute.of(pair.substring(0, i).trim(), pair.substring(i + 1).trim());
    }

    public BasicNamedAttribute(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    protected BasicNamedAttribute(BasicNamedAttribute copyOf) {
        this.name = copyOf.name;
        this.value = copyOf.value;
    }

    public FluentStringAssertion<BasicNamedAttribute> assertName() {
        return new FluentStringAssertion<BasicNamedAttribute>(this.getName(), this);
    }

    public FluentObjectAssertion<Object, BasicNamedAttribute> assertValue() {
        return new FluentObjectAssertion<Object, BasicNamedAttribute>(this.getValue(), this);
    }

    public Object get() {
        Object o = this.getValue();
        if (o == null) {
            throw new NoSuchElementException();
        }
        return o;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getValue() {
        return BasicNamedAttribute.unwrap(this.value);
    }

    public boolean isPresent() {
        return Utils.nn(this.getValue());
    }

    public Object orElse(Object other) {
        Object o = this.getValue();
        return Utils.nn(o) ? o : other;
    }

    public String toString() {
        return StringUtils.urlEncode(this.getName()) + "=" + String.valueOf(this.getValue());
    }

    private static Object unwrap(Object o) {
        while (o instanceof Supplier) {
            o = ((Supplier)o).get();
        }
        return o;
    }
}

