/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml.bind.gml;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.sis.xml.bind.Context;
import org.apache.sis.xml.util.XmlUtilities;

public final class UniversalTimeAdapter
extends XmlAdapter<XMLGregorianCalendar, Date> {
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");

    @Override
    public Date unmarshal(XMLGregorianCalendar value) {
        return value != null ? XmlUtilities.toDate(Context.current(), value) : null;
    }

    @Override
    public XMLGregorianCalendar marshal(Date value) {
        if (value != null) {
            GregorianCalendar calendar = new GregorianCalendar(UTC, Locale.ROOT);
            calendar.setTime(value);
            try {
                XMLGregorianCalendar gc = XmlUtilities.getDatatypeFactory().newXMLGregorianCalendar(calendar);
                if (gc.getMillisecond() == 0) {
                    gc.setMillisecond(Integer.MIN_VALUE);
                }
                return gc;
            }
            catch (DatatypeConfigurationException e2) {
                Context.warningOccured(Context.current(), XmlAdapter.class, "marshal", e2, true);
            }
        }
        return null;
    }
}

