/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.async;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.async.AsyncTask;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.servlets.ServletOps;

public class AsyncPool {
    private static int nMaxThreads = 4;
    private static int MAX_FINISHED = 20;
    private ExecutorService executor = new ThreadPoolExecutor(0, nMaxThreads, 120L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(true));
    private final Object mutex = new Object();
    private long counter = 0L;
    private Map<String, AsyncTask> runningTasks = new LinkedHashMap<String, AsyncTask>();
    private Map<String, AsyncTask> finishedTasks = new LinkedHashMap<String, AsyncTask>();
    private LinkedList<AsyncTask> finishedTasksList = new LinkedList();
    private static AsyncPool instance = new AsyncPool();

    public static AsyncPool get() {
        return instance;
    }

    private AsyncPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncTask submit(Runnable task, String displayName, DataService dataService, long requestId) {
        Object object = this.mutex;
        synchronized (object) {
            String taskId = Long.toString(++this.counter);
            Fuseki.serverLog.info(String.format("Task : %s : %s", taskId, displayName));
            Callable<Object> c = () -> {
                try {
                    task.run();
                }
                catch (Throwable th) {
                    Fuseki.serverLog.error(String.format("Exception in task %s execution", taskId), th);
                    throw th;
                }
                return null;
            };
            AsyncTask asyncTask = new AsyncTask(c, this, taskId, displayName, dataService, requestId);
            try {
                this.executor.submit(asyncTask);
                this.runningTasks.put(taskId, asyncTask);
                return asyncTask;
            }
            catch (RejectedExecutionException ex) {
                ServletOps.errorBadRequest("Async task request rejected - exceeds the limit of " + nMaxThreads + " tasks");
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<AsyncTask> tasks() {
        Object object = this.mutex;
        synchronized (object) {
            ArrayList<AsyncTask> x = new ArrayList<AsyncTask>(this.runningTasks.size() + this.finishedTasks.size());
            x.addAll(this.runningTasks.values());
            x.addAll(this.finishedTasks.values());
            return x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished(AsyncTask task) {
        Object object = this.mutex;
        synchronized (object) {
            String id = task.getTaskId();
            this.runningTasks.remove(id);
            while (this.finishedTasksList.size() >= MAX_FINISHED) {
                AsyncTask oldTask = this.finishedTasksList.removeFirst();
                this.finishedTasks.remove(oldTask.getTaskId());
            }
            this.finishedTasks.put(id, task);
            this.finishedTasksList.add(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncTask getRunningTask(String taskId) {
        Object object = this.mutex;
        synchronized (object) {
            return this.runningTasks.get(taskId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncTask getTask(String taskId) {
        Object object = this.mutex;
        synchronized (object) {
            AsyncTask task = this.runningTasks.get(taskId);
            if (task != null) {
                return task;
            }
            return this.finishedTasks.get(taskId);
        }
    }
}

