/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.table;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.commons.schema.table.column.AttributeColumnSchema;
import org.apache.iotdb.commons.schema.table.column.TagColumnSchema;
import org.apache.tsfile.enums.TSDataType;

public class InformationSchema {
    public static final String INFORMATION_DATABASE = "information_schema";
    private static final Map<String, TsTable> schemaTables = new HashMap<String, TsTable>();
    public static final String QUERIES = "queries";
    public static final String DATABASES = "databases";
    public static final String TABLES = "tables";
    public static final String COLUMNS = "columns";
    public static final String REGIONS = "regions";
    public static final String PIPES = "pipes";
    public static final String PIPE_PLUGINS = "pipe_plugins";
    public static final String TOPICS = "topics";
    public static final String SUBSCRIPTIONS = "subscriptions";
    public static final String VIEWS = "views";
    public static final String MODELS = "models";
    public static final String FUNCTIONS = "functions";
    public static final String CONFIGURATIONS = "configurations";
    public static final String KEYWORDS = "keywords";
    public static final String NODES = "nodes";
    public static final String CONFIG_NODES = "config_nodes";
    public static final String DATA_NODES = "data_nodes";

    public static Map<String, TsTable> getSchemaTables() {
        return schemaTables;
    }

    private InformationSchema() {
    }

    static {
        TsTable queriesTable = new TsTable(QUERIES);
        queriesTable.addColumnSchema(new TagColumnSchema("query_id", TSDataType.STRING));
        queriesTable.addColumnSchema(new AttributeColumnSchema("start_time", TSDataType.TIMESTAMP));
        queriesTable.addColumnSchema(new AttributeColumnSchema("datanode_id", TSDataType.INT32));
        queriesTable.addColumnSchema(new AttributeColumnSchema("elapsed_time", TSDataType.FLOAT));
        queriesTable.addColumnSchema(new AttributeColumnSchema("Statement".toLowerCase(Locale.ENGLISH), TSDataType.STRING));
        queriesTable.addColumnSchema(new AttributeColumnSchema("User".toLowerCase(Locale.ENGLISH), TSDataType.STRING));
        queriesTable.removeColumnSchema("time");
        schemaTables.put(QUERIES, queriesTable);
        TsTable databaseTable = new TsTable(DATABASES);
        databaseTable.addColumnSchema(new TagColumnSchema("Database".toLowerCase(Locale.ENGLISH), TSDataType.STRING));
        databaseTable.addColumnSchema(new AttributeColumnSchema("TTL(ms)".toLowerCase(Locale.ENGLISH), TSDataType.STRING));
        databaseTable.addColumnSchema(new AttributeColumnSchema("schema_replication_factor", TSDataType.INT32));
        databaseTable.addColumnSchema(new AttributeColumnSchema("data_replication_factor", TSDataType.INT32));
        databaseTable.addColumnSchema(new AttributeColumnSchema("time_partition_interval", TSDataType.INT64));
        databaseTable.addColumnSchema(new AttributeColumnSchema("schema_region_group_num", TSDataType.INT32));
        databaseTable.addColumnSchema(new AttributeColumnSchema("data_region_group_num", TSDataType.INT32));
        databaseTable.removeColumnSchema("time");
        schemaTables.put(DATABASES, databaseTable);
        TsTable tableTable = new TsTable(TABLES);
        tableTable.addColumnSchema(new TagColumnSchema("Database".toLowerCase(Locale.ENGLISH), TSDataType.STRING));
        tableTable.addColumnSchema(new TagColumnSchema("table_name", TSDataType.STRING));
        tableTable.addColumnSchema(new AttributeColumnSchema("TTL(ms)".toLowerCase(Locale.ENGLISH), TSDataType.STRING));
        tableTable.addColumnSchema(new AttributeColumnSchema("Status".toLowerCase(Locale.ENGLISH), TSDataType.STRING));
        tableTable.addColumnSchema(new AttributeColumnSchema("Comment".toLowerCase(Locale.ENGLISH), TSDataType.STRING));
        tableTable.addColumnSchema(new AttributeColumnSchema("table_type", TSDataType.STRING));
        tableTable.removeColumnSchema("time");
        schemaTables.put(TABLES, tableTable);
        TsTable columnTable = new TsTable(COLUMNS);
        columnTable.addColumnSchema(new TagColumnSchema("Database".toLowerCase(Locale.ENGLISH), TSDataType.STRING));
        columnTable.addColumnSchema(new TagColumnSchema("table_name", TSDataType.STRING));
        columnTable.addColumnSchema(new TagColumnSchema("column_name", TSDataType.STRING));
        columnTable.addColumnSchema(new AttributeColumnSchema("DataType".toLowerCase(Locale.ENGLISH), TSDataType.STRING));
        columnTable.addColumnSchema(new AttributeColumnSchema("Category".toLowerCase(Locale.ENGLISH), TSDataType.STRING));
        columnTable.addColumnSchema(new AttributeColumnSchema("Status".toLowerCase(Locale.ENGLISH), TSDataType.STRING));
        columnTable.addColumnSchema(new AttributeColumnSchema("Comment".toLowerCase(Locale.ENGLISH), TSDataType.STRING));
        columnTable.removeColumnSchema("time");
        schemaTables.put(COLUMNS, columnTable);
        TsTable regionTable = new TsTable(REGIONS);
        regionTable.addColumnSchema(new TagColumnSchema("region_id", TSDataType.INT32));
        regionTable.addColumnSchema(new TagColumnSchema("datanode_id", TSDataType.INT32));
        regionTable.addColumnSchema(new AttributeColumnSchema("Type".toLowerCase(Locale.ENGLISH), TSDataType.STRING));
        regionTable.addColumnSchema(new AttributeColumnSchema("Status".toLowerCase(Locale.ENGLISH), TSDataType.STRING));
        regionTable.addColumnSchema(new AttributeColumnSchema("Database".toLowerCase(Locale.ENGLISH), TSDataType.STRING));
        regionTable.addColumnSchema(new AttributeColumnSchema("series_slot_num", TSDataType.INT32));
        regionTable.addColumnSchema(new AttributeColumnSchema("time_slot_num", TSDataType.INT64));
        regionTable.addColumnSchema(new AttributeColumnSchema("rpc_address", TSDataType.STRING));
        regionTable.addColumnSchema(new AttributeColumnSchema("rpc_port", TSDataType.INT32));
        regionTable.addColumnSchema(new AttributeColumnSchema("internal_address", TSDataType.STRING));
        regionTable.addColumnSchema(new AttributeColumnSchema("Role".toLowerCase(Locale.ENGLISH), TSDataType.STRING));
        regionTable.addColumnSchema(new AttributeColumnSchema("create_time", TSDataType.TIMESTAMP));
        regionTable.addColumnSchema(new AttributeColumnSchema("tsfile_size_bytes", TSDataType.INT64));
        regionTable.addColumnSchema(new AttributeColumnSchema("compression_ratio", TSDataType.DOUBLE));
        regionTable.removeColumnSchema("time");
        schemaTables.put(REGIONS, regionTable);
        TsTable pipeTable = new TsTable(PIPES);
        pipeTable.addColumnSchema(new TagColumnSchema("ID".toLowerCase(Locale.ENGLISH), TSDataType.STRING));
        pipeTable.addColumnSchema(new AttributeColumnSchema("creation_time", TSDataType.TIMESTAMP));
        pipeTable.addColumnSchema(new AttributeColumnSchema("State".toLowerCase(Locale.ENGLISH), TSDataType.STRING));
        pipeTable.addColumnSchema(new AttributeColumnSchema("pipe_source", TSDataType.STRING));
        pipeTable.addColumnSchema(new AttributeColumnSchema("pipe_processor", TSDataType.STRING));
        pipeTable.addColumnSchema(new AttributeColumnSchema("pipe_sink", TSDataType.STRING));
        pipeTable.addColumnSchema(new AttributeColumnSchema("exception_message", TSDataType.STRING));
        pipeTable.addColumnSchema(new AttributeColumnSchema("remaining_event_count", TSDataType.INT64));
        pipeTable.addColumnSchema(new AttributeColumnSchema("estimated_remaining_seconds", TSDataType.DOUBLE));
        pipeTable.removeColumnSchema("time");
        schemaTables.put(PIPES, pipeTable);
        TsTable pipePluginTable = new TsTable(PIPE_PLUGINS);
        pipePluginTable.addColumnSchema(new TagColumnSchema("plugin_name", TSDataType.STRING));
        pipePluginTable.addColumnSchema(new AttributeColumnSchema("plugin_type", TSDataType.STRING));
        pipePluginTable.addColumnSchema(new AttributeColumnSchema("class_name", TSDataType.STRING));
        pipePluginTable.addColumnSchema(new AttributeColumnSchema("plugin_jar", TSDataType.STRING));
        pipePluginTable.removeColumnSchema("time");
        schemaTables.put(PIPE_PLUGINS, pipePluginTable);
        TsTable topicTable = new TsTable(TOPICS);
        topicTable.addColumnSchema(new TagColumnSchema("topic_name", TSDataType.STRING));
        topicTable.addColumnSchema(new AttributeColumnSchema("topic_configs", TSDataType.STRING));
        topicTable.removeColumnSchema("time");
        schemaTables.put(TOPICS, topicTable);
        TsTable subscriptionTable = new TsTable(SUBSCRIPTIONS);
        subscriptionTable.addColumnSchema(new TagColumnSchema("topic_name", TSDataType.STRING));
        subscriptionTable.addColumnSchema(new TagColumnSchema("consumer_group_name", TSDataType.STRING));
        subscriptionTable.addColumnSchema(new AttributeColumnSchema("subscribed_consumers", TSDataType.STRING));
        subscriptionTable.removeColumnSchema("time");
        schemaTables.put(SUBSCRIPTIONS, subscriptionTable);
        TsTable viewTable = new TsTable(VIEWS);
        viewTable.addColumnSchema(new TagColumnSchema("Database".toLowerCase(Locale.ENGLISH), TSDataType.STRING));
        viewTable.addColumnSchema(new TagColumnSchema("table_name", TSDataType.STRING));
        viewTable.addColumnSchema(new AttributeColumnSchema("view_definition", TSDataType.STRING));
        viewTable.removeColumnSchema("time");
        schemaTables.put(VIEWS, viewTable);
        TsTable modelTable = new TsTable(MODELS);
        modelTable.addColumnSchema(new TagColumnSchema("model_id", TSDataType.STRING));
        modelTable.addColumnSchema(new AttributeColumnSchema("model_type", TSDataType.STRING));
        modelTable.addColumnSchema(new AttributeColumnSchema("State".toLowerCase(Locale.ENGLISH), TSDataType.STRING));
        modelTable.addColumnSchema(new AttributeColumnSchema("Configs".toLowerCase(Locale.ENGLISH), TSDataType.STRING));
        modelTable.addColumnSchema(new AttributeColumnSchema("Notes".toLowerCase(Locale.ENGLISH), TSDataType.STRING));
        modelTable.removeColumnSchema("time");
        schemaTables.put(MODELS, modelTable);
        TsTable functionTable = new TsTable(FUNCTIONS);
        functionTable.addColumnSchema(new TagColumnSchema("function_table", TSDataType.STRING));
        functionTable.addColumnSchema(new AttributeColumnSchema("function_type", TSDataType.STRING));
        functionTable.addColumnSchema(new AttributeColumnSchema("class_name(udf)", TSDataType.STRING));
        functionTable.addColumnSchema(new AttributeColumnSchema("State".toLowerCase(Locale.ENGLISH), TSDataType.STRING));
        functionTable.removeColumnSchema("time");
        schemaTables.put(FUNCTIONS, functionTable);
        TsTable configurationsTable = new TsTable(CONFIGURATIONS);
        configurationsTable.addColumnSchema(new TagColumnSchema("Variable".toLowerCase(Locale.ENGLISH), TSDataType.STRING));
        configurationsTable.addColumnSchema(new AttributeColumnSchema("Value".toLowerCase(Locale.ENGLISH), TSDataType.STRING));
        configurationsTable.removeColumnSchema("time");
        schemaTables.put(CONFIGURATIONS, configurationsTable);
        TsTable keywordsTable = new TsTable(KEYWORDS);
        keywordsTable.addColumnSchema(new TagColumnSchema("word", TSDataType.STRING));
        keywordsTable.addColumnSchema(new AttributeColumnSchema("reserved", TSDataType.INT32));
        keywordsTable.removeColumnSchema("time");
        schemaTables.put(KEYWORDS, keywordsTable);
        TsTable nodesTable = new TsTable(NODES);
        nodesTable.addColumnSchema(new TagColumnSchema("node_id", TSDataType.INT32));
        nodesTable.addColumnSchema(new AttributeColumnSchema("node_type", TSDataType.STRING));
        nodesTable.addColumnSchema(new AttributeColumnSchema("Status".toLowerCase(Locale.ENGLISH), TSDataType.STRING));
        nodesTable.addColumnSchema(new AttributeColumnSchema("internal_address", TSDataType.STRING));
        nodesTable.addColumnSchema(new AttributeColumnSchema("internal_port", TSDataType.INT32));
        nodesTable.addColumnSchema(new AttributeColumnSchema("Version".toLowerCase(Locale.ENGLISH), TSDataType.STRING));
        nodesTable.addColumnSchema(new AttributeColumnSchema("build_info", TSDataType.STRING));
        nodesTable.removeColumnSchema("time");
        schemaTables.put(NODES, nodesTable);
        TsTable configNodesTable = new TsTable(CONFIG_NODES);
        configNodesTable.addColumnSchema(new TagColumnSchema("node_id", TSDataType.INT32));
        configNodesTable.addColumnSchema(new AttributeColumnSchema("config_consensus_port", TSDataType.INT32));
        configNodesTable.addColumnSchema(new AttributeColumnSchema("Role".toLowerCase(Locale.ENGLISH), TSDataType.STRING));
        configNodesTable.removeColumnSchema("time");
        schemaTables.put(CONFIG_NODES, configNodesTable);
        TsTable dataNodesTable = new TsTable(DATA_NODES);
        dataNodesTable.addColumnSchema(new TagColumnSchema("node_id", TSDataType.INT32));
        dataNodesTable.addColumnSchema(new AttributeColumnSchema("data_region_num", TSDataType.INT32));
        dataNodesTable.addColumnSchema(new AttributeColumnSchema("schema_region_num", TSDataType.INT32));
        dataNodesTable.addColumnSchema(new AttributeColumnSchema("rpc_address", TSDataType.STRING));
        dataNodesTable.addColumnSchema(new AttributeColumnSchema("rpc_port", TSDataType.INT32));
        dataNodesTable.addColumnSchema(new AttributeColumnSchema("mpp_port", TSDataType.INT32));
        dataNodesTable.addColumnSchema(new AttributeColumnSchema("data_consensus_port", TSDataType.INT32));
        dataNodesTable.addColumnSchema(new AttributeColumnSchema("schema_consensus_port", TSDataType.INT32));
        dataNodesTable.removeColumnSchema("time");
        schemaTables.put(DATA_NODES, dataNodesTable);
    }
}

