/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.resource.memory;

import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import org.apache.iotdb.db.pipe.resource.memory.PipeModelFixedMemoryBlock;
import org.apache.tsfile.utils.Pair;

public class PipeDynamicMemoryBlock {
    private final PipeModelFixedMemoryBlock fixedMemoryBlock;
    private boolean isExpandable = true;
    private Consumer<PipeDynamicMemoryBlock> expand = null;
    private volatile boolean released = false;
    private volatile long memoryUsageInBytes;
    private volatile double historyMemoryEfficiency;
    private volatile double currentMemoryEfficiency;

    PipeDynamicMemoryBlock(@NotNull PipeModelFixedMemoryBlock fixedMemoryBlock, long memoryUsageInBytes) {
        this.memoryUsageInBytes = Math.min(memoryUsageInBytes, 0L);
        this.fixedMemoryBlock = fixedMemoryBlock;
    }

    public long getMemoryUsageInBytes() {
        return this.memoryUsageInBytes;
    }

    public void setMemoryUsageInBytes(long memoryUsageInBytes) {
        this.memoryUsageInBytes = memoryUsageInBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Double, Double> getMemoryEfficiency() {
        PipeModelFixedMemoryBlock pipeModelFixedMemoryBlock = this.fixedMemoryBlock;
        synchronized (pipeModelFixedMemoryBlock) {
            return new Pair((Object)this.historyMemoryEfficiency, (Object)this.currentMemoryEfficiency);
        }
    }

    public void setExpandable(boolean expandable) {
        this.isExpandable = expandable;
    }

    public void setExpand(Consumer<PipeDynamicMemoryBlock> expand) {
        this.expand = expand;
    }

    public double getMemoryBlockUsageRatio() {
        return (double)this.memoryUsageInBytes / (double)this.fixedMemoryBlock.getMemoryUsageInBytes();
    }

    public double getFixedMemoryBlockUsageRatio() {
        return (double)this.fixedMemoryBlock.getMemoryAllocatedInBytes() / (double)this.fixedMemoryBlock.getMemoryUsageInBytes();
    }

    public long canAllocateMemorySize() {
        return this.fixedMemoryBlock.getMemoryUsageInBytes() - this.fixedMemoryBlock.getMemoryAllocatedInBytes();
    }

    public synchronized long getExpectedAverageAllocatedMemorySize() {
        return this.fixedMemoryBlock.getMemoryUsageInBytes() / (long)this.fixedMemoryBlock.getMemoryBlocks().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCurrentMemoryEfficiencyAdjustMem(double currentMemoryEfficiency) {
        PipeModelFixedMemoryBlock pipeModelFixedMemoryBlock = this.fixedMemoryBlock;
        synchronized (pipeModelFixedMemoryBlock) {
            this.historyMemoryEfficiency = this.currentMemoryEfficiency;
            if (Double.isNaN(currentMemoryEfficiency) || Double.isInfinite(currentMemoryEfficiency) || currentMemoryEfficiency < 0.0) {
                currentMemoryEfficiency = 0.0;
            }
            this.currentMemoryEfficiency = Math.min(currentMemoryEfficiency, 1.0);
            this.fixedMemoryBlock.dynamicallyAdjustMemory(this);
        }
    }

    public long getFixedMemoryCapacity() {
        return this.fixedMemoryBlock.getMemoryUsageInBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMemoryEfficiency(double currentMemoryEfficiency, double historyMemoryEfficiency) {
        PipeModelFixedMemoryBlock pipeModelFixedMemoryBlock = this.fixedMemoryBlock;
        synchronized (pipeModelFixedMemoryBlock) {
            if (Double.isNaN(currentMemoryEfficiency) || Double.isInfinite(currentMemoryEfficiency) || currentMemoryEfficiency < 0.0) {
                currentMemoryEfficiency = 0.0;
            }
            if (Double.isNaN(historyMemoryEfficiency) || Double.isInfinite(historyMemoryEfficiency) || historyMemoryEfficiency < 0.0) {
                currentMemoryEfficiency = 0.0;
            }
            this.historyMemoryEfficiency = Math.min(historyMemoryEfficiency, 1.0);
            this.currentMemoryEfficiency = Math.min(currentMemoryEfficiency, 1.0);
        }
    }

    public Stream<PipeDynamicMemoryBlock> getMemoryBlocks() {
        return this.fixedMemoryBlock.getMemoryBlocksStream();
    }

    public void applyForDynamicMemory(long memoryUsageInBytes) {
        this.fixedMemoryBlock.resetMemoryBlockSize(this, memoryUsageInBytes);
    }

    public boolean isReleased() {
        return this.released;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.released) {
            return;
        }
        PipeModelFixedMemoryBlock pipeModelFixedMemoryBlock = this.fixedMemoryBlock;
        synchronized (pipeModelFixedMemoryBlock) {
            if (!this.released) {
                this.fixedMemoryBlock.releaseMemory(this);
                this.released = true;
            }
        }
    }

    void doExpand() {
        if (this.isExpandable && this.expand != null) {
            this.expand.accept(this);
        }
    }
}

